/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.hops.hadoop.shaded.org.apache.commons.math3.util.Pair;
import io.hops.hadoop.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import io.hops.security.AbstractSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import java.security.Provider;
import java.security.Security;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppSecurityMaterialGeneratedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityMaterial;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;

public class RMAppSecurityManager
extends AbstractService
implements EventHandler<RMAppSecurityManagerEvent> {
    private static final Log LOG = LogFactory.getLog(RMAppSecurityManager.class);
    private static final Map<String, ChronoUnit> CHRONOUNITS = new HashMap<String, ChronoUnit>();
    private static final Pattern CONF_TIME_PATTERN;
    private RMContext rmContext;
    private Configuration conf;
    private EventHandler handler;
    private RMAppSecurityActions rmAppCertificateActions;
    private boolean isRPCTLSEnabled = false;
    private Map<Class, RMAppSecurityHandler> securityHandlersMap;
    private static final int RENEWAL_EXECUTOR_SERVICE_POOL_SIZE = 10;
    private ScheduledExecutorService renewalExecutorService;

    public RMAppSecurityManager(RMContext rmContext) {
        super(RMAppSecurityManager.class.getName());
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.rmContext = rmContext;
        this.securityHandlersMap = new HashMap<Class, RMAppSecurityHandler>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        LOG.debug((Object)"Initializing RMAppSecurityManager");
        this.conf = conf;
        this.handler = this.rmContext.getDispatcher().getEventHandler();
        this.rmAppCertificateActions = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(conf, conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        this.isRPCTLSEnabled = conf.getBoolean("ipc.server.ssl.enabled", false);
        this.renewalExecutorService = Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RMApp Security Material Renewer #%d").build());
        for (RMAppSecurityHandler handler : this.securityHandlersMap.values()) {
            handler.init(conf);
        }
        super.serviceInit(conf);
    }

    public void registerRMAppSecurityHandler(RMAppSecurityHandler securityHandler) {
        this.registerRMAppSecurityHandlerWithType(securityHandler, securityHandler.getClass());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void registerRMAppSecurityHandlerWithType(RMAppSecurityHandler securityHandler, Class type) {
        if (securityHandler != null) {
            this.securityHandlersMap.put(type, securityHandler);
        }
    }

    protected Pair<Long, TemporalUnit> parseInterval(String intervalFromConf, String confKey) {
        Matcher matcher = CONF_TIME_PATTERN.matcher(intervalFromConf);
        if (matcher.matches()) {
            Long interval = Long.parseLong(matcher.group(1));
            String unitStr = matcher.group(2);
            TemporalUnit unit = CHRONOUNITS.get(unitStr.toUpperCase());
            if (unit == null) {
                StringBuilder validUnits = new StringBuilder();
                for (String key : CHRONOUNITS.keySet()) {
                    validUnits.append(key).append(", ");
                }
                validUnits.append("\b\b");
                throw new IllegalArgumentException("Could not parse ChronoUnit: " + unitStr + ". Valid values are " + validUnits.toString());
            }
            return new Pair((Object)interval, (Object)unit);
        }
        throw new IllegalArgumentException("Could not parse value " + intervalFromConf + " of " + confKey);
    }

    protected void serviceStart() throws Exception {
        LOG.info((Object)"Starting RMAppSecurityManager");
        for (RMAppSecurityHandler handler : this.securityHandlersMap.values()) {
            handler.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info((Object)"Stopping RMAppCertificateManager");
        for (RMAppSecurityHandler handler : this.securityHandlersMap.values()) {
            handler.stop();
        }
        if (this.renewalExecutorService != null) {
            try {
                this.renewalExecutorService.shutdown();
                if (!this.renewalExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.renewalExecutorService.shutdownNow();
                }
                this.clearRMAppSecurityActionsFactory();
            }
            catch (InterruptedException ex) {
                this.renewalExecutorService.shutdownNow();
                if (this.rmAppCertificateActions != null && this.rmAppCertificateActions instanceof AbstractSecurityActions) {
                    ((AbstractSecurityActions)this.rmAppCertificateActions).stop();
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void clearRMAppSecurityActionsFactory() {
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
    }

    protected ScheduledExecutorService getRenewalExecutorService() {
        return this.renewalExecutorService;
    }

    protected BackOff createBackOffPolicy() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(200L).setMaximumIntervalMillis(5000L).setMultiplier(1.5).setMaximumRetries(4).build();
    }

    public void handle(RMAppSecurityManagerEvent event) {
        ApplicationId applicationId = event.getApplicationId();
        LOG.info((Object)("Processing event type: " + event.getType() + " for application: " + applicationId));
        if (((RMAppSecurityManagerEventType)event.getType()).equals((Object)RMAppSecurityManagerEventType.GENERATE_SECURITY_MATERIAL)) {
            this.generateSecurityMaterial(event);
        } else if (((RMAppSecurityManagerEventType)event.getType()).equals((Object)RMAppSecurityManagerEventType.REVOKE_SECURITY_MATERIAL)) {
            this.revokeSecurityMaterial(event);
        } else if (((RMAppSecurityManagerEventType)event.getType()).equals((Object)RMAppSecurityManagerEventType.REVOKE_CERTIFICATE_AFTER_ROTATION)) {
            this.revokeX509Only(event);
        } else if (((RMAppSecurityManagerEventType)event.getType()).equals((Object)RMAppSecurityManagerEventType.REVOKE_GENERATE_MATERIAL)) {
            this.revokeAndGenerateMaterial(event.getSecurityMaterial());
        } else {
            LOG.warn((Object)("Unknown event type " + event.getType()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <P extends SecurityManagerMaterial> void registerWithMaterialRenewers(P parameter) {
        if (parameter instanceof X509SecurityHandler.X509MaterialParameter) {
            X509SecurityHandler handler = (X509SecurityHandler)this.securityHandlersMap.get(X509SecurityHandler.class);
            if (handler != null) {
                handler.registerRenewer((X509SecurityHandler.X509MaterialParameter)parameter);
                return;
            }
            String errorMsg = "Tried to register with X.509 renewer but there is no handler";
            LOG.error((Object)errorMsg);
            throw new NullPointerException(errorMsg);
        }
        if (!(parameter instanceof JWTSecurityHandler.JWTMaterialParameter)) return;
        JWTSecurityHandler handler = (JWTSecurityHandler)this.securityHandlersMap.get(JWTSecurityHandler.class);
        if (handler != null) {
            handler.registerRenewer((JWTSecurityHandler.JWTMaterialParameter)parameter);
            return;
        }
        String errorMsg = "Tried to register with JWT renewer but there is no handler";
        throw new NullPointerException(errorMsg);
    }

    @VisibleForTesting
    public RMAppSecurityActions getRmAppCertificateActions() {
        return this.rmAppCertificateActions;
    }

    @VisibleForTesting
    public RMAppSecurityHandler getSecurityHandler(Class type) {
        return this.securityHandlersMap.get(type);
    }

    @VisibleForTesting
    protected RMContext getRmContext() {
        return this.rmContext;
    }

    private void generateSecurityMaterial(RMAppSecurityManagerEvent event) {
        ApplicationId appId = event.getApplicationId();
        RMAppSecurityMaterial rmAppMaterial = new RMAppSecurityMaterial();
        try {
            for (RMAppSecurityHandler handler : this.securityHandlersMap.values()) {
                Object material;
                if (handler instanceof X509SecurityHandler) {
                    X509SecurityHandler.X509MaterialParameter x509Param = (X509SecurityHandler.X509MaterialParameter)event.getSecurityMaterial().getMaterial(X509SecurityHandler.X509MaterialParameter.class);
                    if (x509Param == null) {
                        throw new NullPointerException("Hops TLS is enabled but X.509 parameter is null for " + appId);
                    }
                    material = handler.generateMaterial(x509Param);
                    if (material == null) continue;
                    rmAppMaterial.addMaterial(material);
                    continue;
                }
                if (!(handler instanceof JWTSecurityHandler)) continue;
                JWTSecurityHandler.JWTMaterialParameter jwtParam = (JWTSecurityHandler.JWTMaterialParameter)event.getSecurityMaterial().getMaterial(JWTSecurityHandler.JWTMaterialParameter.class);
                if (jwtParam == null) {
                    throw new NullPointerException("JWT on Yarn is enabled but JWT parameter is null for " + appId);
                }
                material = handler.generateMaterial(jwtParam);
                if (material == null) continue;
                rmAppMaterial.addMaterial(material);
            }
            if (rmAppMaterial.isEmpty()) {
                this.handler.handle((Event)new RMAppEvent(appId, RMAppEventType.SECURITY_MATERIAL_GENERATED));
            } else {
                this.handler.handle((Event)new RMAppSecurityMaterialGeneratedEvent(appId, rmAppMaterial, RMAppEventType.SECURITY_MATERIAL_GENERATED));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while generating RMApp security material", (Throwable)ex);
            this.handler.handle((Event)new RMAppEvent(appId, RMAppEventType.KILL, "Error while generating application security material for " + appId + " - " + ex.getMessage()));
        }
    }

    private void revokeX509Only(RMAppSecurityManagerEvent event) {
        RMAppSecurityHandler x509Handler = this.securityHandlersMap.get(X509SecurityHandler.class);
        if (x509Handler == null && this.isRPCTLSEnabled()) {
            LOG.error((Object)"Hops TLS is enabled but there is no X509SecurityHandler registered");
        } else {
            this.revokeX509(event, x509Handler);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void revokeSecurityMaterial(RMAppSecurityManagerEvent event) {
        for (RMAppSecurityHandler handler : this.securityHandlersMap.values()) {
            if (handler instanceof X509SecurityHandler) {
                this.revokeX509(event, handler);
                continue;
            }
            if (!(handler instanceof JWTSecurityHandler)) continue;
            this.revokeJWT(event, handler);
        }
    }

    private void revokeX509(RMAppSecurityManagerEvent event, RMAppSecurityHandler securityHandler) {
        ApplicationId appId = event.getApplicationId();
        X509SecurityHandler.X509MaterialParameter x509Param = (X509SecurityHandler.X509MaterialParameter)event.getSecurityMaterial().getMaterial(X509SecurityHandler.X509MaterialParameter.class);
        if (x509Param != null) {
            securityHandler.revokeMaterial(x509Param, false);
            LOG.debug((Object)("Revoked X.509 material for " + appId));
        }
    }

    private void revokeJWT(RMAppSecurityManagerEvent event, RMAppSecurityHandler securityHandler) {
        JWTSecurityHandler.JWTMaterialParameter jwtParam = (JWTSecurityHandler.JWTMaterialParameter)event.getSecurityMaterial().getMaterial(JWTSecurityHandler.JWTMaterialParameter.class);
        if (jwtParam != null) {
            securityHandler.revokeMaterial(jwtParam, false);
            LOG.debug((Object)("Revoked JWT material for " + jwtParam.getApplicationId()));
        }
    }

    public <P extends SecurityManagerMaterial> void revokeSecurityMaterialSync(P parameter) {
        if (parameter instanceof X509SecurityHandler.X509MaterialParameter) {
            X509SecurityHandler handler = (X509SecurityHandler)this.securityHandlersMap.get(X509SecurityHandler.class);
            handler.revokeMaterial((X509SecurityHandler.X509MaterialParameter)parameter, (Boolean)true);
        }
    }

    public void revokeAndGenerateMaterial(RMAppSecurityMaterial securityMaterial) {
        X509SecurityHandler.X509MaterialParameter x509Param = (X509SecurityHandler.X509MaterialParameter)securityMaterial.getMaterial(X509SecurityHandler.X509MaterialParameter.class);
        boolean exceptionThrown = false;
        boolean x509Revoked = false;
        ApplicationId applicationId = null;
        RMAppSecurityMaterial<SecurityManagerMaterial> newSecurityMaterial = new RMAppSecurityMaterial<SecurityManagerMaterial>();
        X509SecurityHandler x509Handler = (X509SecurityHandler)this.securityHandlersMap.get(X509SecurityHandler.class);
        JWTSecurityHandler jwtHandler = (JWTSecurityHandler)this.securityHandlersMap.get(JWTSecurityHandler.class);
        if (x509Param != null) {
            applicationId = x509Param.getApplicationId();
            x509Revoked = x509Handler.revokeMaterial(x509Param, (Boolean)true);
        }
        if (x509Revoked && !exceptionThrown) {
            try {
                X509SecurityHandler.X509SecurityManagerMaterial newX509 = x509Handler.generateMaterial(x509Param);
                if (newX509 != null) {
                    newSecurityMaterial.addMaterial(newX509);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Error when generating X.509 material for " + x509Param.getApplicationId()), (Throwable)ex);
                exceptionThrown = true;
            }
            JWTSecurityHandler.JWTMaterialParameter jwtParam = (JWTSecurityHandler.JWTMaterialParameter)securityMaterial.getMaterial(JWTSecurityHandler.JWTMaterialParameter.class);
            if (!exceptionThrown) {
                try {
                    if (jwtParam != null) {
                        JWTSecurityHandler.JWTSecurityManagerMaterial newJwt;
                        if (applicationId == null) {
                            applicationId = jwtParam.getApplicationId();
                        }
                        if ((newJwt = jwtHandler.generateMaterial(jwtParam)) != null) {
                            newSecurityMaterial.addMaterial(newJwt);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("Error when generating JWT material for " + applicationId), (Throwable)ex);
                    exceptionThrown = true;
                }
            }
            if (exceptionThrown) {
                JWTSecurityHandler.JWTSecurityManagerMaterial generatedJWT;
                X509SecurityHandler.X509SecurityManagerMaterial generatedX509 = (X509SecurityHandler.X509SecurityManagerMaterial)newSecurityMaterial.getMaterial(X509SecurityHandler.X509SecurityManagerMaterial.class);
                if (generatedX509 != null) {
                    int version2revoke = x509Param.getCryptoMaterialVersion() + 1;
                    X509SecurityHandler.X509MaterialParameter x5092revoke = new X509SecurityHandler.X509MaterialParameter(x509Param.getApplicationId(), x509Param.getAppUser(), version2revoke);
                    x509Handler.revokeMaterial(x5092revoke, (Boolean)false);
                }
                if ((generatedJWT = (JWTSecurityHandler.JWTSecurityManagerMaterial)newSecurityMaterial.getMaterial(JWTSecurityHandler.JWTSecurityManagerMaterial.class)) != null) {
                    jwtHandler.revokeMaterial(jwtParam, (Boolean)false);
                }
                this.handler.handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Error while revoking and generating new security material for " + applicationId));
            } else if (newSecurityMaterial.isEmpty()) {
                this.handler.handle((Event)new RMAppEvent(applicationId, RMAppEventType.SECURITY_MATERIAL_GENERATED));
            } else {
                this.handler.handle((Event)new RMAppSecurityMaterialGeneratedEvent(applicationId, newSecurityMaterial, RMAppEventType.SECURITY_MATERIAL_GENERATED));
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isRPCTLSEnabled() {
        return this.isRPCTLSEnabled;
    }

    static {
        CHRONOUNITS.put("MS", ChronoUnit.MILLIS);
        CHRONOUNITS.put("S", ChronoUnit.SECONDS);
        CHRONOUNITS.put("M", ChronoUnit.MINUTES);
        CHRONOUNITS.put("H", ChronoUnit.HOURS);
        CHRONOUNITS.put("D", ChronoUnit.DAYS);
        CONF_TIME_PATTERN = Pattern.compile("(^[0-9]+)(\\p{Alpha}+)");
    }

    public static abstract class SecurityManagerMaterial {
        private final ApplicationId applicationId;

        protected SecurityManagerMaterial(ApplicationId applicationId) {
            this.applicationId = applicationId;
        }

        public ApplicationId getApplicationId() {
            return this.applicationId;
        }
    }
}

