/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.TestUtils;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileTxnSnapLogTest {
    private File tmpDir;
    private File logDir;
    private File snapDir;
    private File logVersionDir;
    private File snapVersionDir;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createEmptyTestDir();
        this.logDir = new File(this.tmpDir, "logdir");
        this.snapDir = new File(this.tmpDir, "snapdir");
    }

    @After
    public void tearDown() throws Exception {
        if (this.tmpDir != null) {
            TestUtils.deleteFileRecursively((File)this.tmpDir);
        }
        this.tmpDir = null;
        this.logDir = null;
        this.snapDir = null;
        this.logVersionDir = null;
        this.snapVersionDir = null;
    }

    private File createVersionDir(File parentDir) {
        File versionDir = new File(parentDir, "version-2");
        versionDir.mkdirs();
        return versionDir;
    }

    private void createLogFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeLogName(zxid));
        file.createNewFile();
    }

    private void createSnapshotFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeSnapshotName(zxid));
        file.createNewFile();
    }

    private void twoDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.snapVersionDir = this.createVersionDir(this.snapDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.snapVersionDir, 1L);
        this.createSnapshotFile(this.snapVersionDir, 2L);
    }

    private void singleDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.logVersionDir, 1L);
        this.createSnapshotFile(this.logVersionDir, 2L);
    }

    @Test
    public void testDirCheckWithCorrectFiles() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        try {
            new FileTxnSnapLog(this.logDir, this.snapDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException e) {
            Assert.fail((String)"Should not throw LogDirContentCheckException.");
        }
        catch (FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw SnapDirContentCheckException.");
        }
    }

    @Test
    public void testDirCheckWithSingleDirSetup() throws IOException {
        this.singleDirSetupWithCorrectFiles();
        try {
            new FileTxnSnapLog(this.logDir, this.logDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException e) {
            Assert.fail((String)"Should not throw LogDirContentCheckException.");
        }
        catch (FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw SnapDirContentCheckException.");
        }
    }

    @Test(expected=FileTxnSnapLog.LogDirContentCheckException.class)
    public void testDirCheckWithSnapFilesInLogDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createSnapshotFile(this.logVersionDir, 3L);
        this.createSnapshotFile(this.logVersionDir, 4L);
        new FileTxnSnapLog(this.logDir, this.snapDir);
    }

    @Test(expected=FileTxnSnapLog.SnapDirContentCheckException.class)
    public void testDirCheckWithLogFilesInSnapDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createLogFile(this.snapVersionDir, 3L);
        this.createLogFile(this.snapVersionDir, 4L);
        new FileTxnSnapLog(this.logDir, this.snapDir);
    }
}

