/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.Time;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.DeleteTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.MultiTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.Txn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFromLogNoServerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LoadFromLogNoServerTest.class);

    @Test
    public void testTxnFailure() throws Exception {
        long count = 1L;
        File tmpDir = ClientBase.createTmpDir();
        FileTxnSnapLog logFile = new FileTxnSnapLog(tmpDir, tmpDir);
        DataTree dt = new DataTree();
        dt.createNode("/test", new byte[0], null, 0L, -1, 1L, 1L);
        for (count = 1L; count <= 3L; ++count) {
            dt.createNode("/test/" + count, new byte[0], null, 0L, -1, count, Time.currentElapsedTime());
        }
        DataNode zk = dt.getNode("/test");
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, -1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, -1);
    }

    private void doOp(FileTxnSnapLog logFile, int type, String path, DataTree dt, DataNode parent, int cversion) throws Exception {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        int prevCversion = parent.stat.getCversion();
        long prevPzxid = parent.stat.getPzxid();
        List<String> child = dt.getChildren(parentName, null, null);
        String childStr = "";
        for (String s : child) {
            childStr = childStr + s + " ";
        }
        LOG.info("Children: " + childStr + " for " + parentName);
        LOG.info("(cverions, pzxid): " + prevCversion + ", " + prevPzxid);
        Record txn = null;
        TxnHeader txnHeader = null;
        if (type == 2) {
            txn = new DeleteTxn(path);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 2);
        } else if (type == 1) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
        } else if (type == 14) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
            ArrayList<Txn> txnList = new ArrayList<Txn>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            txn.serialize(boa, "request");
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            Txn txact = new Txn(1, bb.array());
            txnList.add(txact);
            txn = new MultiTxn(txnList);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 14);
        }
        logFile.processTransaction(txnHeader, dt, null, txn);
        int newCversion = parent.stat.getCversion();
        long newPzxid = parent.stat.getPzxid();
        child = dt.getChildren(parentName, null, null);
        childStr = "";
        for (String s : child) {
            childStr = childStr + s + " ";
        }
        LOG.info("Children: " + childStr + " for " + parentName);
        LOG.info("(cverions, pzxid): " + newCversion + ", " + newPzxid);
        Assert.assertTrue((String)(type + " <cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"), (newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0);
    }

    @Test
    public void testPad() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        FileTxnLog txnLog = new FileTxnLog(tmpDir);
        TxnHeader txnHeader = new TxnHeader(43981L, 291, 291L, Time.currentElapsedTime(), 1);
        CreateTxn txn = new CreateTxn("/Test", new byte[0], null, false, 1);
        txnLog.append(txnHeader, txn);
        FileInputStream in = new FileInputStream(tmpDir.getPath() + "/log." + Long.toHexString(txnHeader.getZxid()));
        BinaryInputArchive ia = BinaryInputArchive.getArchive(in);
        FileHeader header = new FileHeader();
        header.deserialize(ia, "fileheader");
        LOG.info("Received magic : " + header.getMagic() + " Expected : " + FileTxnLog.TXNLOG_MAGIC);
        Assert.assertTrue((String)"Missing magic number ", (header.getMagic() == FileTxnLog.TXNLOG_MAGIC ? 1 : 0) != 0);
    }
}

