/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.executor;

import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.util.ThreadFactoryUtil;
import io.hops.hadoop.shaded.org.ehcache.spi.service.Service;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OnDemandExecutionService
implements ExecutionService {
    private static final RejectedExecutionHandler WAIT_FOR_SPACE = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
            boolean interrupted = false;
            while (true) {
                try {
                    tpe.getQueue().put(r);
                    return;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    };

    @Override
    public ScheduledExecutorService getScheduledExecutor(String poolAlias) {
        return Executors.unconfigurableScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtil.threadFactory(poolAlias)));
    }

    @Override
    public ExecutorService getOrderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, queue, ThreadFactoryUtil.threadFactory(poolAlias), WAIT_FOR_SPACE);
        executor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(executor);
    }

    @Override
    public ExecutorService getUnorderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, queue, ThreadFactoryUtil.threadFactory(poolAlias), WAIT_FOR_SPACE);
        executor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(executor);
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
    }

    @Override
    public void stop() {
    }
}

