/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http.server;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.WriteHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Writer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpContent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpPacket;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpRequestPacket;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.Method;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.filecache.FileCache;
import java.io.IOException;

public class FileCacheFilter
extends BaseFilter {
    private final FileCache fileCache;

    public FileCacheFilter(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    @Override
    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        HttpPacket response;
        HttpContent requestContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        if (this.fileCache.isEnabled() && Method.GET.equals(request.getMethod()) && (response = this.fileCache.get(request)) != null) {
            AsyncQueueWriter asyncQueueWriter;
            ctx.write(response);
            Connection connection = ctx.getConnection();
            Writer writer = connection.getTransport().getWriter(connection);
            if (writer instanceof AsyncQueueWriter && !(asyncQueueWriter = (AsyncQueueWriter)writer).canWrite(connection, 1)) {
                NextAction suspendAction = ctx.getSuspendAction();
                ctx.suspend();
                asyncQueueWriter.notifyWritePossible(connection, new WriteHandler(){

                    @Override
                    public void onWritePossible() throws Exception {
                        this.finish();
                    }

                    @Override
                    public void onError(Throwable t) {
                        this.finish();
                    }

                    private void finish() {
                        ctx.completeAndRecycle();
                    }
                }, 1);
                return suspendAction;
            }
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }
}

