/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.config.builders;

import io.hops.hadoop.shaded.org.ehcache.config.Builder;
import io.hops.hadoop.shaded.org.ehcache.impl.config.loaderwriter.writebehind.DefaultBatchingConfiguration;
import io.hops.hadoop.shaded.org.ehcache.impl.config.loaderwriter.writebehind.DefaultWriteBehindConfiguration;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import java.util.concurrent.TimeUnit;

public abstract class WriteBehindConfigurationBuilder
implements Builder<WriteBehindConfiguration> {
    protected int concurrency = 1;
    protected int queueSize = Integer.MAX_VALUE;
    protected String threadPoolAlias = null;

    private WriteBehindConfigurationBuilder() {
    }

    private WriteBehindConfigurationBuilder(WriteBehindConfigurationBuilder other) {
        this.concurrency = other.concurrency;
        this.queueSize = other.queueSize;
        this.threadPoolAlias = other.threadPoolAlias;
    }

    public static BatchedWriteBehindConfigurationBuilder newBatchedWriteBehindConfiguration(long maxDelay, TimeUnit maxDelayUnit, int batchSize) {
        return new BatchedWriteBehindConfigurationBuilder(maxDelay, maxDelayUnit, batchSize);
    }

    public static UnBatchedWriteBehindConfigurationBuilder newUnBatchedWriteBehindConfiguration() {
        return new UnBatchedWriteBehindConfigurationBuilder();
    }

    WriteBehindConfiguration buildWith(WriteBehindConfiguration.BatchingConfiguration batching) {
        return new DefaultWriteBehindConfiguration(this.threadPoolAlias, this.concurrency, this.queueSize, batching);
    }

    public abstract WriteBehindConfigurationBuilder queueSize(int var1);

    public abstract WriteBehindConfigurationBuilder concurrencyLevel(int var1);

    public abstract WriteBehindConfigurationBuilder useThreadPool(String var1);

    public static class UnBatchedWriteBehindConfigurationBuilder
    extends WriteBehindConfigurationBuilder {
        private UnBatchedWriteBehindConfigurationBuilder() {
        }

        private UnBatchedWriteBehindConfigurationBuilder(UnBatchedWriteBehindConfigurationBuilder other) {
            super(other);
        }

        @Override
        public WriteBehindConfiguration build() {
            return this.buildWith(null);
        }

        @Override
        public UnBatchedWriteBehindConfigurationBuilder queueSize(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("Queue size must be positive, was: " + size);
            }
            UnBatchedWriteBehindConfigurationBuilder otherBuilder = new UnBatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.queueSize = size;
            return otherBuilder;
        }

        @Override
        public UnBatchedWriteBehindConfigurationBuilder concurrencyLevel(int concurrency) {
            if (concurrency < 1) {
                throw new IllegalArgumentException("Concurrency must be positive, was: " + concurrency);
            }
            UnBatchedWriteBehindConfigurationBuilder otherBuilder = new UnBatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.concurrency = concurrency;
            return otherBuilder;
        }

        @Override
        public UnBatchedWriteBehindConfigurationBuilder useThreadPool(String alias) {
            UnBatchedWriteBehindConfigurationBuilder otherBuilder = new UnBatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.threadPoolAlias = alias;
            return otherBuilder;
        }
    }

    public static final class BatchedWriteBehindConfigurationBuilder
    extends WriteBehindConfigurationBuilder {
        private TimeUnit maxDelayUnit;
        private long maxDelay;
        private int batchSize;
        private boolean coalescing = false;

        private BatchedWriteBehindConfigurationBuilder(long maxDelay, TimeUnit maxDelayUnit, int batchSize) {
            this.setMaxWriteDelay(maxDelay, maxDelayUnit);
            this.setBatchSize(batchSize);
        }

        private BatchedWriteBehindConfigurationBuilder(BatchedWriteBehindConfigurationBuilder other) {
            super(other);
            this.maxDelay = other.maxDelay;
            this.maxDelayUnit = other.maxDelayUnit;
            this.coalescing = other.coalescing;
            this.batchSize = other.batchSize;
        }

        public BatchedWriteBehindConfigurationBuilder enableCoalescing() {
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.coalescing = true;
            return otherBuilder;
        }

        public BatchedWriteBehindConfigurationBuilder disableCoalescing() {
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.coalescing = false;
            return otherBuilder;
        }

        public BatchedWriteBehindConfigurationBuilder batchSize(int batchSize) {
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.setBatchSize(batchSize);
            return otherBuilder;
        }

        private void setBatchSize(int batchSize) throws IllegalArgumentException {
            if (batchSize < 1) {
                throw new IllegalArgumentException("Batch size must be a positive integer, was: " + batchSize);
            }
            this.batchSize = batchSize;
        }

        public BatchedWriteBehindConfigurationBuilder maxWriteDelay(long maxDelay, TimeUnit maxDelayUnit) {
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.setMaxWriteDelay(maxDelay, maxDelayUnit);
            return otherBuilder;
        }

        private void setMaxWriteDelay(long maxDelay, TimeUnit maxDelayUnit) throws IllegalArgumentException {
            if (maxDelay < 1L) {
                throw new IllegalArgumentException("Max batch delay must be positive, was: " + maxDelay + " " + (Object)((Object)maxDelayUnit));
            }
            this.maxDelay = maxDelay;
            this.maxDelayUnit = maxDelayUnit;
        }

        @Override
        public BatchedWriteBehindConfigurationBuilder queueSize(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("Queue size must be positive, was: " + size);
            }
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.queueSize = size;
            return otherBuilder;
        }

        @Override
        public BatchedWriteBehindConfigurationBuilder concurrencyLevel(int concurrency) {
            if (concurrency < 1) {
                throw new IllegalArgumentException("Concurrency must be positive, was: " + concurrency);
            }
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.concurrency = concurrency;
            return otherBuilder;
        }

        @Override
        public BatchedWriteBehindConfigurationBuilder useThreadPool(String alias) {
            BatchedWriteBehindConfigurationBuilder otherBuilder = new BatchedWriteBehindConfigurationBuilder(this);
            otherBuilder.threadPoolAlias = alias;
            return otherBuilder;
        }

        @Override
        public WriteBehindConfiguration build() {
            return this.buildWith(new DefaultBatchingConfiguration(this.maxDelay, this.maxDelayUnit, this.batchSize, this.coalescing));
        }
    }
}

