/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.Ace;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class AcesLock
extends Lock {
    protected void acquire(TransactionLocks locks) throws IOException {
        BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
        for (INode inode : inodeLock.getAllResolvedINodes()) {
            if (inode.getNumAces() <= 0) continue;
            int[] indices = new int[inode.getNumAces()];
            for (int i = 0; i < inode.getNumAces(); ++i) {
                indices[i] = i;
            }
            this.acquireLockList(TransactionLockTypes.LockType.WRITE, (FinderType)Ace.Finder.ByInodeIdAndIndices, new Object[]{inode.getId(), indices});
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.Ace;
    }
}

