/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.strategies;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOStrategy;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Transport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import io.hops.hadoop.shaded.org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import java.io.IOException;

public final class SimpleDynamicNIOStrategy
implements IOStrategy {
    private static final SimpleDynamicNIOStrategy INSTANCE = new SimpleDynamicNIOStrategy();
    private final SameThreadIOStrategy sameThreadStrategy = SameThreadIOStrategy.getInstance();
    private final WorkerThreadIOStrategy workerThreadStrategy = WorkerThreadIOStrategy.getInstance();
    private static final int WORKER_THREAD_THRESHOLD = 1;

    private SimpleDynamicNIOStrategy() {
    }

    public static SimpleDynamicNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        return this.executeIoEvent(connection, ioEvent, true);
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        int lastSelectedKeysCount = SimpleDynamicNIOStrategy.getLastSelectedKeysCount(connection);
        return lastSelectedKeysCount <= 1 ? this.sameThreadStrategy.executeIoEvent(connection, ioEvent, isIoEventEnabled) : this.workerThreadStrategy.executeIoEvent(connection, ioEvent, isIoEventEnabled);
    }

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig().copy();
        int selectorRunnerCount = ((NIOTransport)transport).getSelectorRunnersCount();
        config.setCorePoolSize(selectorRunnerCount * 2);
        config.setMaxPoolSize(selectorRunnerCount * 2);
        config.setMemoryManager(transport.getMemoryManager());
        return config;
    }

    private static int getLastSelectedKeysCount(Connection c) {
        return ((NIOConnection)c).getSelectorRunner().getLastSelectedKeysCount();
    }
}

