/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.verification.checkers;

import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationsFinder;
import io.hops.hadoop.shaded.org.mockito.internal.reporting.SmartPrinter;
import io.hops.hadoop.shaded.org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingInvocationChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;

    public MissingInvocationChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    MissingInvocationChecker(InvocationsFinder finder, Reporter reporter) {
        this.finder = finder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted) {
        List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
        if (actualInvocations.isEmpty()) {
            Invocation similar = this.finder.findSimilarInvocation(invocations, wanted);
            if (similar != null) {
                ArgumentMatchingTool argumentMatchingTool = new ArgumentMatchingTool();
                Integer[] indexesOfSuspiciousArgs = argumentMatchingTool.getSuspiciouslyNotMatchingArgsIndexes(wanted.getMatchers(), similar.getArguments());
                SmartPrinter smartPrinter = new SmartPrinter(wanted, similar, indexesOfSuspiciousArgs);
                this.reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActual(), similar.getLocation());
            } else {
                this.reporter.wantedButNotInvoked(wanted, invocations);
            }
        }
    }
}

