/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.Time;

class FSDirConcatOp {
    FSDirConcatOp() {
    }

    static HdfsFileStatus concat(final FSDirectory fsd, final String target, final String[] srcs) throws IOException {
        Preconditions.checkArgument((!target.isEmpty() ? 1 : 0) != 0, (Object)"Target file name is empty");
        Preconditions.checkArgument((srcs != null && srcs.length > 0 ? 1 : 0) != 0, (Object)"No sources given");
        assert (srcs != null);
        if (FSDirectory.LOG.isDebugEnabled()) {
            FSDirectory.LOG.debug("concat {} to {}", (Object)Arrays.toString(srcs), (Object)target);
        }
        final String[] paths = new String[srcs.length + 1];
        System.arraycopy(srcs, 0, paths, 0, srcs.length);
        paths[srcs.length] = target;
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.CONCAT){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, paths).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                LockFactory.BLK[] bLKArray = new LockFactory.BLK[6];
                bLKArray[0] = LockFactory.BLK.RE;
                bLKArray[1] = LockFactory.BLK.CR;
                bLKArray[2] = LockFactory.BLK.ER;
                bLKArray[3] = LockFactory.BLK.PE;
                bLKArray[4] = LockFactory.BLK.UC;
                bLKArray[5] = LockFactory.BLK.IV;
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(bLKArray));
                if (fsd.getFSNamesystem().isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                if (fsd.getFSNamesystem().isErasureCodingEnabled()) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, srcs));
                }
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    INodesInPath targetIIP = fsd.getINodesInPath4Write(target);
                    FSPermissionChecker pc = null;
                    if (fsd.isPermissionEnabled()) {
                        pc = fsd.getPermissionChecker();
                        fsd.checkPathAccess(pc, targetIIP, FsAction.WRITE);
                    }
                    FSDirConcatOp.verifyTargetFile(fsd, target, targetIIP);
                    INodeFile[] srcFiles = FSDirConcatOp.verifySrcFiles(fsd, srcs, targetIIP, pc);
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target);
                    }
                    long timestamp = Time.now();
                    FSDirConcatOp.unprotectedConcat(fsd, targetIIP, srcFiles, timestamp);
                    success = true;
                    HdfsFileStatus hdfsFileStatus = fsd.getAuditFileInfo(targetIIP);
                    return hdfsFileStatus;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
            }
        }.handle();
    }

    private static void verifyTargetFile(FSDirectory fsd, String target, INodesInPath targetIIP) throws IOException {
        if (fsd.getEZForPath(targetIIP) != null) {
            throw new HadoopIllegalArgumentException("concat can not be called for files in an encryption zone.");
        }
        INodeFile targetINode = INodeFile.valueOf(targetIIP.getLastINode(), target);
        if (targetINode.isFileStoredInDB()) {
            throw new IOException("The target file is stored in the database. Can not concat to a a file stored in the database");
        }
        if (targetINode.isUnderConstruction()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is under construction");
        }
    }

    private static INodeFile[] verifySrcFiles(FSDirectory fsd, String[] srcs, INodesInPath targetIIP, FSPermissionChecker pc) throws IOException {
        LinkedHashSet<INodeFile> si = new LinkedHashSet<INodeFile>();
        INodeFile targetINode = targetIIP.getLastINode().asFile();
        INodeDirectory targetParent = targetINode.getParent();
        for (String src : srcs) {
            INode srcINode;
            INodeFile srcINodeFile;
            INodesInPath iip = fsd.getINodesInPath4Write(src);
            if (pc != null) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
                fsd.checkParentAccess(pc, iip, FsAction.WRITE);
            }
            if ((srcINodeFile = INodeFile.valueOf(srcINode = iip.getLastINode(), src)).getParent() != targetParent) {
                throw new HadoopIllegalArgumentException("Source file " + src + " is not in the same directory with the target " + targetIIP.getPath());
            }
            if (srcINode == targetINode) {
                throw new HadoopIllegalArgumentException("concat: the src file " + src + " is the same with the target file " + targetIIP.getPath());
            }
            if (srcINodeFile.getStoragePolicyID() == 14) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is stored in DB.");
            }
            if (srcINodeFile.isUnderConstruction() || srcINodeFile.numBlocks() == 0) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (srcINodeFile.getPreferredBlockSize() > targetINode.getPreferredBlockSize()) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " has preferred block size " + srcINodeFile.getPreferredBlockSize() + " which is greater than the target file's preferred block size " + targetINode.getPreferredBlockSize());
            }
            si.add(srcINodeFile);
        }
        if (si.size() < srcs.length) {
            throw new HadoopIllegalArgumentException("concat: at least two of the source files are the same");
        }
        return si.toArray(new INodeFile[si.size()]);
    }

    private static QuotaCounts computeQuotaDeltas(FSDirectory fsd, INodeFile target, INodeFile[] srcList) throws StorageException, TransactionContextException {
        QuotaCounts deltas = new QuotaCounts.Builder().build();
        short targetRepl = target.getBlockReplication();
        for (INodeFile src : srcList) {
            short srcRepl = src.getBlockReplication();
            long fileSize = src.computeFileSize();
            if (targetRepl == srcRepl) continue;
            deltas.addStorageSpace(fileSize * (long)(targetRepl - srcRepl));
            BlockStoragePolicy bsp = fsd.getBlockStoragePolicySuite().getPolicy(src.getStoragePolicyID());
            if (bsp == null) continue;
            List srcTypeChosen = bsp.chooseStorageTypes(srcRepl);
            for (StorageType t : srcTypeChosen) {
                if (!t.supportTypeQuota()) continue;
                deltas.addTypeSpace(t, -fileSize);
            }
            List targetTypeChosen = bsp.chooseStorageTypes(targetRepl);
            for (StorageType t : targetTypeChosen) {
                if (!t.supportTypeQuota()) continue;
                deltas.addTypeSpace(t, fileSize);
            }
        }
        return deltas;
    }

    private static void verifyQuota(FSDirectory fsd, INodesInPath targetIIP, QuotaCounts deltas) throws QuotaExceededException, StorageException, TransactionContextException {
        if (!fsd.getFSNamesystem().isImageLoaded()) {
            return;
        }
        FSDirectory.verifyQuota(targetIIP, targetIIP.length() - 1, deltas, null);
    }

    static void unprotectedConcat(FSDirectory fsd, INodesInPath targetIIP, INodeFile[] srcList, long timestamp) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSNamesystem.concat to " + targetIIP.getPath());
        }
        INodeFile trgInode = targetIIP.getLastINode().asFile();
        QuotaCounts deltas = FSDirConcatOp.computeQuotaDeltas(fsd, trgInode, srcList);
        FSDirConcatOp.verifyQuota(fsd, targetIIP, deltas);
        INodeDirectory trgParent = targetIIP.getINode(-2).asDirectory();
        List<BlockInfoContiguous> oldBlks = trgInode.concatBlocks(srcList);
        INodeCandidatePrimaryKey trg_param = new INodeCandidatePrimaryKey(trgInode.getId());
        ArrayList<INodeCandidatePrimaryKey> srcs_param = new ArrayList<INodeCandidatePrimaryKey>();
        for (INodeFile allSrcInode : srcList) {
            srcs_param.add(new INodeCandidatePrimaryKey(allSrcInode.getId()));
        }
        int count = 0;
        for (INodeFile nodeToRemove : srcList) {
            if (nodeToRemove == null) continue;
            nodeToRemove.getParent().removeChild(nodeToRemove);
            ++count;
        }
        trgInode.setModificationTime(timestamp);
        trgParent.updateModificationTime(timestamp);
        fsd.unprotectedUpdateCount(targetIIP, targetIIP.length() - 1, deltas);
        EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.Concat, (Object[])new Object[]{trg_param, srcs_param, oldBlks});
    }
}

