/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.ZooKeeperSaslClient;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.security.auth.login.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthDesignatedClientTest
extends ClientBase {
    @Test
    public void testAuth() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Thread.sleep(1000L);
        }
        catch (KeeperException e) {
            Assert.fail((String)("test failed :" + e));
        }
        finally {
            zk.close();
        }
    }

    @Test
    public void testSaslConfig() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.getChildren("/", false);
            Assert.assertFalse((boolean)zk.getSaslClient().clientTunneledAuthenticationInProgress());
            Assert.assertEquals((Object)((Object)zk.getSaslClient().getSaslState()), (Object)((Object)ZooKeeperSaslClient.SaslState.COMPLETE));
            Assert.assertNotNull((Object)Configuration.getConfiguration().getAppConfigurationEntry("MyZookeeperClient"));
            Assert.assertSame((Object)zk.getSaslClient().getLoginContext(), (Object)"MyZookeeperClient");
        }
        catch (KeeperException e) {
            Assert.fail((String)("test failed :" + e));
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.sasl.clientconfig", "MyZookeeperClient");
        try {
            File tmpDir = SaslAuthDesignatedClientTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_myuser=\"mypassword\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"wrongpassword\";\n};MyZookeeperClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"mypassword\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

