/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.entity.FileInodeData;
import io.hops.transaction.EntityManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;

@InterfaceAudience.Private
public class INodeFile
extends INodeWithAdditionalFields
implements BlockCollection {
    private int generationStamp = 1000;
    private long size = 0L;
    private boolean isFileStoredInDB = false;
    private Set<Block> removedBlocks = new HashSet<Block>();

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException, StorageException, TransactionContextException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException, StorageException, TransactionContextException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    public INodeFile(long id, PermissionStatus permissions, BlockInfoContiguous[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize, byte storagePolicyID) throws IOException {
        this(id, permissions, blklist, replication, modificationTime, atime, preferredBlockSize, storagePolicyID, false);
    }

    public INodeFile(long id, PermissionStatus permissions, BlockInfoContiguous[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize, byte storagePolicyID, boolean inTree) throws IOException {
        super(id, permissions, modificationTime, atime, inTree);
        this.header = INode.HeaderFormat.toLong(preferredBlockSize, replication);
        this.setFileStoredInDBNoPersistence(false);
        this.setBlockStoragePolicyIDNoPersistance(storagePolicyID);
    }

    public INodeFile(long id, PermissionStatus permissions, long header, long modificationTime, long atime, boolean isFileStoredInDB, byte storagepolicy, boolean inTree) throws IOException {
        super(id, permissions, modificationTime, atime, inTree);
        this.header = header;
        this.isFileStoredInDB = isFileStoredInDB;
        this.blockStoragePolicyID = storagepolicy;
    }

    public INodeFile(INodeFile other) throws IOException {
        super(other);
        this.setGenerationStampNoPersistence(other.getGenerationStamp());
        this.setSizeNoPersistence(other.getSize());
        this.setFileStoredInDBNoPersistence(other.isFileStoredInDB());
        this.setPartitionIdNoPersistance(other.getPartitionId());
        this.header = other.getHeader();
        this.features = other.features;
    }

    public final FileUnderConstructionFeature getFileUnderConstructionFeature() {
        for (INode.Feature f : this.features) {
            if (!(f instanceof FileUnderConstructionFeature)) continue;
            return (FileUnderConstructionFeature)f;
        }
        return null;
    }

    @Override
    public boolean isUnderConstruction() {
        return this.getFileUnderConstructionFeature() != null;
    }

    @Override
    public short getBlockReplication() {
        return INode.HeaderFormat.getReplication(this.header);
    }

    @Override
    public byte getStoragePolicyID() throws TransactionContextException, StorageException {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    @Override
    public long getPreferredBlockSize() {
        return INode.HeaderFormat.getPreferredBlockSize(this.header);
    }

    @Override
    public BlockInfoContiguous getBlock(int index) throws TransactionContextException, StorageException {
        return (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByINodeIdAndIndex, (Object[])new Object[]{this.id, index}));
    }

    @Override
    public BlockInfoContiguous[] getBlocks() throws StorageException, TransactionContextException {
        if (this.isFileStoredInDB()) {
            FSNamesystem.LOG.debug((Object)"Stuffed Inode:  getBlocks(). the file is stored in the database. Returning empty list of blocks");
            return BlockInfoContiguous.EMPTY_ARRAY;
        }
        List<BlockInfoContiguous> blocks = this.getBlocksOrderedByIndex();
        if (blocks == null) {
            return BlockInfoContiguous.EMPTY_ARRAY;
        }
        BlockInfoContiguous[] blks = new BlockInfoContiguous[blocks.size()];
        return blocks.toArray(blks);
    }

    public void storeFileDataInDB(byte[] data) throws StorageException {
        FileInodeData fid;
        int len = data.length;
        InMemoryInodeDataAccess fida = null;
        if (len <= FSNamesystem.getDBInMemBucketSize()) {
            fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
            fid = new FileInodeData(this.getId(), data, data.length, FileInodeData.Type.InmemoryFile);
        } else {
            if (len <= FSNamesystem.getDBOnDiskSmallBucketSize()) {
                fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
            } else if (len <= FSNamesystem.getDBOnDiskMediumBucketSize()) {
                fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
            } else if (len <= FSNamesystem.getMaxSmallFileSize()) {
                fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
            } else {
                StorageException up = new StorageException("The data is too large to be stored in the database. Requested data size is : " + len);
                throw up;
            }
            fid = new FileInodeData(this.getId(), data, data.length, FileInodeData.Type.OnDiskFile);
        }
        fida.add((Object)fid);
        FSNamesystem.LOG.debug((Object)"Stuffed Inode:  the file has been stored in the database ");
    }

    public byte[] getFileDataInDB() throws StorageException {
        HdfsStorageFactory.getConnector().readCommitted();
        FileInodeData fid = null;
        Object fida = null;
        fida = this.getSize() <= (long)FSNamesystem.getDBInMemBucketSize() ? (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class) : (this.getSize() <= (long)FSNamesystem.getDBOnDiskSmallBucketSize() ? (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class) : (this.getSize() <= (long)FSNamesystem.getDBOnDiskMediumBucketSize() ? (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class) : (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class)));
        fid = fida instanceof LargeOnDiskInodeDataAccess ? (FileInodeData)((LargeOnDiskInodeDataAccess)fida).get(this.getId(), (int)this.getSize()) : (FileInodeData)fida.get(this.getId());
        if (FSNamesystem.LOG.isDebugEnabled()) {
            long dataLength = 0L;
            if (fid != null && fid.getInodeData() != null) {
                dataLength = fid.getInodeData().length;
            }
            FSNamesystem.LOG.debug((Object)("Stuffed Inode:  Read file data from the database. Data length is :" + dataLength));
        }
        return fid == null ? null : fid.getInodeData();
    }

    public void deleteFileDataStoredInDB() throws StorageException {
        Object fid = null;
        InMemoryInodeDataAccess fida = null;
        FileInodeData.Type fileType2 = null;
        if (this.getSize() <= (long)FSNamesystem.getDBInMemBucketSize()) {
            fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
            fileType2 = FileInodeData.Type.InmemoryFile;
        } else if (this.getSize() <= (long)FSNamesystem.getDBOnDiskSmallBucketSize()) {
            fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
            fileType2 = FileInodeData.Type.OnDiskFile;
        } else if (this.getSize() <= (long)FSNamesystem.getDBOnDiskMediumBucketSize()) {
            fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
            fileType2 = FileInodeData.Type.OnDiskFile;
        } else {
            fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
            fileType2 = FileInodeData.Type.OnDiskFile;
        }
        fida.delete((Object)new FileInodeData(this.getId(), null, (int)this.getSize(), fileType2));
        FSNamesystem.LOG.debug((Object)("Stuffed Inode:  File data for Inode Id: " + this.getId() + " is deleted"));
    }

    List<BlockInfoContiguous> concatBlocks(INodeFile[] inodes) throws StorageException, TransactionContextException {
        ArrayList<BlockInfoContiguous> oldBlks = new ArrayList<BlockInfoContiguous>();
        for (INodeFile srcInode : inodes) {
            for (BlockInfoContiguous block : srcInode.getBlocks()) {
                BlockInfoContiguous copy = BlockInfoContiguous.cloneBlock(block);
                oldBlks.add(copy);
                this.addBlock(block);
                block.setBlockCollection(this);
            }
        }
        this.recomputeFileSize();
        return oldBlks;
    }

    void addBlock(BlockInfoContiguous newblock) throws StorageException, TransactionContextException {
        BlockInfoContiguous maxBlk = this.findMaxBlk();
        int index = 0;
        if (maxBlk != null) {
            index = maxBlk.getBlockIndex() + 1;
        }
        newblock.setBlockIndex(index);
    }

    @Override
    public void setBlock(int idx, BlockInfoContiguous blk) throws StorageException, TransactionContextException {
        blk.setBlockIndex(idx);
    }

    @Override
    public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws StorageException, TransactionContextException {
        this.parent = null;
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks != null && collectedBlocks != null) {
            for (BlockInfoContiguous blk : blocks) {
                blk.setBlockCollection(null);
                collectedBlocks.addDeleteBlock(blk);
            }
        }
        if (this.isFileStoredInDB()) {
            this.deleteFileDataStoredInDB();
        }
        removedINodes.add(this);
    }

    @Override
    public String getName() throws StorageException, TransactionContextException {
        return this.getFullPathName();
    }

    @Override
    public final ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) throws TransactionContextException, StorageException {
        ContentCounts counts = summary.getCounts();
        long fileLen = 0L;
        fileLen = this.computeFileSize();
        counts.addContent(Content.FILE, 1L);
        counts.addContent(Content.LENGTH, fileLen);
        counts.addContent(Content.DISKSPACE, this.storagespaceConsumed());
        if (this.getStoragePolicyID() != 0) {
            BlockStoragePolicy bsp = summary.getBlockStoragePolicySuite().getPolicy(this.getStoragePolicyID());
            List storageTypes = bsp.chooseStorageTypes(INode.HeaderFormat.getReplication(this.header));
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, fileLen);
            }
        }
        return summary;
    }

    public final long computeFileSizeNotIncludingLastUcBlock() throws StorageException, TransactionContextException {
        return this.computeFileSize(false, false);
    }

    public long computeFileSize() throws StorageException, TransactionContextException {
        if (this.isFileStoredInDB) {
            return this.getSize();
        }
        return this.computeFileSize(true, false);
    }

    public final long computeFileSize(boolean includesLastUcBlock, boolean usePreferredBlockSize4LastUcBlock) throws StorageException, TransactionContextException {
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return 0L;
        }
        int last = blocks.length - 1;
        long size = blocks[last].getNumBytes();
        if (blocks[last] instanceof BlockInfoContiguousUnderConstruction) {
            if (!includesLastUcBlock) {
                size = 0L;
            } else if (usePreferredBlockSize4LastUcBlock) {
                size = this.getPreferredBlockSize();
            }
        }
        for (int i = 0; i < last; ++i) {
            size += blocks[i].getNumBytes();
        }
        return size;
    }

    @Override
    QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts) throws StorageException, TransactionContextException {
        long nsDelta = 1L;
        long ssDeltaNoReplication = this.storagespaceConsumedNoReplication();
        short replication = this.getBlockReplication();
        counts.addNameSpace(nsDelta);
        counts.addStorageSpace(ssDeltaNoReplication * (long)replication);
        if (blockStoragePolicyId != 0) {
            BlockStoragePolicy bsp = bsps.getPolicy(blockStoragePolicyId);
            List storageTypes = bsp.chooseStorageTypes(replication);
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, ssDeltaNoReplication);
            }
        }
        return counts;
    }

    public final long storagespaceConsumed() throws StorageException, TransactionContextException {
        return this.storagespaceConsumedNoReplication() * (long)this.getBlockReplication();
    }

    public final long storagespaceConsumedNoReplication() throws StorageException, TransactionContextException {
        if (this.isFileStoredInDB()) {
            return this.getSize();
        }
        return this.computeFileSize(true, true);
    }

    BlockInfoContiguous getPenultimateBlock() throws StorageException, TransactionContextException {
        FileUnderConstructionFeature uc;
        if (this.isUnderConstruction() && (uc = this.getFileUnderConstructionFeature()) != null && uc.getPenultimateBlockId() > -1L) {
            return (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{uc.getPenultimateBlockId(), this.getId()}));
        }
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks == null || blocks.length <= 1) {
            return null;
        }
        return blocks[blocks.length - 2];
    }

    @Override
    public BlockInfoContiguous getLastBlock() throws IOException, StorageException {
        FileUnderConstructionFeature uc;
        if (this.isUnderConstruction() && (uc = this.getFileUnderConstructionFeature()) != null && uc.getLastBlockId() > -1L) {
            return (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{uc.getLastBlockId(), this.getId()}));
        }
        BlockInfoContiguous[] blocks = this.getBlocks();
        return blocks == null || blocks.length == 0 ? null : blocks[blocks.length - 1];
    }

    @Override
    public int numBlocks() throws StorageException, TransactionContextException {
        BlockInfoContiguous[] blocks = this.getBlocks();
        return blocks == null ? 0 : blocks.length;
    }

    final long getPreferredBlockStoragespace() {
        return this.getPreferredBlockSize() * (long)this.getBlockReplication();
    }

    void setFileReplication(short replication) throws StorageException, TransactionContextException {
        this.header = INode.HeaderFormat.REPLICATION.BITS.combine(replication, this.header);
        this.save();
    }

    public INodeFile toUnderConstruction(String clientName, String clientMachine) throws IOException {
        FileUnderConstructionFeature uc = new FileUnderConstructionFeature(clientName, clientMachine, this);
        this.addFeature(uc);
        this.save();
        return this;
    }

    public INodeFile toCompleteFile(long mtime) throws IOException, StorageException {
        FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
        if (uc != null) {
            if (!this.isFileStoredInDB()) assert (this.assertAllBlocksComplete()) : "Can't finalize inode " + this + " since it contains non-complete blocks! Blocks are " + this.getBlocks();
            this.removeFeature(uc);
            this.setModificationTime(mtime);
        }
        return this;
    }

    private boolean assertAllBlocksComplete() throws StorageException, TransactionContextException {
        for (BlockInfoContiguous b : this.getBlocks()) {
            if (b.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockInfoContiguousUnderConstruction setLastBlock(BlockInfoContiguous lastBlock, DatanodeStorageInfo[] locations) throws IOException {
        Preconditions.checkState((boolean)this.isUnderConstruction());
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoContiguousUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, locations);
        ucBlock.setBlockCollection(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    boolean removeLastBlock(Block oldBlock) throws IOException, StorageException {
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return false;
        }
        int size_1 = blocks.length - 1;
        if (!blocks[size_1].equals(oldBlock)) {
            return false;
        }
        this.removeBlock(blocks[blocks.length - 1]);
        return true;
    }

    public void removeBlock(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        BlockInfoContiguous[] blks = this.getBlocks();
        int index = block.getBlockIndex();
        block.setBlockCollection(null);
        if (index != blks.length) {
            for (int i = index + 1; i < blks.length; ++i) {
                blks[i].setBlockIndex(i - 1);
            }
        }
    }

    public BlockInfoContiguous findMaxBlk() throws StorageException, TransactionContextException {
        BlockInfoContiguous maxBlk = (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByMaxBlockIndexForINode, (Object[])new Object[]{this.getId()}));
        return maxBlk;
    }

    public int getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStampNoPersistence(int generationStamp) {
        this.generationStamp = generationStamp;
    }

    public int nextGenerationStamp() throws StorageException, TransactionContextException {
        ++this.generationStamp;
        this.save();
        return this.generationStamp;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFileStoredInDB() {
        return this.isFileStoredInDB;
    }

    public void setFileStoredInDB(boolean isFileStoredInDB) throws StorageException, TransactionContextException {
        this.setFileStoredInDBNoPersistence(isFileStoredInDB);
        this.save();
    }

    public void setFileStoredInDBNoPersistence(boolean isFileStoredInDB) {
        this.isFileStoredInDB = isFileStoredInDB;
    }

    public void setSizeNoPersistence(long size) {
        this.size = size;
    }

    public void setSize(long size) throws TransactionContextException, StorageException {
        this.setSizeNoPersistence(size);
        this.save();
    }

    public void recomputeFileSize() throws StorageException, TransactionContextException {
        this.setSizeNoPersistence(this.computeFileSize(true, false));
        this.save();
    }

    protected List<BlockInfoContiguous> getBlocksOrderedByIndex() throws TransactionContextException, StorageException {
        if (!this.isInTree()) {
            return null;
        }
        List blocksInDB = (List)EntityManager.findList((FinderType)BlockInfoContiguous.Finder.ByINodeId, (Object[])new Object[]{this.id});
        ArrayList<BlockInfoContiguous> blocks = null;
        if (blocksInDB != null) {
            for (BlockInfoContiguous block : blocksInDB) {
                if (this.removedBlocks.contains((Object)block)) continue;
                if (blocks == null) {
                    blocks = new ArrayList<BlockInfoContiguous>();
                }
                blocks.add(block);
            }
        }
        if (blocks != null) {
            Collections.sort(blocks, BlockInfoContiguous.Order.ByBlockIndex);
            return blocks;
        }
        return null;
    }

    @Override
    public INode cloneInode() throws IOException {
        return new INodeFile(this);
    }

    public long collectBlocksBeyondMax(long max, INode.BlocksMapUpdateInfo collectedBlocks) throws StorageException, TransactionContextException {
        long size;
        BlockInfoContiguous[] oldBlocks = this.getBlocks();
        if (oldBlocks == null) {
            return 0L;
        }
        int n = 0;
        for (size = 0L; n < oldBlocks.length && max > size; size += oldBlocks[n].getNumBytes(), ++n) {
        }
        if (n >= oldBlocks.length) {
            return size;
        }
        if (collectedBlocks != null) {
            while (n < oldBlocks.length) {
                BlockInfoContiguous block = oldBlocks[n];
                this.removedBlocks.add(block);
                collectedBlocks.addDeleteBlock(block);
                ++n;
            }
        }
        return size;
    }

    long computeQuotaDeltaForTruncate(long newLength) throws StorageException, TransactionContextException {
        int i;
        long size;
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return 0L;
        }
        int n = 0;
        for (size = 0L; n < blocks.length && newLength > size; size += blocks[n].getNumBytes(), ++n) {
        }
        boolean onBoundary = size == newLength;
        long truncateSize = 0L;
        int n2 = i = onBoundary ? n : n - 1;
        while (i < blocks.length) {
            truncateSize += blocks[i].getNumBytes();
            ++i;
        }
        return onBoundary ? -truncateSize : this.getPreferredBlockSize() - truncateSize;
    }
}

