/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.codehaus.jettison.mapped;

import io.hops.hadoop.shaded.org.codehaus.jettison.Convention;
import io.hops.hadoop.shaded.org.codehaus.jettison.Node;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONArray;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import io.hops.hadoop.shaded.org.codehaus.jettison.mapped.Configuration;
import io.hops.hadoop.shaded.org.codehaus.jettison.mapped.DefaultConverter;
import io.hops.hadoop.shaded.org.codehaus.jettison.mapped.TypeConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class MappedNamespaceConvention
implements Convention {
    private Map xnsToJns = new HashMap();
    private Map jnsToXns = new HashMap();
    private List attributesAsElements;
    private List jsonAttributesAsElements;
    private boolean supressAtAttributes;
    private String attributeKey = "@";
    private TypeConverter typeConverter;

    public MappedNamespaceConvention() {
        this.typeConverter = new DefaultConverter();
    }

    public MappedNamespaceConvention(Configuration config) {
        this.xnsToJns = config.getXmlToJsonNamespaces();
        this.attributesAsElements = config.getAttributesAsElements();
        this.supressAtAttributes = config.isSupressAtAttributes();
        this.attributeKey = config.getAttributeKey();
        Iterator itr = this.xnsToJns.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            this.jnsToXns.put(entry.getValue(), entry.getKey());
        }
        this.jsonAttributesAsElements = new ArrayList();
        if (this.attributesAsElements != null) {
            itr = this.attributesAsElements.iterator();
            while (itr.hasNext()) {
                QName q = (QName)((Object)itr.next());
                this.jsonAttributesAsElements.add(this.createAttributeKey(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart()));
            }
        }
        this.typeConverter = config.getTypeConverter();
    }

    public void processAttributesAndNamespaces(Node n, JSONObject object) throws JSONException {
        Iterator itr = object.keys();
        while (itr.hasNext()) {
            JSONArray array;
            String k = (String)itr.next();
            if (this.supressAtAttributes) {
                if (k.startsWith(this.attributeKey)) {
                    k = k.substring(1);
                }
                if (null == this.jsonAttributesAsElements) {
                    this.jsonAttributesAsElements = new ArrayList();
                }
                if (!this.jsonAttributesAsElements.contains(k)) {
                    this.jsonAttributesAsElements.add(k);
                }
            }
            if (k.startsWith(this.attributeKey)) {
                String value = object.optString(k);
                k = k.substring(1);
                if (value != null) {
                    this.readAttribute(n, k, value);
                } else {
                    array = object.optJSONArray(k);
                    if (array != null) {
                        this.readAttribute(n, k, array);
                    }
                }
                itr.remove();
                continue;
            }
            if (this.jsonAttributesAsElements != null && this.jsonAttributesAsElements.contains(k)) {
                String value = object.optString(k);
                if (value != null) {
                    this.readAttribute(n, k, value);
                } else {
                    array = object.optJSONArray(k);
                    if (array != null) {
                        this.readAttribute(n, k, array);
                    }
                }
                itr.remove();
                continue;
            }
            int dot = k.lastIndexOf(46);
            if (dot == -1) continue;
            String jns = k.substring(0, dot);
            n.setNamespace("", (String)this.jnsToXns.get(jns));
        }
    }

    public QName createQName(String rootName, Node node) {
        return this.createQName(rootName);
    }

    private void readAttribute(Node n, String k, JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            this.readAttribute(n, k, array.getString(i));
        }
    }

    private void readAttribute(Node n, String name, String value) throws JSONException {
        QName qname = this.createQName(name);
        n.getAttributes().put(qname, value);
    }

    private QName createQName(String name) {
        int dot = name.lastIndexOf(46);
        QName qname = null;
        String local = name;
        if (dot == -1) {
            dot = 0;
        } else {
            local = local.substring(dot + 1);
        }
        String jns = name.substring(0, dot);
        String xns = (String)this.jnsToXns.get(jns);
        qname = xns == null ? new QName(name) : new QName(xns, local);
        return qname;
    }

    public String createAttributeKey(String p, String ns, String local) {
        String jns;
        StringBuffer builder = new StringBuffer();
        if (!this.supressAtAttributes) {
            builder.append(this.attributeKey);
        }
        if ((jns = this.getJSONNamespace(ns)) != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    private String getJSONNamespace(String ns) {
        if (ns == null || ns.length() == 0) {
            return "";
        }
        String jns = (String)this.xnsToJns.get(ns);
        if (jns == null) {
            throw new IllegalStateException("Invalid JSON namespace: " + ns);
        }
        return jns;
    }

    public String createKey(String p, String ns, String local) {
        StringBuffer builder = new StringBuffer();
        String jns = this.getJSONNamespace(ns);
        if (jns != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    public boolean isElement(String p, String ns, String local) {
        if (this.attributesAsElements == null) {
            return false;
        }
        Iterator itr = this.attributesAsElements.iterator();
        while (itr.hasNext()) {
            QName q = (QName)itr.next();
            if (!q.getNamespaceURI().equals(ns) || !q.getLocalPart().equals(local)) continue;
            return true;
        }
        return false;
    }

    public Object convertToJSONPrimitive(String text) {
        return this.typeConverter.convertToJSONPrimitive(text);
    }
}

