/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.AsyncOps;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOpsTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncOpsTest.class);
    private ZooKeeper zk;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        LOG.info("Creating client " + this.getTestName());
        this.zk = this.createClient();
        this.zk.addAuthInfo("digest", "ben:passwd".getBytes());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.zk.close();
        super.tearDown();
        LOG.info("Test clients shutting down");
    }

    @Test
    public void testAsyncCreate() {
        new AsyncOps.StringCB(this.zk).verifyCreate();
    }

    @Test
    public void testAsyncCreateThree() {
        CountDownLatch latch = new CountDownLatch(3);
        AsyncOps.StringCB op1 = new AsyncOps.StringCB(this.zk, latch);
        op1.setPath("/op1");
        AsyncOps.StringCB op2 = new AsyncOps.StringCB(this.zk, latch);
        op2.setPath("/op2");
        AsyncOps.StringCB op3 = new AsyncOps.StringCB(this.zk, latch);
        op3.setPath("/op3");
        op1.create();
        op2.create();
        op3.create();
        op1.verify();
        op2.verify();
        op3.verify();
    }

    @Test
    public void testAsyncCreateFailure_NodeExists() {
        new AsyncOps.StringCB(this.zk).verifyCreateFailure_NodeExists();
    }

    @Test
    public void testAsyncCreateFailure_NoNode() {
        new AsyncOps.StringCB(this.zk).verifyCreateFailure_NoNode();
    }

    @Test
    public void testAsyncCreateFailure_NoChildForEphemeral() {
        new AsyncOps.StringCB(this.zk).verifyCreateFailure_NoChildForEphemeral();
    }

    @Test
    public void testAsyncDelete() {
        new AsyncOps.VoidCB(this.zk).verifyDelete();
    }

    @Test
    public void testAsyncDeleteFailure_NoNode() {
        new AsyncOps.VoidCB(this.zk).verifyDeleteFailure_NoNode();
    }

    @Test
    public void testAsyncDeleteFailure_BadVersion() {
        new AsyncOps.VoidCB(this.zk).verifyDeleteFailure_BadVersion();
    }

    @Test
    public void testAsyncDeleteFailure_NotEmpty() {
        new AsyncOps.VoidCB(this.zk).verifyDeleteFailure_NotEmpty();
    }

    @Test
    public void testAsyncSync() {
        new AsyncOps.VoidCB(this.zk).verifySync();
    }

    @Test
    public void testAsyncSetACL() {
        new AsyncOps.StatCB(this.zk).verifySetACL();
    }

    @Test
    public void testAsyncSetACLFailure_NoNode() {
        new AsyncOps.StatCB(this.zk).verifySetACLFailure_NoNode();
    }

    @Test
    public void testAsyncSetACLFailure_BadVersion() {
        new AsyncOps.StatCB(this.zk).verifySetACLFailure_BadVersion();
    }

    @Test
    public void testAsyncSetData() {
        new AsyncOps.StatCB(this.zk).verifySetData();
    }

    @Test
    public void testAsyncSetDataFailure_NoNode() {
        new AsyncOps.StatCB(this.zk).verifySetDataFailure_NoNode();
    }

    @Test
    public void testAsyncSetDataFailure_BadVersion() {
        new AsyncOps.StatCB(this.zk).verifySetDataFailure_BadVersion();
    }

    @Test
    public void testAsyncExists() {
        new AsyncOps.StatCB(this.zk).verifyExists();
    }

    @Test
    public void testAsyncExistsFailure_NoNode() {
        new AsyncOps.StatCB(this.zk).verifyExistsFailure_NoNode();
    }

    @Test
    public void testAsyncGetACL() {
        new AsyncOps.ACLCB(this.zk).verifyGetACL();
    }

    @Test
    public void testAsyncGetACLFailure_NoNode() {
        new AsyncOps.ACLCB(this.zk).verifyGetACLFailure_NoNode();
    }

    @Test
    public void testAsyncGetChildrenEmpty() {
        new AsyncOps.ChildrenCB(this.zk).verifyGetChildrenEmpty();
    }

    @Test
    public void testAsyncGetChildrenSingle() {
        new AsyncOps.ChildrenCB(this.zk).verifyGetChildrenSingle();
    }

    @Test
    public void testAsyncGetChildrenTwo() {
        new AsyncOps.ChildrenCB(this.zk).verifyGetChildrenTwo();
    }

    @Test
    public void testAsyncGetChildrenFailure_NoNode() {
        new AsyncOps.ChildrenCB(this.zk).verifyGetChildrenFailure_NoNode();
    }

    @Test
    public void testAsyncGetChildren2Empty() {
        new AsyncOps.Children2CB(this.zk).verifyGetChildrenEmpty();
    }

    @Test
    public void testAsyncGetChildren2Single() {
        new AsyncOps.Children2CB(this.zk).verifyGetChildrenSingle();
    }

    @Test
    public void testAsyncGetChildren2Two() {
        new AsyncOps.Children2CB(this.zk).verifyGetChildrenTwo();
    }

    @Test
    public void testAsyncGetChildren2Failure_NoNode() {
        new AsyncOps.Children2CB(this.zk).verifyGetChildrenFailure_NoNode();
    }

    @Test
    public void testAsyncGetData() {
        new AsyncOps.DataCB(this.zk).verifyGetData();
    }

    @Test
    public void testAsyncGetDataFailure_NoNode() {
        new AsyncOps.DataCB(this.zk).verifyGetDataFailure_NoNode();
    }
}

