/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http.server;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.utils.JdkVersion;

public class ServerFilterConfiguration {
    public static final int MAX_REQUEST_PARAMETERS = 10000;
    public static final String USE_SEND_FILE = "io.hops.hadoop.shaded.org.glassfish.grizzly.http.USE_SEND_FILE";
    private String httpServerName;
    private String httpServerVersion;
    private boolean sendFileEnabled;
    private boolean traceEnabled;
    private boolean passTraceRequest;
    private int maxRequestParameters = 10000;
    private boolean isReuseSessionID;
    private String scheme;

    public ServerFilterConfiguration() {
        this("Grizzly", Grizzly.getDotedVersion());
    }

    public ServerFilterConfiguration(String serverName, String serverVersion) {
        this.httpServerName = serverName;
        this.httpServerVersion = serverVersion;
        this.configureSendFileSupport();
    }

    public ServerFilterConfiguration(ServerFilterConfiguration configuration) {
        this.httpServerName = configuration.httpServerName;
        this.httpServerVersion = configuration.httpServerVersion;
        this.sendFileEnabled = configuration.sendFileEnabled;
        this.scheme = configuration.scheme;
        this.traceEnabled = configuration.traceEnabled;
        this.passTraceRequest = configuration.passTraceRequest;
        this.maxRequestParameters = configuration.maxRequestParameters;
        this.isReuseSessionID = configuration.isReuseSessionID;
    }

    public String getHttpServerName() {
        return this.httpServerName;
    }

    public void setHttpServerName(String httpServerName) {
        this.httpServerName = httpServerName;
    }

    public String getHttpServerVersion() {
        return this.httpServerVersion;
    }

    public void setHttpServerVersion(String httpServerVersion) {
        this.httpServerVersion = httpServerVersion;
    }

    public boolean isSendFileEnabled() {
        return this.sendFileEnabled;
    }

    public void setSendFileEnabled(boolean sendFileEnabled) {
        this.sendFileEnabled = sendFileEnabled;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isPassTraceRequest() {
        return this.passTraceRequest;
    }

    public void setPassTraceRequest(boolean passTraceRequest) {
        this.passTraceRequest = passTraceRequest;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    public int getMaxRequestParameters() {
        return this.maxRequestParameters;
    }

    public void setMaxRequestParameters(int maxRequestParameters) {
        this.maxRequestParameters = maxRequestParameters < 0 ? -1 : maxRequestParameters;
    }

    public boolean isReuseSessionID() {
        return this.isReuseSessionID;
    }

    public void setReuseSessionID(boolean isReuseSessionID) {
        this.isReuseSessionID = isReuseSessionID;
    }

    private void configureSendFileSupport() {
        if (System.getProperty("os.name").equalsIgnoreCase("linux") && !ServerFilterConfiguration.linuxSendFileSupported() || System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            this.sendFileEnabled = false;
        }
        if (System.getProperty(USE_SEND_FILE) != null) {
            this.sendFileEnabled = Boolean.valueOf(System.getProperty(USE_SEND_FILE));
        }
    }

    private static boolean linuxSendFileSupported() {
        JdkVersion jdkVersion = JdkVersion.getJdkVersion();
        JdkVersion minimumVersion = JdkVersion.parseVersion("1.6.0_18");
        return minimumVersion.compareTo(jdkVersion) <= 0;
    }
}

