/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.jmx;

import io.hops.hadoop.shaded.org.glassfish.gmbal.Description;
import io.hops.hadoop.shaded.org.glassfish.gmbal.GmbalMBean;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedAttribute;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedObject;
import io.hops.hadoop.shaded.org.glassfish.gmbal.NameValue;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Transport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransportProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import io.hops.hadoop.shaded.org.glassfish.grizzly.utils.DataStructures;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ManagedObject
@Description(value="Grizzly NIO Transport")
public class NIOTransport
extends JmxObject {
    protected final io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport transport;
    private final JmxTransportProbe probe;
    private final JmxConnectionProbe connectionProbe;
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicLong bytesWritten = new AtomicLong();
    private volatile EventDate stateEvent;
    private volatile EventDate lastErrorEvent;
    private final ConcurrentHashMap<Connection, String> boundConnections = new ConcurrentHashMap();
    private final Queue<String> boundAddresses = DataStructures.getLTQInstance(String.class);
    private final AtomicInteger openConnectionsNum = new AtomicInteger();
    private final AtomicLong totalConnectionsNum = new AtomicLong();
    private GrizzlyJmxManager mom;
    private MemoryManager currentMemoryManager;
    private JmxObject memoryManagerJmx;
    private ExecutorService currentThreadPool;
    private JmxObject threadPoolJmx;
    private final Object subtreeLock = new Object();

    public NIOTransport(io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport transport) {
        this.transport = transport;
        this.probe = new JmxTransportProbe();
        this.connectionProbe = new JmxConnectionProbe();
    }

    @NameValue
    public String getName() {
        return this.transport.getName();
    }

    @Override
    public String getJmxName() {
        return "Transport";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        Object object = this.subtreeLock;
        synchronized (object) {
            this.mom = mom;
            this.transport.getMonitoringConfig().addProbes(this.probe);
            this.transport.getConnectionMonitoringConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{this.connectionProbe});
            this.rebuildSubTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        Object object = this.subtreeLock;
        synchronized (object) {
            this.transport.getMonitoringConfig().removeProbes(this.probe);
            this.transport.getConnectionMonitoringConfig().removeProbes((ConnectionProbe[])new ConnectionProbe[]{this.connectionProbe});
            this.mom = null;
        }
    }

    @ManagedAttribute(id="state")
    public String getState() {
        EventDate stateEventDate = this.stateEvent;
        if (stateEventDate == null) {
            return NIOTransport.toString((Object)this.transport.getState().getState());
        }
        return NIOTransport.toString(stateEventDate);
    }

    @ManagedAttribute(id="read-buffer-size")
    public int getReadBufferSize() {
        return this.transport.getReadBufferSize();
    }

    @ManagedAttribute(id="write-buffer-size")
    public int getWriteBufferSize() {
        return this.transport.getWriteBufferSize();
    }

    @ManagedAttribute(id="processor")
    public String getProcessor() {
        return NIOTransport.getType(this.transport.getProcessor());
    }

    @ManagedAttribute(id="processor-selector")
    public String getProcessorSelector() {
        return NIOTransport.getType(this.transport.getProcessorSelector());
    }

    @ManagedAttribute(id="io-strategy")
    public String getIOStrategy() {
        return NIOTransport.getType(this.transport.getIOStrategy());
    }

    @ManagedAttribute(id="channel-distributor")
    public String getChannelDistributor() {
        return NIOTransport.getType(this.transport.getNIOChannelDistributor());
    }

    @ManagedAttribute(id="selector-handler")
    public String getSelectorHandler() {
        return NIOTransport.getType(this.transport.getSelectorHandler());
    }

    @ManagedAttribute(id="selection-key-handler")
    public String getSelectionKeyHandler() {
        return NIOTransport.getType(this.transport.getSelectionKeyHandler());
    }

    @ManagedAttribute(id="selector-threads-count")
    public int getSelectorHandlerRunners() {
        return this.transport.getSelectorRunnersCount();
    }

    @ManagedAttribute(id="thread-pool-type")
    public String getThreadPoolType() {
        return NIOTransport.getType(this.transport.getWorkerThreadPool());
    }

    @ManagedAttribute(id="last-error")
    public String getLastError() {
        return NIOTransport.toString(this.lastErrorEvent);
    }

    @ManagedAttribute(id="bytes-read")
    public long getBytesRead() {
        return this.bytesRead.get();
    }

    @ManagedAttribute(id="bytes-written")
    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    @ManagedAttribute(id="bound-addresses")
    public String getBoundAddresses() {
        return this.boundAddresses.toString();
    }

    @ManagedAttribute(id="open-connections-count")
    public int getOpenConnectionsCount() {
        return this.openConnectionsNum.get();
    }

    @ManagedAttribute(id="total-connections-count")
    public long getTotalConnectionsCount() {
        return this.totalConnectionsNum.get();
    }

    private static String getType(Object o) {
        return o != null ? o.getClass().getName() : "N/A";
    }

    private static String toString(Object o) {
        return o != null ? o.toString() : "N/A";
    }

    protected void rebuildSubTree() {
        ExecutorService executorService;
        GrizzlyExecutorService threadPool;
        MemoryManager memoryManager = this.transport.getMemoryManager();
        if (this.currentMemoryManager != memoryManager) {
            if (this.currentMemoryManager != null) {
                this.mom.deregister(this.memoryManagerJmx);
                this.currentMemoryManager = null;
                this.memoryManagerJmx = null;
            }
            if (memoryManager != null) {
                JmxObject mmJmx = memoryManager.getMonitoringConfig().createManagementObject();
                this.mom.register(this, mmJmx, mmJmx.getJmxName());
                this.currentMemoryManager = memoryManager;
                this.memoryManagerJmx = mmJmx;
            }
        }
        if (this.currentThreadPool != (threadPool = (executorService = this.transport.getWorkerThreadPool()) instanceof GrizzlyExecutorService ? (GrizzlyExecutorService)this.transport.getWorkerThreadPool() : null)) {
            if (this.currentThreadPool != null) {
                this.mom.deregister(this.threadPoolJmx);
                this.currentThreadPool = null;
                this.threadPoolJmx = null;
            }
            if (threadPool != null) {
                JmxObject jmx = threadPool.getMonitoringConfig().createManagementObject();
                this.mom.register(this, jmx, jmx.getJmxName());
                this.currentThreadPool = threadPool;
                this.threadPoolJmx = jmx;
            }
        }
    }

    private class JmxConnectionProbe
    implements ConnectionProbe {
        private JmxConnectionProbe() {
        }

        @Override
        public void onBindEvent(Connection connection) {
            String bindAddress = connection.getLocalAddress().toString();
            if (NIOTransport.this.boundConnections.putIfAbsent(connection, bindAddress) == null) {
                NIOTransport.this.boundAddresses.add(bindAddress);
            }
        }

        @Override
        public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
            NIOTransport.this.openConnectionsNum.incrementAndGet();
            NIOTransport.this.totalConnectionsNum.incrementAndGet();
        }

        @Override
        public void onConnectEvent(Connection connection) {
            NIOTransport.this.openConnectionsNum.incrementAndGet();
            NIOTransport.this.totalConnectionsNum.incrementAndGet();
        }

        @Override
        public void onReadEvent(Connection connection, Buffer data, int size) {
            NIOTransport.this.bytesRead.addAndGet(size);
        }

        @Override
        public void onWriteEvent(Connection connection, Buffer data, long size) {
            NIOTransport.this.bytesWritten.addAndGet(size);
        }

        @Override
        public void onErrorEvent(Connection connection, Throwable error) {
        }

        @Override
        public void onCloseEvent(Connection connection) {
            String bindAddress = (String)NIOTransport.this.boundConnections.remove(connection);
            if (bindAddress != null) {
                NIOTransport.this.boundAddresses.remove(bindAddress);
            }
            if (NIOTransport.this.openConnectionsNum.get() > 0) {
                NIOTransport.this.openConnectionsNum.decrementAndGet();
            }
        }

        @Override
        public void onIOEventReadyEvent(Connection connection, IOEvent ioEvent) {
        }

        @Override
        public void onIOEventEnableEvent(Connection connection, IOEvent ioEvent) {
        }

        @Override
        public void onIOEventDisableEvent(Connection connection, IOEvent ioEvent) {
        }
    }

    private class JmxTransportProbe
    implements TransportProbe {
        private JmxTransportProbe() {
        }

        @Override
        public void onStartEvent(Transport transport) {
            NIOTransport.this.stateEvent = new EventDate("START");
        }

        @Override
        public void onStopEvent(Transport transport) {
            NIOTransport.this.stateEvent = new EventDate("STOP");
        }

        @Override
        public void onPauseEvent(Transport transport) {
            NIOTransport.this.stateEvent = new EventDate("PAUSE");
        }

        @Override
        public void onResumeEvent(Transport transport) {
            NIOTransport.this.stateEvent = new EventDate("RESUME");
        }

        @Override
        public void onErrorEvent(Transport transport, Throwable error) {
            NIOTransport.this.lastErrorEvent = new EventDate(error.getClass() + ": " + error.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigChangeEvent(Transport transport) {
            Object object = NIOTransport.this.subtreeLock;
            synchronized (object) {
                NIOTransport.this.rebuildSubTree();
            }
        }
    }

    private static class EventDate {
        private final String event;
        private final Date date;

        public EventDate(String event) {
            this.event = event;
            this.date = new Date();
        }

        public String toString() {
            return this.event + " (" + this.date + ')';
        }
    }
}

