/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.EntityManager;
import java.util.Collection;
import org.apache.hadoop.hdfs.protocol.Block;

public class Lease
implements Comparable<Lease> {
    private final String holder;
    private long lastUpdate;
    private int holderID;
    private int count;

    public Lease(String holder, int holderID, long lastUpd, int count) {
        this.holder = holder;
        this.holderID = holderID;
        this.lastUpdate = lastUpd;
        this.count = count;
    }

    public void setLastUpdate(long lastUpd) {
        this.lastUpdate = lastUpd;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setHolderID(int holderID) {
        this.holderID = holderID;
    }

    public int getHolderID() {
        return this.holderID;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean removePath(LeasePath lPath) throws StorageException, TransactionContextException {
        if (this.getPaths().remove(lPath)) {
            assert (this.count > 0);
            --this.count;
            this.savePersistent();
            return true;
        }
        return false;
    }

    public void addPath(LeasePath lPath) throws StorageException, TransactionContextException {
        EntityManager.update((Object)lPath);
        lPath.savePersistent();
        ++this.count;
        this.savePersistent();
    }

    boolean hasPath() throws StorageException, TransactionContextException {
        return !this.getPaths().isEmpty() || this.count != 0;
    }

    public String toString() {
        return "[Lease.  Holder: " + this.holder + ", pendingcreates: " + this.count + "]";
    }

    @Override
    public int compareTo(Lease o) {
        Lease l1 = this;
        Lease l2 = o;
        long lu1 = l1.lastUpdate;
        long lu2 = l2.lastUpdate;
        if (lu1 < lu2) {
            return -1;
        }
        if (lu1 > lu2) {
            return 1;
        }
        return l1.holder.compareTo(l2.holder);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Lease)) {
            return false;
        }
        Lease obj = (Lease)o;
        return this.lastUpdate == obj.lastUpdate && this.holder.equals(obj.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public Collection<LeasePath> getPaths() throws StorageException, TransactionContextException {
        return EntityManager.findList((FinderType)LeasePath.Finder.ByHolderId, (Object[])new Object[]{this.holderID});
    }

    public String getHolder() {
        return this.holder;
    }

    public static int getHolderId(String holder) {
        return holder.hashCode();
    }

    public void updateLastTwoBlocksInLeasePath(String path, Block lastBlock, Block penultimateBlock) throws TransactionContextException, StorageException {
        this.updateLastTwoBlocksInLeasePath(path, lastBlock == null ? -1L : lastBlock.getBlockId(), penultimateBlock == null ? -1L : penultimateBlock.getBlockId());
    }

    private void updateLastTwoBlocksInLeasePath(String path, long lastBlockId, long penultimateBlockId) throws TransactionContextException, StorageException {
        Collection<LeasePath> lps = this.getPaths();
        for (LeasePath lp : lps) {
            if (!lp.getPath().equals(path)) continue;
            lp.setLastBlockId(lastBlockId);
            lp.setPenultimateBlockId(penultimateBlockId);
            lp.savePersistent();
            break;
        }
    }

    public LeasePath getLeasePath(String path) throws TransactionContextException, StorageException {
        Collection<LeasePath> lps = this.getPaths();
        for (LeasePath lp : lps) {
            if (!lp.getPath().equals(path)) continue;
            return lp;
        }
        return null;
    }

    public void deletePersistent() throws TransactionContextException, StorageException {
        EntityManager.remove((Object)this);
    }

    public void savePersistent() throws TransactionContextException, StorageException {
        EntityManager.update((Object)this);
    }

    public static enum Finder implements FinderType<Lease>
    {
        ByHolder,
        ByHolderId,
        All;


        public Class getType() {
            return Lease.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByHolder: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByHolderId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Counter implements CounterType<Lease>
    {
        All;


        public Class getType() {
            return Lease.class;
        }
    }
}

