/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.MultiTransactionRecord;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.junit.Test;

public class MultiTransactionRecordTest
extends TestCase {
    @Test
    public void testRoundTrip() throws IOException {
        MultiTransactionRecord request = new MultiTransactionRecord();
        request.add(Op.check("check", 1));
        request.add(Op.create("create", "create data".getBytes(), ZooDefs.Ids.CREATOR_ALL_ACL, 31));
        request.add(Op.delete("delete", 17));
        request.add(Op.setData("setData", "set data".getBytes(), 19));
        MultiTransactionRecord decodedRequest = this.codeDecode(request);
        MultiTransactionRecordTest.assertEquals((Object)request, (Object)decodedRequest);
        MultiTransactionRecordTest.assertEquals((int)request.hashCode(), (int)decodedRequest.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiTransactionRecord request = new MultiTransactionRecord();
        MultiTransactionRecord decodedRequest = this.codeDecode(request);
        MultiTransactionRecordTest.assertEquals((Object)request, (Object)decodedRequest);
        MultiTransactionRecordTest.assertEquals((int)request.hashCode(), (int)decodedRequest.hashCode());
    }

    private MultiTransactionRecord codeDecode(MultiTransactionRecord request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        request.serialize(boa, "request");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        MultiTransactionRecord decodedRequest = new MultiTransactionRecord();
        decodedRequest.deserialize(bia, "request");
        return decodedRequest;
    }
}

