/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.cglib.transform.impl;

import io.hops.hadoop.shaded.org.mockito.asm.Type;
import io.hops.hadoop.shaded.org.mockito.cglib.core.CodeEmitter;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Constants;
import io.hops.hadoop.shaded.org.mockito.cglib.core.MethodInfo;
import io.hops.hadoop.shaded.org.mockito.cglib.core.ReflectUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Signature;
import io.hops.hadoop.shaded.org.mockito.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;

public class AddInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_OBJECT) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        CodeEmitter emitter = super.begin_method(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(emitter){

                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        this.load_this();
                        this.invoke(AddInitTransformer.this.info);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        return emitter;
    }
}

