/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.verification;

import io.hops.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.VerificationData;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.VerificationDataInOrder;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.VerificationInOrderMode;
import io.hops.hadoop.shaded.org.mockito.internal.verification.checkers.MissingInvocationChecker;
import io.hops.hadoop.shaded.org.mockito.internal.verification.checkers.MissingInvocationInOrderChecker;
import io.hops.hadoop.shaded.org.mockito.internal.verification.checkers.NumberOfInvocationsChecker;
import io.hops.hadoop.shaded.org.mockito.internal.verification.checkers.NumberOfInvocationsInOrderChecker;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationMode;
import java.util.List;

public class Times
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public Times(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    public void verify(VerificationData data) {
        if (this.wantedCount > 0) {
            MissingInvocationChecker missingInvocation = new MissingInvocationChecker();
            missingInvocation.check(data.getAllInvocations(), data.getWanted());
        }
        NumberOfInvocationsChecker numberOfInvocations = new NumberOfInvocationsChecker();
        numberOfInvocations.check(data.getAllInvocations(), data.getWanted(), this.wantedCount);
    }

    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> allInvocations = data.getAllInvocations();
        InvocationMatcher wanted = data.getWanted();
        if (this.wantedCount > 0) {
            MissingInvocationInOrderChecker missingInvocation = new MissingInvocationInOrderChecker();
            missingInvocation.check(allInvocations, wanted, this, data.getOrderingContext());
        }
        NumberOfInvocationsInOrderChecker numberOfCalls = new NumberOfInvocationsInOrderChecker();
        numberOfCalls.check(allInvocations, wanted, this.wantedCount, data.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count: " + this.wantedCount;
    }
}

