/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.cedarsoftware.util;

import io.hops.hadoop.shaded.com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Traverser {
    private final Map<Object, Object> _objVisited = new IdentityHashMap<Object, Object>();
    private final Map<Class, ClassInfo> _classCache = new HashMap<Class, ClassInfo>();

    public static void traverse(Object o, Visitor visitor) {
        Traverser.traverse(o, null, visitor);
    }

    public static void traverse(Object o, Class[] skip, Visitor visitor) {
        Traverser traverse = new Traverser();
        traverse.walk(o, skip, visitor);
        traverse._objVisited.clear();
        traverse._classCache.clear();
    }

    public void walk(Object root, Class[] skip, Visitor visitor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Class<?> clazz;
            ClassInfo classInfo;
            Object current = stack.removeFirst();
            if (current == null || this._objVisited.containsKey(current) || (classInfo = this.getClassInfo(clazz = current.getClass(), skip))._skip) continue;
            this._objVisited.put(current, null);
            visitor.process(current);
            if (clazz.isArray()) {
                ClassInfo info;
                int len = Array.getLength(current);
                Class<?> compType = clazz.getComponentType();
                if (compType.isPrimitive() || (info = this.getClassInfo(compType, skip))._skip) continue;
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(current, i);
                    if (element == null) continue;
                    stack.add(Array.get(current, i));
                }
                continue;
            }
            if (current instanceof Collection) {
                this.walkCollection(stack, (Collection)current, skip);
                continue;
            }
            if (current instanceof Map) {
                this.walkMap(stack, (Map)current, skip);
                continue;
            }
            this.walkFields(stack, current, skip);
        }
    }

    private void walkFields(LinkedList stack, Object current, Class[] skip) {
        ClassInfo classInfo = this.getClassInfo(current.getClass(), skip);
        if (classInfo._skip) {
            return;
        }
        for (Field field : classInfo._refFields) {
            try {
                Object value = field.get(current);
                if (value == null || value.getClass().isPrimitive()) continue;
                stack.add(value);
            }
            catch (IllegalAccessException ignored) {}
        }
    }

    private void walkCollection(LinkedList stack, Collection col, Class[] skip) {
        for (Object o : col) {
            if (o == null || o.getClass().isPrimitive()) continue;
            stack.add(o);
        }
    }

    private void walkMap(LinkedList stack, Map map, Class[] skip) {
        for (Map.Entry entry : map.entrySet()) {
            Object o = entry.getKey();
            if (o == null || o.getClass().isPrimitive()) continue;
            stack.add(entry.getKey());
            stack.add(entry.getValue());
        }
    }

    private ClassInfo getClassInfo(Class current, Class[] skip) {
        ClassInfo classCache = this._classCache.get(current);
        if (classCache != null) {
            return classCache;
        }
        classCache = new ClassInfo(current, skip);
        this._classCache.put(current, classCache);
        return classCache;
    }

    public class ClassInfo {
        private boolean _skip = false;
        private final Collection<Field> _refFields = new ArrayList<Field>();

        public ClassInfo(Class c, Class[] skip) {
            if (skip != null) {
                for (Class klass : skip) {
                    if (!klass.isAssignableFrom(c)) continue;
                    this._skip = true;
                    return;
                }
            }
            Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(c);
            for (Field field : fields) {
                Class<?> fc = field.getType();
                if (fc.isPrimitive()) continue;
                this._refFields.add(field);
            }
        }
    }

    public static interface Visitor {
        public void process(Object var1);
    }
}

