/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import io.hops.leader_election.node.ActiveNode;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.MetaStatus;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.BlockStorageLocationUtil;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LeaseRenewer;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.UnknownCipherSuiteException;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveIterator;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.EncryptionZoneIterator;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class DFSClient
implements Closeable,
RemotePeerFactory,
DataEncryptionKeyFactory {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public static final long SERVER_DEFAULTS_VALIDITY_PERIOD = 3600000L;
    static final int TCP_WINDOW_SIZE = 131072;
    private final Configuration conf;
    private final Tracer tracer;
    private final DfsClientConf dfsClientConf;
    final ClientProtocol namenode;
    ClientProtocol leaderNN;
    final List<ClientProtocol> allNNs = new ArrayList<ClientProtocol>();
    private Text dtService;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    volatile long lastLeaseRenewal;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    final String clientName;
    private final SocketFactory socketFactory;
    final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    final FileSystem.Statistics stats;
    private final String authority;
    private Random r = new Random();
    private SocketAddress[] localInterfaceAddrs;
    private DataEncryptionKey encryptionKey;
    final SaslDataTransferClient saslClient;
    private final CachingStrategy defaultReadCachingStrategy;
    private final CachingStrategy defaultWriteCachingStrategy;
    private final ClientContext clientContext;
    private static final DFSHedgedReadMetrics HEDGED_READ_METRIC = new DFSHedgedReadMetrics();
    private static ThreadPoolExecutor HEDGED_READ_THREAD_POOL;
    private final Map<Long, DFSOutputStream> filesBeingWritten = new HashMap<Long, DFSOutputStream>();
    private static Map<String, Boolean> localAddrMap;

    public DfsClientConf getConf() {
        return this.dfsClientConf;
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    @Deprecated
    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress address, Configuration conf) throws IOException {
        this(NameNode.getUri(address), conf);
    }

    public DFSClient(URI nameNodeUri, Configuration conf) throws IOException {
        this(nameNodeUri, conf, null);
    }

    public DFSClient(URI nameNodeUri, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeUri, null, conf, stats);
    }

    @VisibleForTesting
    public DFSClient(URI nameNodeUri, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.tracer = FsTracer.get((Configuration)conf);
        this.dfsClientConf = new DfsClientConf(conf);
        this.conf = conf;
        this.stats = stats;
        this.socketFactory = NetUtils.getSocketFactoryFromProperty((Configuration)conf, (String)conf.get("dfs.client.xceiver.socket.factory.class", "org.apache.hadoop.net.StandardSocketFactory"));
        this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.authority = nameNodeUri == null ? "null" : nameNodeUri.getAuthority();
        String clientNamePrefix = "";
        clientNamePrefix = this.dfsClientConf.getForceClientToWriteSFToDisk() ? "DFSClient" : "HopsFS_DFSClient";
        this.clientName = clientNamePrefix + "_" + this.dfsClientConf.getTaskId() + "_" + DFSUtil.getRandom().nextInt() + "_" + Thread.currentThread().getId();
        int numResponseToDrop = conf.getInt("dfs.client.test.drop.namenode.response.number", 0);
        NameNodeProxies.ProxyAndInfo<ClientProtocol> proxyInfo = null;
        AtomicBoolean nnFallbackToSimpleAuth = new AtomicBoolean(false);
        if (numResponseToDrop > 0) {
            LOG.warn((Object)("dfs.client.test.drop.namenode.response.number is set to " + numResponseToDrop + ", this hacked client will proactively drop responses"));
            proxyInfo = NameNodeProxies.createProxyWithLossyRetryHandler(conf, nameNodeUri, ClientProtocol.class, numResponseToDrop, nnFallbackToSimpleAuth);
        }
        if (proxyInfo != null) {
            this.dtService = proxyInfo.getDelegationTokenService();
            this.leaderNN = this.namenode = (ClientProtocol)proxyInfo.getProxy();
        } else if (rpcNamenode != null) {
            Preconditions.checkArgument((nameNodeUri == null ? 1 : 0) != 0);
            this.namenode = rpcNamenode;
            this.leaderNN = rpcNamenode;
            this.dtService = null;
        } else {
            Preconditions.checkArgument((nameNodeUri != null ? 1 : 0) != 0, (Object)"null URI");
            proxyInfo = NameNodeProxies.createHopsRandomStickyProxy(conf, nameNodeUri, ClientProtocol.class, nnFallbackToSimpleAuth);
            this.dtService = proxyInfo.getDelegationTokenService();
            this.namenode = proxyInfo.getProxy();
            if (this.namenode != null) {
                try {
                    List anns = this.namenode.getActiveNamenodesForClient().getSortedActiveNodes();
                    this.leaderNN = NameNodeProxies.createHopsLeaderProxy(conf, nameNodeUri, ClientProtocol.class, nnFallbackToSimpleAuth).getProxy();
                    for (ActiveNode an : anns) {
                        this.allNNs.add(NameNodeProxies.createNonHAProxy(conf, an.getRpcServerAddressForClients(), ClientProtocol.class, this.ugi, false, nnFallbackToSimpleAuth).getProxy());
                    }
                }
                catch (ConnectException e) {
                    LOG.warn((Object)"Namenode proxy is null");
                    this.leaderNN = null;
                    this.allNNs.clear();
                }
            }
        }
        this.setClientEpoch();
        Object[] localInterfaces = conf.getTrimmedStrings("dfs.client.local.interfaces");
        this.localInterfaceAddrs = DFSClient.getLocalInterfaceAddrs((String[])localInterfaces);
        if (LOG.isDebugEnabled() && 0 != localInterfaces.length) {
            LOG.debug((Object)("Using local interfaces [" + Joiner.on((char)',').join(localInterfaces) + "] with addresses [" + Joiner.on((char)',').join((Object[])this.localInterfaceAddrs) + "]"));
        }
        Boolean readDropBehind = conf.get("dfs.client.cache.drop.behind.reads") == null ? null : Boolean.valueOf(conf.getBoolean("dfs.client.cache.drop.behind.reads", false));
        Long readahead = conf.get("dfs.client.cache.readahead") == null ? null : Long.valueOf(conf.getLong("dfs.client.cache.readahead", 0L));
        Boolean writeDropBehind = conf.get("dfs.client.cache.drop.behind.writes") == null ? null : Boolean.valueOf(conf.getBoolean("dfs.client.cache.drop.behind.writes", false));
        this.defaultReadCachingStrategy = new CachingStrategy(readDropBehind, readahead);
        this.defaultWriteCachingStrategy = new CachingStrategy(writeDropBehind, readahead);
        this.clientContext = ClientContext.get(conf.get("dfs.client.context", "default"), this.dfsClientConf);
        if (this.dfsClientConf.getHedgedReadThreadpoolSize() > 0) {
            this.initThreadsNumForHedgedReads(this.dfsClientConf.getHedgedReadThreadpoolSize());
        }
        this.saslClient = new SaslDataTransferClient(conf, DataTransferSaslUtil.getSaslPropertiesResolver(conf), TrustedChannelResolver.getInstance(conf), nnFallbackToSimpleAuth);
    }

    private static SocketAddress[] getLocalInterfaceAddrs(String[] interfaceNames) throws UnknownHostException {
        ArrayList<InetSocketAddress> localAddrs = new ArrayList<InetSocketAddress>();
        for (String interfaceName : interfaceNames) {
            if (InetAddresses.isInetAddress((String)interfaceName)) {
                localAddrs.add(new InetSocketAddress(interfaceName, 0));
                continue;
            }
            if (NetUtils.isValidSubnet((String)interfaceName)) {
                for (InetAddress addr : NetUtils.getIPs((String)interfaceName, (boolean)false)) {
                    localAddrs.add(new InetSocketAddress(addr, 0));
                }
                continue;
            }
            for (String ip : DNS.getIPs((String)interfaceName, (boolean)false)) {
                localAddrs.add(new InetSocketAddress(ip, 0));
            }
        }
        return localAddrs.toArray(new SocketAddress[localAddrs.size()]);
    }

    SocketAddress getRandomLocalInterfaceAddr() {
        if (this.localInterfaceAddrs.length == 0) {
            return null;
        }
        int idx = this.r.nextInt(this.localInterfaceAddrs.length);
        SocketAddress addr = this.localInterfaceAddrs[idx];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using local interface " + addr));
        }
        return addr;
    }

    int getDatanodeWriteTimeout(int numNodes) {
        int t = this.dfsClientConf.getDatanodeSocketWriteTimeout();
        return t > 0 ? t + HdfsServerConstants.WRITE_TIMEOUT_EXTENSION * numNodes : 0;
    }

    int getDatanodeReadTimeout(int numNodes) {
        int t = this.dfsClientConf.getSocketTimeout();
        return t > 0 ? HdfsServerConstants.READ_TIMEOUT_EXTENSION * numNodes + t : 0;
    }

    @VisibleForTesting
    public String getClientName() {
        return this.clientName;
    }

    void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    public LeaseRenewer getLeaseRenewer() throws IOException {
        return LeaseRenewer.getInstance(this.authority, this.ugi, this);
    }

    private void beginFileLease(long inodeId, DFSOutputStream out) throws IOException {
        this.getLeaseRenewer().put(inodeId, out, this);
    }

    void endFileLease(long inodeId) throws IOException {
        this.getLeaseRenewer().closeFile(inodeId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFileBeingWritten(long inodeId, DFSOutputStream out) {
        Map<Long, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(inodeId, out);
            if (this.lastLeaseRenewal == 0L) {
                this.updateLastLeaseRenewal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBeingWritten(long inodeId) {
        Map<Long, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(inodeId);
            if (this.filesBeingWritten.isEmpty()) {
                this.lastLeaseRenewal = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFilesBeingWrittenEmpty() {
        Map<Long, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.isEmpty();
        }
    }

    boolean isClientRunning() {
        return this.clientRunning;
    }

    long getLastLeaseRenewal() {
        return this.lastLeaseRenewal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastLeaseRenewal() {
        Map<Long, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            if (this.filesBeingWritten.isEmpty()) {
                return;
            }
            this.lastLeaseRenewal = Time.monotonicNow();
        }
    }

    boolean renewLease() throws IOException {
        if (this.clientRunning && !this.isFilesBeingWrittenEmpty()) {
            try {
                this.namenode.renewLease(this.clientName);
                this.updateLastLeaseRenewal();
                return true;
            }
            catch (IOException e) {
                long elapsed = Time.monotonicNow() - this.getLastLeaseRenewal();
                if (elapsed > 3600000L) {
                    LOG.warn((Object)("Failed to renew lease for " + this.clientName + " for " + elapsed / 1000L + " seconds (>= hard-limit =" + 3600L + " seconds.) Closing all files being written ..."), (Throwable)e);
                    this.closeAllFilesBeingWritten(true);
                }
                throw e;
            }
        }
        return false;
    }

    void closeConnectionsToNamenodes() {
        if (this.leaderNN == this.namenode) {
            this.stopProxy(this.namenode);
        } else {
            this.stopProxy(this.namenode);
            this.stopProxy(this.leaderNN);
        }
        for (ClientProtocol nn : this.allNNs) {
            this.stopProxy(nn);
        }
    }

    void stopProxy(ClientProtocol proxy) {
        if (proxy != null) {
            RPC.stopProxy((Object)proxy);
        }
    }

    void abort() {
        this.clientRunning = false;
        this.closeAllFilesBeingWritten(true);
        try {
            this.getLeaseRenewer().closeClient(this);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Exception occurred while aborting the client " + ioe));
        }
        this.closeConnectionsToNamenodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllFilesBeingWritten(boolean abort) {
        while (true) {
            DFSOutputStream out;
            long inodeId;
            Map<Long, DFSOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    return;
                }
                inodeId = this.filesBeingWritten.keySet().iterator().next();
                out = this.filesBeingWritten.remove(inodeId);
            }
            if (out == null) continue;
            try {
                if (abort) {
                    out.abort();
                    continue;
                }
                out.close();
                continue;
            }
            catch (IOException ie) {
                LOG.error((Object)("Failed to " + (abort ? "abort" : "close") + " inode " + inodeId), (Throwable)ie);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(false);
            this.clientRunning = false;
            this.getLeaseRenewer().closeClient(this);
            this.closeConnectionsToNamenodes();
        }
    }

    public void closeOutputStreams(boolean abort) {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(abort);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getBlockSize(String f) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("getBlockSize", f);){
            long l = this.namenode.getPreferredBlockSize(f);
            return l;
        }
        catch (IOException ie) {
            LOG.warn((Object)"Problem getting block size", (Throwable)ie);
            throw ie;
        }
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        long now = Time.monotonicNow();
        if (this.serverDefaults == null || now - this.serverDefaultsLastUpdate > 3600000L) {
            this.serverDefaults = this.namenode.getServerDefaults();
            this.serverDefaultsLastUpdate = now;
        }
        assert (this.serverDefaults != null);
        return this.serverDefaults;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public String getCanonicalServiceName() {
        return this.dtService != null ? this.dtService.toString() : null;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        assert (this.dtService != null);
        try (TraceScope ignored = this.tracer.newScope("getDelegationToken");){
            Token<DelegationTokenIdentifier> token = this.namenode.getDelegationToken(renewer);
            if (token != null) {
                token.setService(this.dtService);
                LOG.info((Object)("Created " + DelegationTokenIdentifier.stringifyToken(token)));
            } else {
                LOG.info((Object)("Cannot get delegation token from " + renewer));
            }
            Token<DelegationTokenIdentifier> token2 = token;
            return token2;
        }
    }

    @Deprecated
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Renewing " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            return token.renew(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public static boolean isLocalAddress(InetSocketAddress targetAddr) {
        InetAddress addr = targetAddr.getAddress();
        Boolean cached = localAddrMap.get(addr.getHostAddress());
        if (cached != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Address " + targetAddr + (cached != false ? " is local" : " is not local")));
            }
            return cached;
        }
        boolean local = NetUtils.isLocalAddress((InetAddress)addr);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Address " + targetAddr + (local ? " is local" : " is not local")));
        }
        localAddrMap.put(addr.getHostAddress(), local);
        return local;
    }

    @Deprecated
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            token.cancel(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public LocatedBlocks getLocatedBlocks(String src, long start) throws IOException {
        return this.getLocatedBlocks(src, start, this.dfsClientConf.getPrefetchSize());
    }

    @VisibleForTesting
    public LocatedBlocks getLocatedBlocks(String src, long start, long length) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("getBlockLocations", src);){
            LocatedBlocks locatedBlocks = DFSClient.callGetBlockLocations(this.namenode, src, start, length);
            return locatedBlocks;
        }
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean recoverLease(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("recoverLease", src);){
            boolean bl = this.namenode.recoverLease(src, this.clientName);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException, UnresolvedLinkException {
        try (TraceScope ignored = this.newPathTraceScope("getBlockLocations", src);){
            LocatedBlocks blocks = this.getLocatedBlocks(src, start, length);
            BlockLocation[] locations = DFSUtilClient.locatedBlocks2Locations((LocatedBlocks)blocks);
            BlockLocation[] hdfsLocations = new HdfsBlockLocation[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                hdfsLocations[i] = new HdfsBlockLocation(locations[i], blocks.get(i));
            }
            BlockLocation[] blockLocationArray = hdfsLocations;
            return blockLocationArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockStorageLocation[] getBlockStorageLocations(List<BlockLocation> blockLocations) throws IOException, UnsupportedOperationException, InvalidBlockTokenException {
        Map<DatanodeInfo, HdfsBlocksMetadata> metadatas;
        if (!this.getConf().isHdfsBlocksMetadataEnabled()) {
            throw new UnsupportedOperationException("Datanode-side support for getVolumeBlockLocations() must also be enabled in the client configuration.");
        }
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        for (BlockLocation blockLocation : blockLocations) {
            if (!(blockLocation instanceof HdfsBlockLocation)) {
                throw new ClassCastException("DFSClient#getVolumeBlockLocations expected to be passed HdfsBlockLocations");
            }
            HdfsBlockLocation hdfsLoc = (HdfsBlockLocation)blockLocation;
            blocks.add(hdfsLoc.getLocatedBlock());
        }
        LinkedHashMap<DatanodeInfo, List<LocatedBlock>> datanodeBlocks = new LinkedHashMap<DatanodeInfo, List<LocatedBlock>>();
        for (LocatedBlock b : blocks) {
            for (DatanodeInfo info : b.getLocations()) {
                if (!datanodeBlocks.containsKey(info)) {
                    datanodeBlocks.put(info, new ArrayList());
                }
                List l = (List)datanodeBlocks.get(info);
                l.add(b);
            }
        }
        try (TraceScope traceScope = this.tracer.newScope("getBlockStorageLocations");){
            metadatas = BlockStorageLocationUtil.queryDatanodesForHdfsBlocksMetadata(this.conf, datanodeBlocks, this.getConf().getFileBlockStorageLocationsNumThreads(), this.getConf().getFileBlockStorageLocationsTimeoutMs(), this.getConf().isConnectToDnViaHostname(), this.tracer, traceScope.getSpanId());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("metadata returned: " + Joiner.on((String)"\n").withKeyValueSeparator("=").join(metadatas)));
            }
        }
        Map<LocatedBlock, List<VolumeId>> blockVolumeIds = BlockStorageLocationUtil.associateVolumeIdsWithBlocks(blocks, metadatas);
        BlockStorageLocation[] volumeBlockLocations = BlockStorageLocationUtil.convertToVolumeBlockLocations(blocks, blockVolumeIds);
        return volumeBlockLocations;
    }

    private KeyProvider.KeyVersion decryptEncryptedDataEncryptionKey(FileEncryptionInfo feInfo) throws IOException {
        KeyProvider provider = this.getKeyProvider();
        if (provider == null) {
            throw new IOException("No KeyProvider is configured, cannot access an encrypted file");
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion ekv = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)feInfo.getKeyName(), (String)feInfo.getEzKeyVersionName(), (byte[])feInfo.getIV(), (byte[])feInfo.getEncryptedDataEncryptionKey());
        try {
            KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)provider);
            return cryptoProvider.decryptEncryptedKey(ekv);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private static CryptoProtocolVersion getCryptoProtocolVersion(FileEncryptionInfo feInfo) throws IOException {
        CryptoProtocolVersion version = feInfo.getCryptoProtocolVersion();
        if (!CryptoProtocolVersion.supports((CryptoProtocolVersion)version)) {
            throw new IOException("Client does not support specified CryptoProtocolVersion " + version.getDescription() + " version number" + version.getVersion());
        }
        return version;
    }

    private static CryptoCodec getCryptoCodec(Configuration conf, FileEncryptionInfo feInfo) throws IOException {
        CipherSuite suite = feInfo.getCipherSuite();
        if (suite.equals((Object)CipherSuite.UNKNOWN)) {
            throw new IOException("NameNode specified unknown CipherSuite with ID " + suite.getUnknownValue() + ", cannot instantiate CryptoCodec.");
        }
        CryptoCodec codec = CryptoCodec.getInstance((Configuration)conf, (CipherSuite)suite);
        if (codec == null) {
            throw new UnknownCipherSuiteException("No configuration found for the cipher suite " + suite.getConfigSuffix() + " prefixed with " + "hadoop.security.crypto.codec.classes" + ". Please see the example configuration hadoop.security.crypto.codec.classes.EXAMPLECIPHERSUITE at core-default.xml for details.");
        }
        return codec;
    }

    public HdfsDataInputStream createWrappedInputStream(DFSInputStream dfsis) throws IOException {
        FileEncryptionInfo feInfo = dfsis.getFileEncryptionInfo();
        if (feInfo != null) {
            DFSClient.getCryptoProtocolVersion(feInfo);
            CryptoCodec codec = DFSClient.getCryptoCodec(this.conf, feInfo);
            KeyProvider.KeyVersion decrypted = this.decryptEncryptedDataEncryptionKey(feInfo);
            CryptoInputStream cryptoIn = new CryptoInputStream((InputStream)((Object)dfsis), codec, decrypted.getMaterial(), feInfo.getIV());
            return new HdfsDataInputStream(cryptoIn);
        }
        return new HdfsDataInputStream(dfsis);
    }

    public HdfsDataOutputStream createWrappedOutputStream(DFSOutputStream dfsos, FileSystem.Statistics statistics) throws IOException {
        return this.createWrappedOutputStream(dfsos, statistics, 0L);
    }

    public HdfsDataOutputStream createWrappedOutputStream(DFSOutputStream dfsos, FileSystem.Statistics statistics, long startPos) throws IOException {
        FileEncryptionInfo feInfo = dfsos.getFileEncryptionInfo();
        if (feInfo != null) {
            DFSClient.getCryptoProtocolVersion(feInfo);
            CryptoCodec codec = DFSClient.getCryptoCodec(this.conf, feInfo);
            KeyProvider.KeyVersion decrypted = this.decryptEncryptedDataEncryptionKey(feInfo);
            CryptoOutputStream cryptoOut = new CryptoOutputStream((OutputStream)((Object)dfsos), codec, decrypted.getMaterial(), feInfo.getIV(), startPos);
            return new HdfsDataOutputStream(cryptoOut, statistics, startPos);
        }
        return new HdfsDataOutputStream(dfsos, statistics, startPos);
    }

    public DFSInputStream open(String src) throws IOException, UnresolvedLinkException {
        return this.open(src, this.dfsClientConf.getIoBufferSize(), true, null);
    }

    @Deprecated
    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException, UnresolvedLinkException {
        return this.open(src, buffersize, verifyChecksum);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("newDFSInputStream", src);){
            DFSInputStream dFSInputStream = new DFSInputStream(this, src, verifyChecksum, this.dfsClientConf.getForceClientToWriteSFToDisk());
            return dFSInputStream;
        }
    }

    public ClientProtocol getNamenode() {
        return this.namenode;
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.getDefaultReplication(), this.dfsClientConf.getDefaultBlockSize(), null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.getDefaultReplication(), this.dfsClientConf.getDefaultBlockSize(), progress);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.dfsClientConf.getIoBufferSize());
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getFileDefault(), overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, buffersize, null, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt, EncodingPolicy policy) throws IOException {
        return this.create(src, permission, flag, true, replication, blockSize, progress, buffersize, checksumOpt, null, policy);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.create(src, permission, flag, createParent, replication, blockSize, progress, buffersize, checksumOpt, null, null);
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getFileDefault();
        }
        return permission.applyUMask(this.dfsClientConf.getUMask());
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt, InetSocketAddress[] favoredNodes, EncodingPolicy policy) throws IOException {
        this.checkOpen();
        FsPermission masked = this.applyUMask(permission);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + masked));
        }
        DFSOutputStream result = DFSOutputStream.newStreamForCreate(this, src, masked, flag, createParent, replication, blockSize, progress, buffersize, this.dfsClientConf.createChecksum(checksumOpt), this.getFavoredNodesStr(favoredNodes), policy, this.dfsClientConf.getDBFileMaxSize(), this.dfsClientConf.getForceClientToWriteSFToDisk());
        this.beginFileLease(result.getFileId(), result);
        return result;
    }

    private String[] getFavoredNodesStr(InetSocketAddress[] favoredNodes) {
        String[] favoredNodeStrs = null;
        if (favoredNodes != null) {
            favoredNodeStrs = new String[favoredNodes.length];
            for (int i = 0; i < favoredNodes.length; ++i) {
                favoredNodeStrs[i] = favoredNodes[i].getHostName() + ":" + favoredNodes[i].getPort();
            }
        }
        return favoredNodeStrs;
    }

    private DFSOutputStream primitiveAppend(String src, EnumSet<CreateFlag> flag, int buffersize, Progressable progress) throws IOException {
        if (flag.contains(CreateFlag.APPEND)) {
            HdfsFileStatus stat = this.getFileInfo(src);
            if (stat == null) {
                if (!flag.contains(CreateFlag.CREATE)) {
                    throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
                }
                return null;
            }
            return this.callAppend(src, buffersize, flag, progress, null);
        }
        return null;
    }

    public DFSOutputStream primitiveCreate(String src, FsPermission absPermission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        CreateFlag.validate(flag);
        DFSOutputStream result = this.primitiveAppend(src, flag, buffersize, progress);
        if (result == null) {
            DataChecksum checksum = this.dfsClientConf.createChecksum(checksumOpt);
            result = DFSOutputStream.newStreamForCreate(this, src, absPermission, flag, createParent, replication, blockSize, progress, buffersize, checksum, null, null, this.dfsClientConf.getDBFileMaxSize(), this.dfsClientConf.getForceClientToWriteSFToDisk());
        }
        this.beginFileLease(result.getFileId(), result);
        return result;
    }

    public void createSymlink(String target, String link, boolean createParent) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("createSymlink", target);){
            FsPermission dirPerm = this.applyUMask(null);
            this.namenode.createSymlink(target, link, dirPerm, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLinkTarget(String path) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("getLinkTarget", path);){
            String string = this.namenode.getLinkTarget(path);
            return string;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class});
        }
    }

    private DFSOutputStream callAppend(String src, int buffersize, EnumSet<CreateFlag> flag, Progressable progress, String[] favoredNodes) throws IOException {
        CreateFlag.validateForAppend(flag);
        try {
            LastBlockWithStatus blkWithStatus = this.namenode.append(src, this.clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(flag, CreateFlag.class));
            return DFSOutputStream.newStreamForAppend(this, src, flag, buffersize, progress, blkWithStatus.getLastBlock(), blkWithStatus.getFileStatus(), this.dfsClientConf.createChecksum(null), favoredNodes, this.dfsClientConf.getDBFileMaxSize(), this.dfsClientConf.getForceClientToWriteSFToDisk());
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnsupportedOperationException.class, UnresolvedPathException.class});
        }
    }

    public HdfsDataOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, flag, null, progress);
        return this.createWrappedOutputStream(out, statistics, out.getInitialLen());
    }

    public HdfsDataOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, Progressable progress, FileSystem.Statistics statistics, InetSocketAddress[] favoredNodes) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, flag, this.getFavoredNodesStr(favoredNodes), progress);
        return this.createWrappedOutputStream(out, statistics, out.getInitialLen());
    }

    private DFSOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, String[] favoredNodes, Progressable progress) throws IOException {
        this.checkOpen();
        DFSOutputStream result = this.callAppend(src, buffersize, flag, progress, favoredNodes);
        this.beginFileLease(result.getFileId(), result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplication(String src, short replication) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("setReplication", src);){
            boolean bl = this.namenode.setReplication(src, replication);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newSrcDstTraceScope("rename", src, dst);){
            boolean bl = this.namenode.rename(src, dst);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    public void concat(String trg, String[] srcs) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("concat");){
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public void rename(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newSrcDstTraceScope("rename2", src, dst);){
            this.namenode.rename2(src, dst, options);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public boolean truncate(String src, long newLength) throws IOException {
        this.checkOpen();
        if (newLength < 0L) {
            throw new HadoopIllegalArgumentException("Cannot truncate to a negative file size: " + newLength + ".");
        }
        try {
            return this.namenode.truncate(src, newLength, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.delete(src, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("delete", src);){
            if (this.getServerDefaults().getQuotaEnabled()) {
                boolean bl = this.leaderNN.delete(src, recursive);
                return bl;
            }
            boolean bl = this.namenode.delete(src, recursive);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException {
        return this.listPaths(src, startAfter, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DirectoryListing listPaths(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("listPaths", src);){
            DirectoryListing directoryListing = this.namenode.getListing(src, startAfter, needLocation);
            return directoryListing;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("getFileInfo", src);){
            HdfsFileStatus hdfsFileStatus = this.namenode.getFileInfo(src);
            return hdfsFileStatus;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileClosed(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("isFileClosed", src);){
            boolean bl = this.namenode.isFileClosed(src);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("getFileLinkInfo", src);){
            HdfsFileStatus hdfsFileStatus = this.namenode.getFileLinkInfo(src);
            return hdfsFileStatus;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void clearDataEncryptionKey() {
        LOG.debug((Object)"Clearing encryption key");
        DFSClient dFSClient = this;
        synchronized (dFSClient) {
            this.encryptionKey = null;
        }
    }

    boolean shouldEncryptData() throws IOException {
        FsServerDefaults d = this.getServerDefaults();
        return d == null ? false : d.getEncryptDataTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataEncryptionKey newDataEncryptionKey() throws IOException {
        if (this.shouldEncryptData()) {
            DFSClient dFSClient = this;
            synchronized (dFSClient) {
                if (this.encryptionKey == null || this.encryptionKey.expiryDate < Time.now()) {
                    LOG.debug((Object)"Getting new encryption token from NN");
                    this.encryptionKey = this.namenode.getDataEncryptionKey();
                }
                return this.encryptionKey;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MD5MD5CRC32FileChecksum getFileChecksum(String src, long length) throws IOException {
        this.checkOpen();
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        LocatedBlocks blockLocations = DFSClient.callGetBlockLocations(this.namenode, src, 0L, length);
        if (null == blockLocations) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        List locatedblocks = blockLocations.getLocatedBlocks();
        DataOutputBuffer md5out = new DataOutputBuffer();
        int bytesPerCRC = -1;
        DataChecksum.Type crcType = DataChecksum.Type.DEFAULT;
        long crcPerBlock = 0L;
        boolean refetchBlocks = false;
        int lastRetriedIndex = -1;
        long remaining = length;
        for (int i = 0; i < locatedblocks.size() && remaining > 0L; ++i) {
            LocatedBlock lb;
            ExtendedBlock block;
            if (refetchBlocks) {
                blockLocations = DFSClient.callGetBlockLocations(this.namenode, src, 0L, length);
                if (null == blockLocations) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                locatedblocks = blockLocations.getLocatedBlocks();
                refetchBlocks = false;
            }
            if (remaining < (block = (lb = (LocatedBlock)locatedblocks.get(i)).getBlock()).getNumBytes()) {
                block.setNumBytes(remaining);
            }
            DatanodeInfo[] datanodes = lb.getLocations();
            if ((remaining -= block.getNumBytes()) < block.getNumBytes()) {
                block.setNumBytes(remaining);
            }
            remaining -= block.getNumBytes();
            int timeout = 3000 * datanodes.length + this.dfsClientConf.getSocketTimeout();
            boolean done = false;
            for (int j = 0; !done && j < datanodes.length; ++j) {
                DataInputStream in;
                DataOutputStream out;
                block30: {
                    out = null;
                    in = null;
                    try {
                        DataChecksum.Type ct;
                        IOStreamPair pair = this.connectToDN(datanodes[j], timeout, lb);
                        out = new DataOutputStream(new BufferedOutputStream(pair.out, HdfsConstants.SMALL_BUFFER_SIZE));
                        in = new DataInputStream(pair.in);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("write to " + datanodes[j] + ": " + (Object)((Object)Op.BLOCK_CHECKSUM) + ", block=" + block));
                        }
                        new Sender(out).blockChecksum(block, (Token<BlockTokenIdentifier>)lb.getBlockToken());
                        DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
                        String logInfo = "for block " + block + " from datanode " + datanodes[j];
                        DataTransferProtoUtil.checkBlockOpStatus(reply, logInfo);
                        DataTransferProtos.OpBlockChecksumResponseProto checksumData = reply.getChecksumResponse();
                        int bpc = checksumData.getBytesPerCrc();
                        if (i == 0) {
                            bytesPerCRC = bpc;
                        } else if (bpc != bytesPerCRC) {
                            throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + bytesPerCRC);
                        }
                        long cpb = checksumData.getCrcPerBlock();
                        if (locatedblocks.size() > 1 && i == 0) {
                            crcPerBlock = cpb;
                        }
                        MD5Hash md5 = new MD5Hash(checksumData.getMd5().toByteArray());
                        md5.write((DataOutput)md5out);
                        if (checksumData.hasCrcType()) {
                            ct = PBHelper.convert(checksumData.getCrcType());
                        } else {
                            LOG.debug((Object)"Retrieving checksum from an earlier-version DataNode: inferring checksum by reading first byte");
                            ct = this.inferChecksumTypeByReading(lb, datanodes[j]);
                        }
                        if (i == 0) {
                            crcType = ct;
                        } else if (crcType != DataChecksum.Type.MIXED && crcType != ct) {
                            crcType = DataChecksum.Type.MIXED;
                        }
                        done = true;
                        if (!LOG.isDebugEnabled()) break block30;
                        if (i == 0) {
                            LOG.debug((Object)("set bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock));
                        }
                        LOG.debug((Object)("got reply from " + datanodes[j] + ": md5=" + md5));
                    }
                    catch (InvalidBlockTokenException ibte) {
                        block31: {
                            if (i <= lastRetriedIndex) break block31;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Got access token error in response to OP_BLOCK_CHECKSUM for file " + src + " for block " + block + " from datanode " + datanodes[j] + ". Will retry the block once."));
                            }
                            lastRetriedIndex = i--;
                            done = true;
                            refetchBlocks = true;
                            IOUtils.closeStream(in);
                            IOUtils.closeStream((Closeable)out);
                            break;
                        }
                        IOUtils.closeStream(in);
                        IOUtils.closeStream(out);
                        continue;
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("src=" + src + ", datanodes[" + j + "]=" + datanodes[j]), (Throwable)ie);
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeStream(in);
                                IOUtils.closeStream(out);
                                throw throwable;
                            }
                        }
                        IOUtils.closeStream((Closeable)in);
                        IOUtils.closeStream((Closeable)out);
                        continue;
                    }
                }
                IOUtils.closeStream((Closeable)in);
                IOUtils.closeStream((Closeable)out);
                continue;
            }
            if (done) continue;
            throw new IOException("Fail to get block MD5 for " + block);
        }
        MD5Hash fileMD5 = MD5Hash.digest((byte[])md5out.getData());
        switch (crcType) {
            case CRC32: {
                return new MD5MD5CRC32GzipFileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
            }
            case CRC32C: {
                return new MD5MD5CRC32CastagnoliFileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
            }
        }
        if (locatedblocks.size() == 0) {
            return new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOStreamPair connectToDN(DatanodeInfo dn, int timeout, LocatedBlock lb) throws IOException {
        boolean success = false;
        Socket sock = null;
        try {
            sock = this.socketFactory.createSocket();
            String dnAddr = dn.getXferAddr(this.getConf().isConnectToDnViaHostname());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connecting to datanode " + dnAddr));
            }
            NetUtils.connect((Socket)sock, (SocketAddress)NetUtils.createSocketAddr((String)dnAddr), (int)timeout);
            sock.setSoTimeout(timeout);
            OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock);
            SocketInputWrapper unbufIn = NetUtils.getInputStream((Socket)sock);
            IOStreamPair ret = this.saslClient.newSocketSend(sock, unbufOut, (InputStream)unbufIn, this, (Token<BlockTokenIdentifier>)lb.getBlockToken(), (DatanodeID)dn);
            success = true;
            IOStreamPair iOStreamPair = ret;
            return iOStreamPair;
        }
        finally {
            if (!success) {
                IOUtils.closeSocket((Socket)sock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataChecksum.Type inferChecksumTypeByReading(LocatedBlock lb, DatanodeInfo dn) throws IOException {
        DataChecksum.Type type;
        IOStreamPair pair = this.connectToDN(dn, this.dfsClientConf.getSocketTimeout(), lb);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(pair.out, HdfsConstants.SMALL_BUFFER_SIZE));
            DataInputStream in = new DataInputStream(pair.in);
            new Sender(out).readBlock(lb.getBlock(), (Token<BlockTokenIdentifier>)lb.getBlockToken(), this.clientName, 0L, 1L, true, CachingStrategy.newDefaultStrategy());
            DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
            String logInfo = "trying to read " + lb.getBlock() + " from datanode " + dn;
            DataTransferProtoUtil.checkBlockOpStatus(reply, logInfo);
            type = PBHelper.convert(reply.getReadOpChecksumInfo().getChecksum().getType());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{pair.in, pair.out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{pair.in, pair.out});
        return type;
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setPermission", src);){
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setOwner", src);){
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    private long[] callGetStats() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("getStats");){
            long[] lArray = this.namenode.getStats();
            return lArray;
        }
    }

    public FsStatus getDiskStatus() throws IOException {
        long[] rawNums = this.callGetStats();
        return new FsStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long getMissingBlocksCount() throws IOException {
        return this.callGetStats()[5];
    }

    public long getMissingReplOneBlocksCount() throws IOException {
        return this.callGetStats()[6];
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.callGetStats()[3];
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.callGetStats()[4];
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("listCorruptFileBlocks", path);){
            CorruptFileBlocks corruptFileBlocks = this.namenode.listCorruptFileBlocks(path, cookie);
            return corruptFileBlocks;
        }
    }

    public DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("datanodeReport");){
            DatanodeInfo[] datanodeInfoArray = this.namenode.getDatanodeReport(type);
            return datanodeInfoArray;
        }
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("datanodeStorageReport");){
            DatanodeStorageReport[] datanodeStorageReportArray = this.namenode.getDatanodeStorageReport(type);
            return datanodeStorageReportArray;
        }
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        if (this.leaderNN == null) {
            throw new IOException("no leader namenode availlable");
        }
        try (TraceScope ignored = this.tracer.newScope("setSafeMode");){
            for (ClientProtocol nn : this.allNNs) {
                if (this.proxyEquals(nn, this.leaderNN)) continue;
                nn.setSafeMode(action, isChecked);
            }
            boolean bl = this.leaderNN.setSafeMode(action, isChecked);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("addCacheDirective");){
            if (!flags.contains(CacheFlag.FORCE)) {
                long l = this.leaderNN.addCacheDirective(info, flags);
                return l;
            }
            long l = this.namenode.addCacheDirective(info, flags);
            return l;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("modifyCacheDirective");){
            if (!flags.contains(CacheFlag.FORCE)) {
                this.leaderNN.modifyCacheDirective(info, flags);
            } else {
                this.namenode.modifyCacheDirective(info, flags);
            }
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void removeCacheDirective(long id) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeCacheDirective");){
            this.namenode.removeCacheDirective(id);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        return new CacheDirectiveIterator(this.leaderNN, filter, this.tracer);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("addCachePool");){
            this.leaderNN.addCachePool(info);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("modifyCachePool");){
            this.namenode.modifyCachePool(info);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void removeCachePool(String poolName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeCachePool");){
            this.namenode.removeCachePool(poolName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        return new CachePoolIterator(this.leaderNN, this.tracer);
    }

    @VisibleForTesting
    ExtendedBlock getPreviousBlock(long fileId) {
        return this.filesBeingWritten.get(fileId).getBlock();
    }

    public void refreshNodes() throws IOException {
        try (TraceScope ignored = this.tracer.newScope("refreshNodes");){
            this.leaderNN.refreshNodes();
        }
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("setBalancerBandwidth");){
            this.namenode.setBalancerBandwidth(bandwidth);
        }
    }

    RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("rollingUpgrade");){
            RollingUpgradeInfo rollingUpgradeInfo = this.namenode.rollingUpgrade(action);
            return rollingUpgradeInfo;
        }
    }

    @Deprecated
    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null, true);
    }

    public boolean mkdirs(String src, FsPermission permission, boolean createParent) throws IOException {
        FsPermission masked = this.applyUMask(permission);
        return this.primitiveMkdir(src, masked, createParent);
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission) throws IOException {
        return this.primitiveMkdir(src, absPermission, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean primitiveMkdir(String src, FsPermission absPermission, boolean createParent) throws IOException {
        this.checkOpen();
        if (absPermission == null) {
            absPermission = this.applyUMask(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + absPermission));
        }
        try (TraceScope ignored = this.tracer.newScope("mkdir");){
            boolean bl = this.namenode.mkdirs(src, absPermission, createParent);
            return bl;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, InvalidPathException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ContentSummary getContentSummary(String src) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("getContentSummary", src);){
            ContentSummary contentSummary = this.namenode.getContentSummary(src);
            return contentSummary;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    void setQuota(String src, long namespaceQuota, long storagespaceQuota) throws IOException {
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || storagespaceQuota <= 0L && storagespaceQuota != Long.MAX_VALUE && storagespaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + storagespaceQuota);
        }
        try (TraceScope ignored = this.newPathTraceScope("setQuota", src);){
            this.leaderNN.setQuota(src, namespaceQuota, storagespaceQuota, null);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    void setQuotaByStorageType(String src, StorageType type, long quota) throws IOException {
        if (quota <= 0L && quota != Long.MAX_VALUE && quota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota :" + quota);
        }
        if (type == null) {
            throw new IllegalArgumentException("Invalid storage type(null)");
        }
        if (!type.supportTypeQuota()) {
            throw new IllegalArgumentException("Don't support Quota for storage type : " + type.toString());
        }
        try (TraceScope ignored = this.newPathTraceScope("setQuotaByStorageType", src);){
            this.leaderNN.setQuota(src, Long.MAX_VALUE, quota, type);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setTimes", src);){
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.checkOpen();
        try {
            this.namenode.createEncryptionZone(src, keyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getEZForPath(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        this.checkOpen();
        return new EncryptionZoneIterator(this.namenode);
    }

    public void setXAttr(String src, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setXAttr(src, XAttrHelper.buildXAttr(name, value), flag);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public byte[] getXAttr(String src, String name) throws IOException {
        this.checkOpen();
        try {
            List<XAttr> xAttrs = XAttrHelper.buildXAttrAsList(name);
            List<XAttr> result = this.namenode.getXAttrs(src, xAttrs);
            return XAttrHelper.getFirstXAttrValue(result);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public Map<String, byte[]> getXAttrs(String src) throws IOException {
        this.checkOpen();
        try {
            return XAttrHelper.buildXAttrMap(this.namenode.getXAttrs(src, null));
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public Map<String, byte[]> getXAttrs(String src, List<String> names) throws IOException {
        this.checkOpen();
        try {
            return XAttrHelper.buildXAttrMap(this.namenode.getXAttrs(src, XAttrHelper.buildXAttrs(names)));
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public List<String> listXAttrs(String src) throws IOException {
        this.checkOpen();
        try {
            Map<String, byte[]> xattrs = XAttrHelper.buildXAttrMap(this.namenode.listXAttrs(src));
            return Lists.newArrayList(xattrs.keySet());
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void removeXAttr(String src, String name) throws IOException {
        this.checkOpen();
        try {
            this.namenode.removeXAttr(src, XAttrHelper.buildXAttr(name));
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    void reportChecksumFailure(String file, ExtendedBlock blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ". Error repairing corrupt blocks. Bad blocks remain."), (Throwable)ie);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    public CachingStrategy getDefaultReadCachingStrategy() {
        return this.defaultReadCachingStrategy;
    }

    public CachingStrategy getDefaultWriteCachingStrategy() {
        return this.defaultWriteCachingStrategy;
    }

    public EncodingStatus getEncodingStatus(String filePath) throws IOException {
        try {
            return this.namenode.getEncodingStatus(filePath);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
    }

    public void encodeFile(String filePath, EncodingPolicy policy) throws IOException {
        this.namenode.encodeFile(filePath, policy);
    }

    public void revokeEncoding(String filePath, short replication) throws IOException {
        this.namenode.revokeEncoding(filePath, replication);
    }

    public LocatedBlock getRepairedBlockLocations(String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        return DFSClient.callGetRepairedBlockLocations(this.namenode, sourcePath, parityPath, block, isParity);
    }

    static LocatedBlock callGetRepairedBlockLocations(ClientProtocol namenode, String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        try {
            return namenode.getRepairedBlockLocations(sourcePath, parityPath, block, isParity);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void changeConf(List<String> props, List<String> newVals) throws IOException {
        for (ClientProtocol nn : this.allNNs) {
            nn.changeConf(props, newVals);
        }
    }

    public void checkAccess(String src, FsAction mode) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("checkAccess", src);){
            this.namenode.checkAccess(src, mode);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("modifyAclEntries", src);){
            this.namenode.modifyAclEntries(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeAclEntries");){
            this.namenode.removeAclEntries(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeDefaultAcl");){
            this.namenode.removeDefaultAcl(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void removeAcl(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeAcl");){
            this.namenode.removeAcl(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("setAcl");){
            this.namenode.setAcl(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AclStatus getAclStatus(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("getAclStatus", src);){
            AclStatus aclStatus = this.namenode.getAclStatus(src);
            return aclStatus;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AclException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorages, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        try {
            return this.namenode.getAdditionalDatanode(src, fileId, blk, existings, existingStorages, excludes, numAdditionalNodes, clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedLinkException.class});
        }
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("setStoragePolicy", src);){
            this.namenode.setStoragePolicy(src, policyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("getStoragePolicy");){
            BlockStoragePolicy blockStoragePolicy = this.namenode.getStoragePolicy(storagePolicyID);
            return blockStoragePolicy;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        try (TraceScope ignored = this.tracer.newScope("getStoragePolicies");){
            BlockStoragePolicy[] blockStoragePolicyArray = this.namenode.getStoragePolicies();
            return blockStoragePolicyArray;
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void setMetaStatus(String src, MetaStatus metaStatus) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("setMetaStatus");){
            this.namenode.setMetaStatus(src, metaStatus);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public int getNameNodesCount() throws IOException {
        return this.namenode.getActiveNamenodesForClient().size();
    }

    LastUpdatedContentSummary getLastUpdatedContentSummary(String src) throws IOException {
        try {
            return this.namenode.getLastUpdatedContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public LocatedBlocks getMissingLocatedBlocks(String src) throws IOException {
        try {
            return this.namenode.getMissingBlockLocations(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void addBlockChecksum(String src, int blockIndex, long checksum) throws IOException {
        try {
            this.namenode.addBlockChecksum(src, blockIndex, checksum);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public long getBlockChecksum(String filePath, int blockIndex) throws IOException {
        try {
            return this.namenode.getBlockChecksum(filePath, blockIndex);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
    }

    public DFSOutputStream sendBlock(String src, LocatedBlock block, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.checkOpen();
        HdfsFileStatus stat = this.getFileInfo(src);
        if (stat == null) {
            throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
        }
        DFSOutputStream result = DFSOutputStream.newStreamForSingleBlock(this, src, progress, block, this.dfsClientConf.createChecksum(checksumOpt), stat);
        return result;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
        Peer peer;
        block3: {
            Peer peer2 = null;
            boolean success = false;
            Socket sock = null;
            int socketTimeout = this.dfsClientConf.getSocketTimeout();
            try {
                sock = this.socketFactory.createSocket();
                NetUtils.connect((Socket)sock, (SocketAddress)addr, (SocketAddress)this.getRandomLocalInterfaceAddr(), (int)socketTimeout);
                peer2 = TcpPeerServer.peerFromSocketAndKey(this.saslClient, sock, this, blockToken, datanodeId);
                peer2.setReadTimeout(socketTimeout);
                success = true;
                peer = peer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{peer2});
                    IOUtils.closeSocket((Socket)sock);
                }
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{peer2});
            IOUtils.closeSocket((Socket)sock);
        }
        return peer;
    }

    private synchronized void initThreadsNumForHedgedReads(int num) {
        if (num <= 0 || HEDGED_READ_THREAD_POOL != null) {
            return;
        }
        HEDGED_READ_THREAD_POOL = new ThreadPoolExecutor(1, num, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new Daemon.DaemonFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                Thread t = super.newThread(r);
                t.setName("hedgedRead-" + this.threadIndex.getAndIncrement());
                return t;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor e) {
                LOG.info((Object)"Execution rejected, Executing in current thread");
                HEDGED_READ_METRIC.incHedgedReadOpsInCurThread();
                super.rejectedExecution(runnable, e);
            }
        });
        HEDGED_READ_THREAD_POOL.allowCoreThreadTimeOut(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using hedged reads; pool threads=" + num));
        }
    }

    ThreadPoolExecutor getHedgedReadsThreadPool() {
        return HEDGED_READ_THREAD_POOL;
    }

    boolean isHedgedReadsEnabled() {
        return HEDGED_READ_THREAD_POOL != null && HEDGED_READ_THREAD_POOL.getMaximumPoolSize() > 0;
    }

    DFSHedgedReadMetrics getHedgedReadMetrics() {
        return HEDGED_READ_METRIC;
    }

    public KeyProvider getKeyProvider() {
        return this.clientContext.getKeyProviderCache().get(this.conf);
    }

    @VisibleForTesting
    public void setKeyProvider(KeyProvider provider) {
        try {
            this.clientContext.getKeyProviderCache().setKeyProvider(this.conf, provider);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not set KeyProvider !!", (Throwable)e);
        }
    }

    public boolean hasLeader() {
        return this.leaderNN != null;
    }

    public void addUser(String userName) throws IOException {
        try {
            this.namenode.addUser(userName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void addGroup(String groupName) throws IOException {
        try {
            this.namenode.addGroup(groupName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void addUserToGroup(String userName, String groupName) throws IOException {
        try {
            this.namenode.addUserToGroup(userName, groupName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
        if (userName != null && groupName != null) {
            for (ClientProtocol nn : this.allNNs) {
                try {
                    if (this.proxyEquals(nn, this.namenode)) continue;
                    nn.invCachesUserAddedToGroup(userName, groupName);
                }
                catch (RemoteException re) {
                    throw re.unwrapRemoteException();
                }
            }
        }
    }

    public void removeUser(String userName) throws IOException {
        try {
            this.namenode.removeUser(userName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
        if (userName != null) {
            for (ClientProtocol nn : this.allNNs) {
                try {
                    if (this.proxyEquals(nn, this.namenode)) continue;
                    nn.invCachesUserRemoved(userName);
                }
                catch (RemoteException re) {
                    throw re.unwrapRemoteException();
                }
            }
        }
    }

    public void removeGroup(String groupName) throws IOException {
        try {
            this.namenode.removeGroup(groupName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
        if (groupName != null) {
            for (ClientProtocol nn : this.allNNs) {
                try {
                    if (this.proxyEquals(nn, this.namenode)) continue;
                    nn.invCachesGroupRemoved(groupName);
                }
                catch (RemoteException re) {
                    throw re.unwrapRemoteException();
                }
            }
        }
    }

    public void removeUserFromGroup(String userName, String groupName) throws IOException {
        try {
            this.namenode.removeUserFromGroup(userName, groupName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
        if (userName != null && groupName != null) {
            for (ClientProtocol nn : this.allNNs) {
                try {
                    if (this.proxyEquals(nn, this.namenode)) continue;
                    nn.invCachesUserRemovedFromGroup(userName, groupName);
                }
                catch (RemoteException re) {
                    throw re.unwrapRemoteException();
                }
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setNamenodes(Collection<ClientProtocol> namenodes) {
        this.allNNs.clear();
        this.allNNs.addAll(namenodes);
    }

    TraceScope newPathTraceScope(String description, String path) {
        TraceScope scope = this.tracer.newScope(description);
        if (path != null) {
            scope.addKVAnnotation("path", path);
        }
        return scope;
    }

    TraceScope newSrcDstTraceScope(String description, String src, String dst) {
        TraceScope scope = this.tracer.newScope(description);
        if (src != null) {
            scope.addKVAnnotation("src", src);
        }
        if (dst != null) {
            scope.addKVAnnotation("dst", dst);
        }
        return scope;
    }

    Tracer getTracer() {
        return this.tracer;
    }

    public boolean isHDFSEncryptionEnabled() {
        return this.conf.get("dfs.encryption.key.provider.uri", null) != null;
    }

    public SaslDataTransferClient getSaslDataTransferClient() {
        return this.saslClient;
    }

    private boolean proxyEquals(ClientProtocol a, ClientProtocol b) {
        if (!(a instanceof ProtocolTranslator) && !(b instanceof ProtocolTranslator)) {
            return a.equals(b);
        }
        Client.ConnectionId id1 = RPC.getConnectionIdForProxy((Object)a);
        Client.ConnectionId id2 = RPC.getConnectionIdForProxy((Object)b);
        return id1.getAddress().equals(id2.getAddress());
    }

    private void setClientEpoch() throws IOException {
        if (this.leaderNN != null) {
            long startTime = System.currentTimeMillis();
            long epoch = this.leaderNN.getEpochMS();
            long endTime = System.currentTimeMillis();
            long diff = (endTime - startTime) / 2L;
            Client.setEpoch((long)endTime, (long)(epoch + diff));
        }
    }

    static {
        localAddrMap = Collections.synchronizedMap(new HashMap());
    }

    @Deprecated
    public static class DFSDataInputStream
    extends HdfsDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals((Object)kind);
        }

        public long renew(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                return nn.renewDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(delToken)));
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                nn.cancelDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        private static ClientProtocol getNNProxy(Token<DelegationTokenIdentifier> token, Configuration conf) throws IOException {
            URI uri = HAUtilClient.getServiceUriFromToken((String)"hdfs", token);
            if (HAUtilClient.isTokenForLogicalUri(token) && !HAUtilClient.isLogicalUri((Configuration)conf, (URI)uri)) {
                throw new IOException("Unable to map logical nameservice URI '" + uri + "' to a NameNode. Local configuration does not have a failover proxy provider configured.");
            }
            NameNodeProxies.ProxyAndInfo<ClientProtocol> info = NameNodeProxies.createProxy(conf, uri, ClientProtocol.class);
            assert (info.getDelegationTokenService().equals((Object)token.getService())) : "Returned service '" + info.getDelegationTokenService().toString() + "' doesn't match expected service '" + token.getService().toString() + "'";
            return info.getProxy();
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        static {
            HdfsConfiguration.init();
        }
    }
}

