/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.hops.hadoop.shaded.com.google.protobuf.RpcController;
import io.hops.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class NamenodeProtocolTranslatorPB
implements NamenodeProtocol,
ProtocolMetaInterface,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private static final NamenodeProtocolProtos.GetBlockKeysRequestProto VOID_GET_BLOCKKEYS_REQUEST = NamenodeProtocolProtos.GetBlockKeysRequestProto.newBuilder().build();
    private static final HdfsProtos.VersionRequestProto VOID_VERSION_REQUEST = HdfsProtos.VersionRequestProto.newBuilder().build();
    private final NamenodeProtocolPB rpcProxy;

    public NamenodeProtocolTranslatorPB(NamenodeProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        NamenodeProtocolProtos.GetBlocksRequestProto req = NamenodeProtocolProtos.GetBlocksRequestProto.newBuilder().setDatanode(PBHelper.convert((DatanodeID)datanode)).setSize(size).build();
        try {
            return PBHelper.convert(this.rpcProxy.getBlocks(NULL_CONTROLLER, req).getBlocks());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        try {
            NamenodeProtocolProtos.GetBlockKeysResponseProto rsp = this.rpcProxy.getBlockKeys(NULL_CONTROLLER, VOID_GET_BLOCKKEYS_REQUEST);
            return rsp.hasKeys() ? PBHelper.convert(rsp.getKeys()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.versionRequest(NULL_CONTROLLER, VOID_VERSION_REQUEST).getInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, NamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (String)methodName);
    }
}

