/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerConfig;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerConfigTest {
    private ServerConfig serverConfig;

    @Before
    public void setUp() {
        this.serverConfig = new ServerConfig();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFewArguments() {
        String[] args = new String[]{"2181"};
        this.serverConfig.parse(args);
    }

    @Test
    public void testValidArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000"};
        this.serverConfig.parse(args);
        Assert.assertEquals((long)2181L, (long)this.serverConfig.getClientPortAddress().getPort());
        Assert.assertTrue((boolean)this.checkEquality("/data/dir", this.serverConfig.getDataDir()));
        Assert.assertEquals((long)60000L, (long)this.serverConfig.getTickTime());
        Assert.assertEquals((long)10000L, (long)this.serverConfig.getMaxClientCnxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTooManyArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000", "9999"};
        this.serverConfig.parse(args);
    }

    boolean checkEquality(String a, String b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return a.equals(b);
    }

    boolean checkEquality(String a, File b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return new File(a).equals(b);
    }
}

