/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.verification;

import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMarker;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationsFinder;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.VerificationData;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationMode;
import java.util.List;

public class AtMost
implements VerificationMode {
    private final int maxNumberOfInvocations;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public AtMost(int maxNumberOfInvocations) {
        if (maxNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.maxNumberOfInvocations = maxNumberOfInvocations;
    }

    public void verify(VerificationData data) {
        InvocationMatcher wanted;
        InvocationsFinder finder = new InvocationsFinder();
        List<Invocation> invocations = data.getAllInvocations();
        List<Invocation> found = finder.findInvocations(invocations, wanted = data.getWanted());
        int foundSize = found.size();
        if (foundSize > this.maxNumberOfInvocations) {
            new Reporter().wantedAtMostX(this.maxNumberOfInvocations, foundSize);
        }
        this.invocationMarker.markVerified(found, (CapturesArgumensFromInvocation)wanted);
    }
}

