/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent;

import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.CountedCompleter;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.ForkJoinTask;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.ForkJoinWorkerThread;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.JSR166Helper;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.ThreadLocalRandom;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ForkJoinPool
extends AbstractExecutorService {
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int EVENMASK = 65534;
    static final int SQMASK = 126;
    static final int SCANNING = 1;
    static final int INACTIVE = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int MODE_MASK = -65536;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 65536;
    static final int SHARED_QUEUE = Integer.MIN_VALUE;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int commonParallelism;
    private static int commonMaxSpares;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT = 2000000000L;
    private static final long TIMEOUT_SLOP = 20000000L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SPINS = 2048;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int AC_SHIFT = 48;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    private static final int RSLOCK = 1;
    private static final int RSIGNAL = 2;
    private static final int STARTED = 4;
    private static final int STOP = 0x20000000;
    private static final int TERMINATED = 0x40000000;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    volatile long ctl;
    volatile int runState;
    final int config;
    int indexSeed;
    volatile WorkQueue[] workQueues;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final String workerNamePrefix;
    volatile AtomicLong stealCounter;
    private static final JSR166Helper.Unsafe U;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long CTL;
    private static final long RUNSTATE;
    private static final long STEALCOUNTER;
    private static final long PARKBLOCKER;
    private static final long QTOP;
    private static final long QLOCK;
    private static final long QSCANSTATE;
    private static final long QPARKER;
    private static final long QCURRENTSTEAL;
    private static final long QCURRENTJOIN;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    static final ForkJoinTask<?> getAt(ForkJoinTask<?>[] a, int i) {
        return (ForkJoinTask)U.getObjectVolatile(a, (i << ASHIFT) + ABASE);
    }

    static final void setAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> x) {
        U.putOrderedObject(a, (i << ASHIFT) + ABASE, x);
    }

    static final boolean casAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> c, ForkJoinTask<?> v) {
        return U.compareAndSwapObject(a, (i << ASHIFT) + ABASE, c, v);
    }

    static final ForkJoinTask<?> xchgAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> x) {
        return (ForkJoinTask)U.getAndSetObject(a, (i << ASHIFT) + ABASE, x);
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    private int lockRunState() {
        int rs = this.runState;
        return (rs & 1) != 0 || !U.compareAndSwapInt(this, RUNSTATE, rs, rs |= 1) ? this.awaitRunStateLock() : rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int awaitRunStateLock() {
        boolean wasInterrupted = false;
        int spins = 2048;
        int r = 0;
        while (true) {
            block13: {
                AtomicLong lock;
                int rs;
                if (((rs = this.runState) & 1) == 0) {
                    int ns = rs | 1;
                    if (!U.compareAndSwapInt(this, RUNSTATE, rs, ns)) continue;
                    if (!wasInterrupted) return ns;
                    try {
                        Thread.currentThread().interrupt();
                        return ns;
                    }
                    catch (SecurityException ignore) {
                        // empty catch block
                    }
                    return ns;
                }
                if (r == 0) {
                    r = ThreadLocalRandom.nextSecondarySeed();
                    continue;
                }
                if (spins > 0) {
                    r ^= r << 6;
                    r ^= r >>> 21;
                    if ((r ^= r << 7) < 0) continue;
                    --spins;
                    continue;
                }
                if ((rs & 4) == 0 || (lock = this.stealCounter) == null) {
                    Thread.yield();
                    continue;
                }
                if (!U.compareAndSwapInt(this, RUNSTATE, rs, rs | 2)) continue;
                AtomicLong atomicLong = lock;
                synchronized (atomicLong) {
                    if ((this.runState & 2) != 0) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
                                wasInterrupted = true;
                            }
                            break block13;
                        }
                    }
                    lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockRunState(int oldRunState, int newRunState) {
        if (!U.compareAndSwapInt(this, RUNSTATE, oldRunState, newRunState)) {
            AtomicLong lock = this.stealCounter;
            this.runState = newRunState;
            if (lock != null) {
                AtomicLong atomicLong = lock;
                synchronized (atomicLong) {
                    lock.notifyAll();
                }
            }
        }
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    private void tryAddWorker(long c) {
        boolean add = false;
        do {
            long nc = 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L;
            if (this.ctl != c) continue;
            int rs = this.lockRunState();
            int stop = rs & 0x20000000;
            if (stop == 0) {
                add = U.compareAndSwapLong(this, CTL, c, nc);
            }
            this.unlockRunState(rs, rs & 0xFFFFFFFE);
            if (stop != 0) break;
            if (!add) continue;
            this.createWorker();
            break;
        } while (((c = this.ctl) & 0x800000000000L) != 0L && (int)c == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread wt) {
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        WorkQueue w = new WorkQueue(this, wt);
        int i = 0;
        int mode = this.config & 0xFFFF0000;
        int rs = this.lockRunState();
        try {
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && (n = ws.length) > 0) {
                int s = this.indexSeed += -1640531527;
                int m = n - 1;
                i = (s << 1 | 1) & m;
                if (ws[i] != null) {
                    int step;
                    int probes = 0;
                    int n2 = step = n <= 4 ? 2 : (n >>> 1 & 0xFFFE) + 2;
                    while (ws[i = i + step & m] != null) {
                        if (++probes < n) continue;
                        this.workQueues = ws = Arrays.copyOf(ws, n <<= 1);
                        m = n - 1;
                        probes = 0;
                    }
                }
                w.hint = s;
                w.config = i | mode;
                w.scanState = i;
                ws[i] = w;
            }
        }
        finally {
            this.unlockRunState(rs, rs & 0xFFFFFFFE);
        }
        wt.setName(this.workerNamePrefix.concat(Integer.toString(i >>> 1)));
        return w;
    }

    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        long c;
        WorkQueue w = null;
        if (wt != null && (w = wt.workQueue) != null) {
            int idx = w.config & 0xFFFF;
            int rs = this.lockRunState();
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && ws.length > idx && ws[idx] == w) {
                ws[idx] = null;
            }
            this.unlockRunState(rs, rs & 0xFFFFFFFE);
        }
        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c)) {
        }
        if (w != null) {
            w.qlock = -1;
            w.transferStealCount(this);
            w.cancelAll();
        }
        while (!this.tryTerminate(false, false) && w != null && w.array != null && (this.runState & 0x20000000) == 0) {
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (m = ws.length - 1) < 0) break;
            c = this.ctl;
            int sp = (int)c;
            if (sp != 0) {
                if (!this.tryRelease(c, ws[sp & m], 0x1000000000000L)) continue;
                break;
            }
            if (ex == null || (c & 0x800000000000L) == 0L) break;
            this.tryAddWorker(c);
            break;
        }
        if (ex == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(ex);
        }
    }

    final void signalWork(WorkQueue[] ws, WorkQueue q) {
        long c;
        while ((c = this.ctl) < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                this.tryAddWorker(c);
                break;
            }
            if (ws == null || ws.length <= (i = sp & 0xFFFF) || (v = ws[i]) == null) break;
            int vs = sp + 65536 & Integer.MAX_VALUE;
            int d = sp - v.scanState;
            long nc = 0xFFFFFFFF00000000L & c + 0x1000000000000L | 0xFFFFFFFFL & (long)v.stackPred;
            if (d == 0 && U.compareAndSwapLong(this, CTL, c, nc)) {
                v.scanState = vs;
                Thread p = v.parker;
                if (p == null) break;
                U.unpark(p);
                break;
            }
            if (q == null || q.base != q.top) continue;
            break;
        }
    }

    private boolean tryRelease(long c, WorkQueue v, long inc) {
        long nc;
        int sp = (int)c;
        int vs = sp + 65536 & Integer.MAX_VALUE;
        if (v != null && v.scanState == sp && U.compareAndSwapLong(this, CTL, c, nc = 0xFFFFFFFF00000000L & c + inc | 0xFFFFFFFFL & (long)v.stackPred)) {
            v.scanState = vs;
            Thread p = v.parker;
            if (p != null) {
                U.unpark(p);
            }
            return true;
        }
        return false;
    }

    final void runWorker(WorkQueue w) {
        int r;
        w.growArray();
        int seed = w.hint;
        int n = r = seed == 0 ? 1 : seed;
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.scan(w, r)) != null) {
                w.runTask(t);
            } else if (!this.awaitWork(w, r)) break;
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        }
    }

    private ForkJoinTask<?> scan(WorkQueue w, int r) {
        int m;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0 && w != null) {
            int origin;
            int ss = w.scanState;
            int k = origin = r & m;
            int oldSum = 0;
            int checkSum = 0;
            while (true) {
                long c;
                WorkQueue q;
                if ((q = ws[k]) != null) {
                    int al;
                    int b = q.base;
                    ForkJoinTask<?>[] a = q.array;
                    int n = b - q.top;
                    if (n < 0 && a != null && (al = a.length) > 0) {
                        int i = al - 1 & b;
                        ForkJoinTask<?> t = ForkJoinPool.getAt(a, i);
                        if (t != null && q.base == b) {
                            if (ss >= 0) {
                                if (ForkJoinPool.casAt(a, i, t, null)) {
                                    q.base = b + 1;
                                    if (n < -1) {
                                        this.signalWork(ws, q);
                                    }
                                    return t;
                                }
                            } else if (oldSum == 0 && w.scanState < 0) {
                                c = this.ctl;
                                this.tryRelease(c, ws[m & (int)c], 0x1000000000000L);
                            }
                        }
                        if (ss < 0) {
                            ss = w.scanState;
                        }
                        r ^= r << 1;
                        r ^= r >>> 3;
                        r ^= r << 10;
                        origin = k = r & m;
                        checkSum = 0;
                        oldSum = 0;
                        continue;
                    }
                    checkSum += b;
                }
                if ((k = k + 1 & m) != origin) continue;
                if ((ss >= 0 || ss == (ss = w.scanState)) && oldSum == (oldSum = checkSum)) {
                    if (ss < 0 || w.qlock < 0) break;
                    int ns = ss | Integer.MIN_VALUE;
                    c = this.ctl;
                    long nc = 0xFFFFFFFFL & (long)ns | 0xFFFFFFFF00000000L & c - 0x1000000000000L;
                    w.stackPred = (int)c;
                    U.putInt(w, QSCANSTATE, ns);
                    if (U.compareAndSwapLong(this, CTL, c, nc)) {
                        ss = ns;
                    } else {
                        w.scanState = ss;
                    }
                }
                checkSum = 0;
            }
        }
        return null;
    }

    private boolean awaitWork(WorkQueue w, int r) {
        int ss;
        if (w == null || w.qlock < 0) {
            return false;
        }
        int pred = w.stackPred;
        int spins = 2048;
        while ((ss = w.scanState) < 0) {
            long deadline;
            long parkTime;
            long prevctl;
            if (spins > 0) {
                WorkQueue v;
                int j;
                r ^= r << 6;
                r ^= r >>> 21;
                if ((r ^= r << 7) < 0 || --spins != 0 || pred == 0) continue;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues == null || (j = pred & 0xFFFF) >= ws.length || (v = ws[j]) == null || v.parker != null && v.scanState < 0) continue;
                spins = 2048;
                continue;
            }
            if (w.qlock < 0) {
                return false;
            }
            if (Thread.interrupted()) continue;
            long c = this.ctl;
            int ac = (int)(c >> 48) + (this.config & 0xFFFF);
            if (ac <= 0 && this.tryTerminate(false, false) || (this.runState & 0x20000000) != 0) {
                return false;
            }
            if (ac <= 0 && ss == (int)c) {
                prevctl = 0xFFFFFFFF00000000L & c + 0x1000000000000L | 0xFFFFFFFFL & (long)pred;
                short t = (short)(c >>> 32);
                if (t > 2 && U.compareAndSwapLong(this, CTL, c, prevctl)) {
                    return false;
                }
                parkTime = 2000000000L * (long)(t >= 0 ? 1 : 1 - t);
                deadline = System.nanoTime() + parkTime - 20000000L;
            } else {
                deadline = 0L;
                parkTime = 0L;
                prevctl = 0L;
            }
            Thread wt = Thread.currentThread();
            U.putObject(wt, PARKBLOCKER, this);
            w.parker = wt;
            if (w.scanState < 0 && this.ctl == c) {
                U.park(false, parkTime);
            }
            U.putOrderedObject(w, QPARKER, null);
            U.putObject(wt, PARKBLOCKER, null);
            if (w.scanState >= 0) break;
            if (parkTime == 0L || this.ctl != c || deadline - System.nanoTime() > 0L || !U.compareAndSwapLong(this, CTL, c, prevctl)) continue;
            return false;
        }
        return true;
    }

    final int helpComplete(WorkQueue w, CountedCompleter<?> task, int maxTasks) {
        int m;
        int s = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0 && task != null && w != null) {
            int mode = w.config;
            int r = w.hint ^ w.top;
            int origin = r & m;
            int h = 1;
            int k = origin;
            int oldSum = 0;
            int checkSum = 0;
            while ((s = task.status) >= 0) {
                CountedCompleter<?> p;
                if (h == 1 && (p = w.popCC(task, mode)) != null) {
                    p.doExec();
                    if (maxTasks != 0 && --maxTasks == 0) break;
                    origin = k;
                    checkSum = 0;
                    oldSum = 0;
                    continue;
                }
                WorkQueue q = ws[k];
                if (q == null) {
                    h = 0;
                } else {
                    h = q.pollAndExecCC(task);
                    if (h < 0) {
                        checkSum += h;
                    }
                }
                if (h > 0) {
                    if (h == 1 && maxTasks != 0 && --maxTasks == 0) break;
                    r ^= r << 13;
                    r ^= r >>> 17;
                    r ^= r << 5;
                    origin = k = r & m;
                    checkSum = 0;
                    oldSum = 0;
                    continue;
                }
                if ((k = k + 1 & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break;
                checkSum = 0;
            }
        }
        return s;
    }

    private void helpStealer(WorkQueue w, ForkJoinTask<?> task) {
        block9: {
            int checkSum;
            int m;
            WorkQueue[] ws = this.workQueues;
            int oldSum = 0;
            if (ws == null || (m = ws.length - 1) <= 0 || w == null || task == null) break block9;
            block0: do {
                checkSum = 0;
                WorkQueue j = w;
                ForkJoinTask<?> subtask = task;
                block1: while (subtask.status >= 0) {
                    int h = j.hint | 1;
                    for (int k = 0; k <= m; k += 2) {
                        int i = h + k & m;
                        WorkQueue v = ws[i];
                        if (v == null) continue;
                        if (v.currentSteal != subtask) {
                            checkSum += v.base;
                            continue;
                        }
                        j.hint = i;
                        while (true) {
                            int al;
                            ForkJoinTask<?>[] a;
                            int b;
                            block11: {
                                ForkJoinTask<?> next;
                                block10: {
                                    b = v.base;
                                    checkSum += b;
                                    next = v.currentJoin;
                                    if (subtask.status < 0 || j.currentJoin != subtask || v.currentSteal != subtask) continue block0;
                                    if (b - v.top >= 0) break block10;
                                    a = v.array;
                                    if (v.array != null && (al = a.length) > 0) break block11;
                                }
                                if ((subtask = next) == null) continue block0;
                                j = v;
                                continue block1;
                            }
                            int i2 = al - 1 & b;
                            ForkJoinTask<?> t = ForkJoinPool.getAt(a, i2);
                            if (v.base != b) continue;
                            if (t == null) continue block0;
                            if (!ForkJoinPool.casAt(a, i2, t, null)) continue;
                            v.base = b + 1;
                            ForkJoinTask<?> ps = w.currentSteal;
                            int top = w.top;
                            do {
                                U.putOrderedObject(w, QCURRENTSTEAL, t);
                                t.doExec();
                            } while (task.status >= 0 && w.top != top && (t = w.pop()) != null);
                            U.putOrderedObject(w, QCURRENTSTEAL, ps);
                            if (w.base != w.top) break;
                        }
                        return;
                    }
                }
            } while (task.status >= 0 && oldSum != (oldSum = checkSum));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryCompensate(WorkQueue w) {
        if (w == null) return false;
        if (w.qlock < 0) return false;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues == null) return false;
        int m = ws.length - 1;
        if (m <= 0) return false;
        int pc = this.config & 0xFFFF;
        if (pc == 0) {
            return false;
        }
        long c = this.ctl;
        int sp = (int)c;
        if (sp != 0) {
            return this.tryRelease(c, ws[sp & m], 0L);
        }
        int ac = (int)(c >> 48) + pc;
        int tc = (short)(c >> 32) + pc;
        int nbusy = 0;
        for (int i = 0; i <= m; ++i) {
            WorkQueue v = ws[(i << 1 | 1) & m];
            if (v == null) continue;
            if ((v.scanState & 1) != 0) break;
            ++nbusy;
        }
        if (nbusy != tc << 1) return false;
        if (this.ctl != c) {
            return false;
        }
        if (tc >= pc && ac > 1 && w.isEmpty()) {
            long nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
            return U.compareAndSwapLong(this, CTL, c, nc);
        }
        if (tc >= Short.MAX_VALUE) throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
        if (this == common && tc >= pc + commonMaxSpares) {
            throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
        }
        boolean add = false;
        long nc = 0xFFFF000000000000L & c | 0xFFFF00000000L & c + 0x100000000L;
        int rs = this.lockRunState();
        if ((rs & 0x20000000) == 0) {
            add = U.compareAndSwapLong(this, CTL, c, nc);
        }
        this.unlockRunState(rs, rs & 0xFFFFFFFE);
        if (!add) return false;
        if (!this.createWorker()) return false;
        return true;
    }

    final int awaitJoin(WorkQueue w, ForkJoinTask<?> task, long deadline) {
        int s = 0;
        if (task != null && w != null) {
            CountedCompleter cc;
            ForkJoinTask<?> prevJoin = w.currentJoin;
            U.putOrderedObject(w, QCURRENTJOIN, task);
            CountedCompleter countedCompleter = cc = task instanceof CountedCompleter ? (CountedCompleter)task : null;
            while ((s = task.status) >= 0) {
                long ms;
                if (cc != null) {
                    this.helpComplete(w, cc, 0);
                } else if (w.base == w.top || w.tryRemoveAndExec(task)) {
                    this.helpStealer(w, task);
                }
                s = task.status;
                if (s < 0) break;
                if (deadline == 0L) {
                    ms = 0L;
                } else {
                    long ns = deadline - System.nanoTime();
                    if (ns <= 0L) break;
                    ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms <= 0L) {
                        ms = 1L;
                    }
                }
                if (!this.tryCompensate(w)) continue;
                task.internalWait(ms);
                U.getAndAddLong(this, CTL, 0x1000000000000L);
            }
            U.putOrderedObject(w, QCURRENTJOIN, prevJoin);
        }
        return s;
    }

    private WorkQueue findNonEmptyStealQueue() {
        int m;
        int r = ThreadLocalRandom.nextSecondarySeed();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0) {
            int origin;
            int k = origin = r & m;
            int oldSum = 0;
            int checkSum = 0;
            while (true) {
                WorkQueue q;
                if ((q = ws[k]) != null) {
                    int b = q.base;
                    if (b - q.top < 0) {
                        return q;
                    }
                    checkSum += b;
                }
                if ((k = k + 1 & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break;
                checkSum = 0;
            }
        }
        return null;
    }

    final void helpQuiescePool(WorkQueue w) {
        ForkJoinTask<?> ps = w.currentSteal;
        boolean active = true;
        while (true) {
            long c;
            if ((w.config & 0x10000) != 0) {
                w.pollAndExecAll();
            } else {
                w.popAndExecAll();
            }
            WorkQueue q = this.findNonEmptyStealQueue();
            if (q != null) {
                ForkJoinTask<?> t;
                int b;
                if (!active) {
                    active = true;
                    U.getAndAddLong(this, CTL, 0x1000000000000L);
                }
                if ((b = q.base) - q.top >= 0 || (t = q.pollAt(b)) == null) continue;
                U.putOrderedObject(w, QCURRENTSTEAL, t);
                t.doExec();
                if (++w.nsteals >= 0) continue;
                w.transferStealCount(this);
                continue;
            }
            if (active) {
                c = this.ctl;
                long nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                if ((int)(nc >> 48) + (this.config & 0xFFFF) > 0) {
                    if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
                    active = false;
                    continue;
                }
                break;
            }
            c = this.ctl;
            if ((int)(c >> 48) + (this.config & 0xFFFF) <= 0 && U.compareAndSwapLong(this, CTL, c, c + 0x1000000000000L)) break;
        }
        U.putOrderedObject(w, QCURRENTSTEAL, ps);
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        ForkJoinTask<?> t;
        WorkQueue q;
        int b;
        do {
            if ((t = w.nextLocalTask()) != null) {
                return t;
            }
            q = this.findNonEmptyStealQueue();
            if (q != null) continue;
            return null;
        } while ((b = q.base) - q.top >= 0 || (t = q.pollAt(b)) == null);
        return t;
    }

    static int getSurplusQueuedTaskCount() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool pool = wt.pool;
            int p = pool.config & 0xFFFF;
            WorkQueue q = wt.workQueue;
            int n = q.top - q.base;
            int a = (int)(pool.ctl >> 48) + p;
            return n - (a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8))));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        if (this == ForkJoinPool.common) {
            return false;
        }
        rs = this.runState;
        if (rs >= 0) {
            if (!enable) {
                return false;
            }
            rs = this.lockRunState();
            this.unlockRunState(rs, rs & -2 | -2147483648);
        }
        if ((rs & 0x20000000) == 0) {
            if (!now) {
                oldSum = 0L;
                do {
                    if ((int)((checkSum = this.ctl) >> 48) + (this.config & 65535) > 0) {
                        return false;
                    }
                    ws = this.workQueues;
                    if (this.workQueues == null || (m = ws.length - 1) <= 0) break;
                    for (i = 0; i <= m; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        b = w.base;
                        if (b != w.top || w.scanState >= 0 || w.currentSteal != null) {
                            c = this.ctl;
                            this.tryRelease(c, ws[m & (int)c], 0x1000000000000L);
                            return false;
                        }
                        checkSum += (long)b;
                        if ((i & 1) != 0) continue;
                        w.qlock = -1;
                    }
                } while (oldSum != (oldSum = checkSum));
            }
            if ((this.runState & 0x20000000) == 0) {
                rs = this.lockRunState();
                this.unlockRunState(rs, rs & -2 | 0x20000000);
            }
        }
        pass = 0;
        oldSum = 0L;
        block7: while (true) {
            block25: {
                block24: {
                    if ((short)((checkSum = this.ctl) >>> 32) + (this.config & 65535) <= 0) break block24;
                    ws = this.workQueues;
                    if (this.workQueues != null && (m = ws.length - 1) > 0) break block25;
                }
                if ((this.runState & 0x40000000) != 0) break;
                rs = this.lockRunState();
                this.unlockRunState(rs, rs & -2 | 0x40000000);
                var13_19 = this;
                synchronized (var13_19) {
                    this.notifyAll();
                    break;
                }
            }
            for (i = 0; i <= m; ++i) {
                w = ws[i];
                if (w == null) continue;
                checkSum += (long)w.base;
                w.qlock = -1;
                if (pass <= 0) continue;
                w.cancelAll();
                if (pass <= 1 || (wt = w.owner) == null) continue;
                if (!wt.isInterrupted()) {
                    try {
                        wt.interrupt();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if (w.scanState >= 0) continue;
                ForkJoinPool.U.unpark(wt);
            }
            if (checkSum != oldSum) {
                oldSum = checkSum;
                pass = 0;
                continue;
            }
            if (pass > 3 && pass > m) break;
            if (++pass <= 1) continue;
            j = 0;
            while (true) {
                if (j++ <= m && (sp = (int)(c = this.ctl)) != 0) ** break;
                continue block7;
                this.tryRelease(c, ws[sp & m], 0x1000000000000L);
            }
            break;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void externalSubmit(ForkJoinTask<?> task) {
        r = ThreadLocalRandom.getProbe();
        if (r == 0) {
            ThreadLocalRandom.localInit();
            r = ThreadLocalRandom.getProbe();
        }
        while (true) {
            move = false;
            rs = this.runState;
            if (rs < 0) {
                this.tryTerminate(false, false);
                throw new RejectedExecutionException();
            }
            if ((rs & 4) == 0) ** GOTO lbl-1000
            ws = this.workQueues;
            if (this.workQueues == null || (m = ws.length - 1) <= 0) lbl-1000:
            // 2 sources

            {
                ns = 0;
                rs = this.lockRunState();
                try {
                    if ((rs & 4) != 0) ** GOTO lbl75
                    ForkJoinPool.U.compareAndSwapObject(this, ForkJoinPool.STEALCOUNTER, null, new AtomicLong());
                    p = this.config & 65535;
                    n = p > 1 ? p - 1 : 1;
                    n |= n >>> 1;
                    n |= n >>> 2;
                    n |= n >>> 4;
                    n |= n >>> 8;
                    n |= n >>> 16;
                    n = n + 1 << 1;
                    this.workQueues = new WorkQueue[n];
                    ns = 4;
                }
                finally {
                    this.unlockRunState(rs, rs & -2 | ns);
                }
            } else {
                k = r & m & 126;
                q = ws[k];
                if (q != null) {
                    if (q.qlock == 0 && ForkJoinPool.U.compareAndSwapInt(q, ForkJoinPool.QLOCK, 0, 1)) {
                        a = q.array;
                        s = q.top;
                        submitted = false;
                        try {
                            if (a != null && a.length > s + 1 - q.base || (a = q.growArray()) != null) {
                                al = a.length;
                                j = al - 1 & s;
                                if (al > 0) {
                                    ForkJoinPool.setAt(a, j, task);
                                    ForkJoinPool.U.putOrderedInt(q, ForkJoinPool.QTOP, s + 1);
                                    submitted = true;
                                }
                            }
                        }
                        finally {
                            ForkJoinPool.U.compareAndSwapInt(q, ForkJoinPool.QLOCK, 1, 0);
                        }
                        if (submitted) {
                            this.signalWork(ws, q);
                            return;
                        }
                    }
                    move = true;
                } else {
                    rs = this.runState;
                    if ((rs & 1) == 0) {
                        q = new WorkQueue(this, null);
                        q.hint = r;
                        q.config = k | -2147483648;
                        q.scanState = -2147483648;
                        rs = this.lockRunState();
                        if (rs > 0) {
                            ws = this.workQueues;
                            if (this.workQueues != null && k < ws.length && ws[k] == null) {
                                ws[k] = q;
                            }
                        }
                        this.unlockRunState(rs, rs & -2);
                    } else {
                        move = true;
                    }
                }
            }
lbl75:
            // 5 sources

            if (!move) continue;
            r = ThreadLocalRandom.advanceProbe(r);
        }
    }

    final void externalPush(ForkJoinTask<?> task) {
        WorkQueue q;
        int m;
        int r = ThreadLocalRandom.getProbe();
        int rs = this.runState;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0 && (q = ws[m & r & 0x7E]) != null && r != 0 && rs > 0 && U.compareAndSwapInt(q, QLOCK, 0, 1)) {
            ForkJoinTask<?>[] a = q.array;
            if (q.array != null) {
                int b = q.base;
                int al = a.length;
                int s = q.top;
                if (al > 0) {
                    int am = al - 1;
                    int j = am & s;
                    int n = s - b;
                    if (n < am) {
                        ForkJoinPool.setAt(a, j, task);
                        U.putOrderedInt(q, QTOP, s + 1);
                        U.putOrderedInt(q, QLOCK, 0);
                        if (n <= 1) {
                            this.signalWork(ws, q);
                        }
                        return;
                    }
                }
            }
            U.compareAndSwapInt(q, QLOCK, 1, 0);
        }
        this.externalSubmit(task);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        ForkJoinPool p = common;
        int r = ThreadLocalRandom.getProbe();
        if (p == null) return null;
        WorkQueue[] ws = p.workQueues;
        if (p.workQueues == null) return null;
        int m = ws.length - 1;
        if (m <= 0) return null;
        WorkQueue workQueue = ws[m & r & 0x7E];
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> task) {
        WorkQueue w;
        int m;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m = ws.length - 1) > 0 && (w = ws[m & r & 0x7E]) != null) {
            ForkJoinTask<?>[] a = w.array;
            if (w.array != null) {
                int b = w.base;
                int al = a.length;
                int s = w.top;
                if (s != b && al > 0 && U.compareAndSwapInt(w, QLOCK, 0, 1)) {
                    int i = al - 1 & s - 1;
                    if (w.top == s && w.array == a && ForkJoinPool.casAt(a, i, task, null)) {
                        U.putOrderedInt(w, QTOP, s - 1);
                        U.putOrderedInt(w, QLOCK, 0);
                        return true;
                    }
                    U.compareAndSwapInt(w, QLOCK, 1, 0);
                }
            }
        }
        return false;
    }

    final int externalHelpComplete(CountedCompleter<?> task, int maxTasks) {
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues == null || (n = ws.length) == 0 ? 0 : this.helpComplete(ws[n - 1 & r & 0x7E], task, maxTasks);
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        this(ForkJoinPool.checkParallelism(parallelism), ForkJoinPool.checkFactory(factory), handler, asyncMode ? 65536 : 0, "ForkJoinPool-" + ForkJoinPool.nextPoolId() + "-worker-");
        ForkJoinPool.checkPermission();
    }

    private static int checkParallelism(int parallelism) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return parallelism;
    }

    private static ForkJoinWorkerThreadFactory checkFactory(ForkJoinWorkerThreadFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        return factory;
    }

    private ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, int mode, String workerNamePrefix) {
        this.workerNamePrefix = workerNamePrefix;
        this.factory = factory;
        this.ueh = handler;
        this.config = parallelism & 0xFFFF | mode;
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.externalPush(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.externalPush(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.RunnableExecuteAction(task);
        this.externalPush(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.externalPush(task);
        return task;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        ForkJoinTask.AdaptedCallable<T> job = new ForkJoinTask.AdaptedCallable<T>(task);
        this.externalPush(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        ForkJoinTask.AdaptedRunnable<T> job = new ForkJoinTask.AdaptedRunnable<T>(task, result);
        this.externalPush(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        this.externalPush(job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> arrayList;
        block7: {
            int size;
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
            boolean done = false;
            try {
                for (Callable<T> t : tasks) {
                    ForkJoinTask.AdaptedCallable<T> f = new ForkJoinTask.AdaptedCallable<T>(t);
                    futures.add(f);
                    this.externalPush(f);
                }
                int size2 = futures.size();
                for (int i = 0; i < size2; ++i) {
                    ((ForkJoinTask)futures.get(i)).quietlyJoin();
                }
                done = true;
                arrayList = futures;
                if (done) break block7;
                size = futures.size();
            }
            catch (Throwable throwable) {
                if (!done) {
                    int size3 = futures.size();
                    for (int i = 0; i < size3; ++i) {
                        ((Future)futures.get(i)).cancel(false);
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < size; ++i) {
                futures.get(i).cancel(false);
            }
        }
        return arrayList;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int par = this.config & 0xFFFF;
        return par > 0 ? par : 1;
    }

    public static int getCommonPoolParallelism() {
        return commonParallelism;
    }

    public int getPoolSize() {
        return (this.config & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.config & 0x10000) != 0;
    }

    public int getRunningThreadCount() {
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || !w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = (this.config & 0xFFFF) + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        return (this.config & 0xFFFF) + (int)(this.ctl >> 48) <= 0;
    }

    public long getStealCount() {
        AtomicLong sc = this.stealCounter;
        long count = sc == null ? 0L : sc.get();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.nsteals;
            }
        }
        return count;
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.queueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += w.queueSize();
            }
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || w.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null || (t = w.poll()) == null) continue;
                return t;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null) continue;
                while ((t = w.poll()) != null) {
                    c.add(t);
                    ++count;
                }
            }
        }
        return count;
    }

    public String toString() {
        int rs;
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        AtomicLong sc = this.stealCounter;
        long st = sc == null ? 0L : sc.get();
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)w.nsteals;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = this.config & 0xFFFF;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = ((rs = this.runState) & 0x40000000) != 0 ? "Terminated" : ((rs & 0x20000000) != 0 ? "Terminating" : ((rs & Integer.MIN_VALUE) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.runState & 0x40000000) != 0;
    }

    public boolean isTerminating() {
        int rs = this.runState;
        return (rs & 0x20000000) != 0 && (rs & 0x40000000) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.runState & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        if (nanos <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanos;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
                this.wait(millis > 0L ? millis : 1L);
                nanos = deadline - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        long nanos = unit.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)thread;
            if (wt.pool == this) {
                this.helpQuiescePool(wt.workQueue);
                return true;
            }
        }
        long startTime = System.nanoTime();
        int r = 0;
        boolean found = true;
        block0: while (!this.isQuiescent()) {
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (m = ws.length - 1) <= 0) break;
            if (!found) {
                if (System.nanoTime() - startTime > nanos) {
                    return false;
                }
                Thread.yield();
            }
            found = false;
            for (int j = m + 1 << 2; j >= 0; --j) {
                int b;
                WorkQueue q;
                int k;
                if ((k = r++ & m) > m || k < 0 || (q = ws[k]) == null || (b = q.base) - q.top >= 0) continue;
                found = true;
                ForkJoinTask<?> t = q.pollAt(b);
                if (t == null) continue block0;
                t.doExec();
                continue block0;
            }
        }
        return true;
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool p = wt.pool;
            if (p != null) {
                WorkQueue w = wt.workQueue;
                while (!blocker.isReleasable()) {
                    if (!p.tryCompensate(w)) continue;
                    try {
                        while (!blocker.isReleasable() && !blocker.block()) {
                        }
                        return;
                    }
                    finally {
                        U.getAndAddLong(p, CTL, 0x1000000000000L);
                    }
                }
                return;
            }
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static ForkJoinPool makeCommonPool() {
        int parallelism = -1;
        ForkJoinWorkerThreadFactory factory = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String fp = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            String hp = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            String mp = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
            if (fp != null) {
                factory = (ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(fp).newInstance();
            }
            if (hp != null) {
                handler = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(hp).newInstance();
            }
            if (mp != null) {
                commonMaxSpares = Integer.parseInt(mp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (factory == null) {
            factory = System.getSecurityManager() == null ? defaultForkJoinWorkerThreadFactory : new InnocuousForkJoinWorkerThreadFactory();
        }
        if (parallelism < 0 && (parallelism = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            parallelism = 1;
        }
        if (parallelism > Short.MAX_VALUE) {
            parallelism = Short.MAX_VALUE;
        }
        return new ForkJoinPool(parallelism, factory, handler, 0, "ForkJoinPool.commonPool-worker-");
    }

    static {
        try {
            U = JSR166Helper.Unsafe.getUnsafe();
            Class<ForkJoinPool> k = ForkJoinPool.class;
            CTL = U.objectFieldOffset(k.getDeclaredField("ctl"));
            RUNSTATE = U.objectFieldOffset(k.getDeclaredField("runState"));
            STEALCOUNTER = U.objectFieldOffset(k.getDeclaredField("stealCounter"));
            Class<Thread> tk = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            Class<WorkQueue> wk = WorkQueue.class;
            QTOP = U.objectFieldOffset(wk.getDeclaredField("top"));
            QLOCK = U.objectFieldOffset(wk.getDeclaredField("qlock"));
            QSCANSTATE = U.objectFieldOffset(wk.getDeclaredField("scanState"));
            QPARKER = U.objectFieldOffset(wk.getDeclaredField("parker"));
            QCURRENTSTEAL = U.objectFieldOffset(wk.getDeclaredField("currentSteal"));
            QCURRENTJOIN = U.objectFieldOffset(wk.getDeclaredField("currentJoin"));
            Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        commonMaxSpares = 256;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return ForkJoinPool.makeCommonPool();
            }
        });
        int par = ForkJoinPool.common.config & 0xFFFF;
        commonParallelism = par > 0 ? par : 1;
    }

    static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext innocuousAcc;

        InnocuousForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return (ForkJoinWorkerThread.InnocuousForkJoinWorkerThread)AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, innocuousAcc);
        }

        static {
            Permissions innocuousPerms = new Permissions();
            innocuousPerms.add(modifyThreadPermission);
            innocuousPerms.add(new RuntimePermission("enableContextClassLoaderOverride"));
            innocuousPerms.add(new RuntimePermission("modifyThreadGroup"));
            innocuousAcc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, innocuousPerms)});
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile int scanState;
        int stackPred;
        int nsteals;
        int hint;
        int config;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        volatile ForkJoinTask<?> currentSteal;
        private static final JSR166Helper.Unsafe U;
        private static final int ABASE;
        private static final int ASHIFT;
        private static final long QTOP;
        private static final long QLOCK;
        private static final long QCURRENTSTEAL;

        static final ForkJoinTask<?> getAt(ForkJoinTask<?>[] a, int i) {
            return (ForkJoinTask)U.getObjectVolatile(a, (i << ASHIFT) + ABASE);
        }

        static final void setAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> x) {
            U.putOrderedObject(a, (i << ASHIFT) + ABASE, x);
        }

        static final boolean casAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> c, ForkJoinTask<?> v) {
            return U.compareAndSwapObject(a, (i << ASHIFT) + ABASE, c, v);
        }

        static final ForkJoinTask<?> xchgAt(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> x) {
            return (ForkJoinTask)U.getAndSetObject(a, (i << ASHIFT) + ABASE, x);
        }

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner) {
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int getPoolIndex() {
            return (this.config & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int s = this.top;
            int n = this.base - s;
            if (n >= 0) return true;
            if (n != -1) return false;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return true;
            int al = a.length;
            if (al == 0) return true;
            if (WorkQueue.getAt(a, al - 1 & s - 1) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null) {
                int b = this.base;
                int m = a.length - 1;
                int s = this.top;
                if (m > 0) {
                    WorkQueue.setAt(a, m & s, task);
                    U.putOrderedInt(this, QTOP, s + 1);
                    int n = s - b;
                    if (n <= 1) {
                        ForkJoinPool p = this.pool;
                        if (p != null) {
                            p.signalWork(p.workQueues, this);
                        }
                    } else if (n >= m) {
                        this.growArray();
                    }
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int b;
            int t;
            int oldMask;
            int size;
            ForkJoinTask<?>[] oldA = this.array;
            int n = size = oldA != null ? oldA.length << 1 : 8192;
            if (size < 8192 || size > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[size];
            ForkJoinTask[] a = this.array;
            if (oldA != null && (oldMask = oldA.length - 1) > 0 && (t = this.top) - (b = this.base) > 0) {
                int mask = size - 1;
                do {
                    int oldj = b & oldMask;
                    int j = b & mask;
                    ForkJoinTask<?> x = WorkQueue.getAt(oldA, oldj);
                    if (x == null || !WorkQueue.casAt(oldA, oldj, x, null)) continue;
                    WorkQueue.setAt(a, j, x);
                } while (++b != t);
            }
            return a;
        }

        final ForkJoinTask<?> pop() {
            int al;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0) {
                int j;
                ForkJoinTask<?> t;
                int s;
                while ((s = this.top - 1) - this.base >= 0 && (t = WorkQueue.getAt(a, j = al - 1 & s)) != null) {
                    if (!WorkQueue.casAt(a, j, t, null)) continue;
                    U.putOrderedInt(this, QTOP, s);
                    return t;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int b) {
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null) {
                ForkJoinTask<?> t;
                int al = a.length;
                int j = al - 1 & b;
                if (al > 0 && (t = WorkQueue.getAt(a, j)) != null && this.base == b && WorkQueue.casAt(a, j, t, null)) {
                    this.base = b + 1;
                    return t;
                }
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int b;
            while ((b = this.base) - this.top < 0) {
                int al;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (al = a.length) <= 0) break;
                int j = al - 1 & b;
                ForkJoinTask<?> t = WorkQueue.getAt(a, j);
                if (this.base != b) continue;
                if (t != null) {
                    if (!WorkQueue.casAt(a, j, t, null)) continue;
                    this.base = b + 1;
                    return t;
                }
                if (b + 1 != this.top) continue;
                break;
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return (this.config & 0x10000) == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int al;
            ForkJoinTask<?>[] a = this.array;
            if (a != null && (al = a.length) > 0) {
                int i = (this.config & 0x10000) == 0 ? this.top - 1 : this.base;
                return WorkQueue.getAt(a, al - 1 & i);
            }
            return null;
        }

        final boolean tryUnpush(ForkJoinTask<?> t) {
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null) {
                int b = this.base;
                int al = a.length;
                int s = this.top;
                if (s != b && al > 0 && WorkQueue.casAt(a, al - 1 & s - 1, t, null)) {
                    U.putOrderedInt(this, QTOP, s - 1);
                    return true;
                }
            }
            return false;
        }

        final void cancelAll() {
            ForkJoinTask<?> t = this.currentJoin;
            if (t != null) {
                this.currentJoin = null;
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
            if ((t = this.currentSteal) != null) {
                this.currentSteal = null;
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
            while ((t = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }

        final void pollAndExecAll() {
            ForkJoinTask<?> t;
            while ((t = this.poll()) != null) {
                t.doExec();
            }
        }

        final void popAndExecAll() {
            while (true) {
                ForkJoinTask<?> t;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null) break;
                int b = this.base;
                int al = a.length;
                int s = this.top;
                int i = al - 1 & s - 1;
                if (b == s || al <= 0 || (t = WorkQueue.xchgAt(a, i, null)) == null) break;
                U.putOrderedInt(this, QTOP, s - 1);
                t.doExec();
            }
        }

        final void runTask(ForkJoinTask<?> task) {
            if (task != null) {
                this.scanState &= 0xFFFFFFFE;
                this.currentSteal = task;
                this.currentSteal.doExec();
                U.putOrderedObject(this, QCURRENTSTEAL, null);
                if ((this.config & 0x10000) != 0) {
                    this.pollAndExecAll();
                } else {
                    this.popAndExecAll();
                }
                ForkJoinWorkerThread thread = this.owner;
                if (++this.nsteals < 0) {
                    this.transferStealCount(this.pool);
                }
                this.scanState |= 1;
                if (thread != null) {
                    thread.afterTopLevelExec();
                }
            }
        }

        final void transferStealCount(ForkJoinPool p) {
            AtomicLong sc;
            if (p != null && (sc = p.stealCounter) != null) {
                int s = this.nsteals;
                this.nsteals = 0;
                sc.getAndAdd(s < 0 ? Integer.MAX_VALUE : s);
            }
        }

        final boolean tryRemoveAndExec(ForkJoinTask<?> task) {
            int al;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0 && task != null) {
                int b;
                int s;
                int n;
                while ((n = (s = this.top) - (b = this.base)) > 0) {
                    block12: {
                        do {
                            int j;
                            ForkJoinTask<?> t;
                            if ((t = WorkQueue.getAt(a, j = --s & al - 1)) == null) {
                                return s + 1 == this.top;
                            }
                            if (t == task) {
                                boolean removed = false;
                                if (s + 1 == this.top) {
                                    if (WorkQueue.casAt(a, j, task, null)) {
                                        U.putOrderedInt(this, QTOP, s);
                                        removed = true;
                                    }
                                } else if (this.base == b) {
                                    removed = WorkQueue.casAt(a, j, task, new EmptyTask());
                                }
                                if (removed) {
                                    task.doExec();
                                }
                            } else {
                                if (t.status >= 0 || s + 1 != this.top) continue;
                                if (WorkQueue.casAt(a, j, t, null)) {
                                    U.putOrderedInt(this, QTOP, s);
                                }
                            }
                            break block12;
                        } while (--n != 0);
                        return false;
                    }
                    if (task.status >= 0) continue;
                    return false;
                }
            }
            return true;
        }

        final CountedCompleter<?> popCC(CountedCompleter<?> task, int mode) {
            block5: {
                ForkJoinTask<?> o;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null) break block5;
                int b = this.base;
                int al = a.length;
                int s = this.top;
                int i = al - 1 & s - 1;
                if (b != s && al > 0 && (o = a[i]) instanceof CountedCompleter) {
                    CountedCompleter<?> t;
                    CountedCompleter<?> r = t = (CountedCompleter<?>)o;
                    do {
                        if (r != task) continue;
                        if (mode < 0) {
                            if (!U.compareAndSwapInt(this, QLOCK, 0, 1)) break;
                            if (this.top == s && this.array == a && WorkQueue.casAt(a, i, t, null)) {
                                U.putOrderedInt(this, QTOP, s - 1);
                                U.putOrderedInt(this, QLOCK, 0);
                                return t;
                            }
                            U.compareAndSwapInt(this, QLOCK, 1, 0);
                            break;
                        }
                        if (WorkQueue.casAt(a, i, t, null)) {
                            U.putOrderedInt(this, QTOP, s - 1);
                            return t;
                        }
                        break;
                    } while ((r = r.completer) != null);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final int pollAndExecCC(CountedCompleter<?> task) {
            CountedCompleter<?> t;
            int b = this.base;
            if (b - this.top >= 0) return b | Integer.MIN_VALUE;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return b | Integer.MIN_VALUE;
            int al = a.length;
            if (al <= 0) {
                return b | Integer.MIN_VALUE;
            }
            int j = al - 1 & b;
            ForkJoinTask<?> o = WorkQueue.getAt(a, j);
            if (o == null) {
                return 2;
            }
            if (!(o instanceof CountedCompleter)) {
                return -1;
            }
            CountedCompleter<?> r = t = (CountedCompleter<?>)o;
            do {
                if (r != task) continue;
                if (this.base != b) return 2;
                if (!WorkQueue.casAt(a, j, t, null)) return 2;
                this.base = b + 1;
                t.doExec();
                return 1;
            } while ((r = r.completer) != null);
            return -1;
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt;
            return this.scanState >= 0 && (wt = this.owner) != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                U = JSR166Helper.Unsafe.getUnsafe();
                Class<WorkQueue> wk = WorkQueue.class;
                Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
                QTOP = U.objectFieldOffset(wk.getDeclaredField("top"));
                QLOCK = U.objectFieldOffset(wk.getDeclaredField("qlock"));
                QCURRENTSTEAL = U.objectFieldOffset(wk.getDeclaredField("currentSteal"));
                ABASE = U.arrayBaseOffset(ak);
                int scale = U.arrayIndexScale(ak);
                if ((scale & scale - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = -7721805057305804111L;

        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void x) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

