/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.configuration;

import io.hops.hadoop.shaded.org.mockito.Captor;
import io.hops.hadoop.shaded.org.mockito.Mock;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.MockitoAnnotations;
import io.hops.hadoop.shaded.org.mockito.Spy;
import io.hops.hadoop.shaded.org.mockito.configuration.AnnotationEngine;
import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import io.hops.hadoop.shaded.org.mockito.internal.util.MockUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> context, Object testClass) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class)) continue;
            this.assertNoAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object instance = field.get(testClass);
                if (instance == null) {
                    throw new MockitoException("Cannot create a @Spy for '" + field.getName() + "' field because the *instance* is missing\n" + "The instance must be created *before* initMocks();\n" + "Example of correct usage of @Spy:\n" + "   @Spy List mock = new LinkedList();\n" + "   //also, don't forget about MockitoAnnotations.initMocks();");
                }
                if (new MockUtil().isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                field.set(testClass, Mockito.spy(instance));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), e);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        }
    }

    void assertNoAnnotations(Class annotation, Field field, Class ... undesiredAnnotations) {
        for (Class u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

