/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractContainerAllocator {
    private static final Log LOG = LogFactory.getLog(AbstractContainerAllocator.class);
    FiCaSchedulerApp application;
    AppSchedulingInfo appInfo;
    final ResourceCalculator rc;
    final RMContext rmContext;
    ActivitiesManager activitiesManager;

    public AbstractContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext) {
        this(application, rc, rmContext, null);
    }

    public AbstractContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext, ActivitiesManager activitiesManager) {
        this.application = application;
        this.appInfo = application == null ? null : application.getAppSchedulingInfo();
        this.rc = rc;
        this.rmContext = rmContext;
        this.activitiesManager = activitiesManager;
    }

    protected CSAssignment getCSAssignmentFromAllocateResult(Resource clusterResource, ContainerAllocation result, RMContainer rmContainer, FiCaSchedulerNode node) {
        CSAssignment.SkippedType skipped = result.getAllocationState() == AllocationState.APP_SKIPPED ? CSAssignment.SkippedType.OTHER : CSAssignment.SkippedType.NONE;
        CSAssignment assignment = new CSAssignment(skipped);
        assignment.setApplication(this.application);
        assignment.setExcessReservation(result.getContainerToBeUnreserved());
        assignment.setRequestLocalityType(result.requestLocalityType);
        if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)result.getResourceToBeAllocated(), (Resource)Resources.none())) {
            Resource allocatedResource = result.getResourceToBeAllocated();
            RMContainer updatedContainer = result.getUpdatedContainer();
            assignment.setResource(allocatedResource);
            assignment.setType(result.getContainerNodeType());
            if (result.getAllocationState() == AllocationState.RESERVED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reserved container  application=" + this.application.getApplicationId() + " resource=" + allocatedResource + " queue=" + this.appInfo.getQueueName() + " cluster=" + clusterResource));
                }
                assignment.getAssignmentInformation().addReservationDetails(updatedContainer, this.application.getCSLeafQueue().getQueuePath());
                assignment.getAssignmentInformation().incrReservations();
                Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)allocatedResource);
                if (rmContainer != null) {
                    ActivitiesLogger.APP.recordAppActivityWithAllocation(this.activitiesManager, node, this.application, updatedContainer, ActivityState.RE_RESERVED);
                    ActivitiesLogger.APP.finishSkippedAppAllocationRecording(this.activitiesManager, this.application.getApplicationId(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
                } else {
                    ActivitiesLogger.APP.recordAppActivityWithAllocation(this.activitiesManager, node, this.application, updatedContainer, ActivityState.RESERVED);
                    ActivitiesLogger.APP.finishAllocatedAppAllocationRecording(this.activitiesManager, this.application.getApplicationId(), updatedContainer.getContainerId(), ActivityState.RESERVED, ActivityDiagnosticConstant.EMPTY);
                }
            } else if (result.getAllocationState() == AllocationState.ALLOCATED) {
                LOG.info((Object)("assignedContainer application attempt=" + this.application.getApplicationAttemptId() + " container=" + updatedContainer.getContainerId() + " queue=" + this.appInfo.getQueueName() + " clusterResource=" + clusterResource + " type=" + (Object)((Object)assignment.getType()) + " requestedPartition=" + updatedContainer.getNodeLabelExpression()));
                assignment.getAssignmentInformation().addAllocationDetails(updatedContainer, this.application.getCSLeafQueue().getQueuePath());
                assignment.getAssignmentInformation().incrAllocations();
                Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)allocatedResource);
                if (rmContainer != null) {
                    assignment.setFulfilledReservation(true);
                    assignment.setFulfilledReservedContainer(rmContainer);
                }
                ActivitiesLogger.APP.recordAppActivityWithAllocation(this.activitiesManager, node, this.application, updatedContainer, ActivityState.ALLOCATED);
                ActivitiesLogger.APP.finishAllocatedAppAllocationRecording(this.activitiesManager, this.application.getApplicationId(), updatedContainer.getContainerId(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                this.application.incUnconfirmedRes(allocatedResource);
            }
            assignment.setContainersToKill(result.getToKillContainers());
        } else if (result.getAllocationState() == AllocationState.QUEUE_SKIPPED) {
            assignment.setSkippedType(CSAssignment.SkippedType.QUEUE_LIMIT);
        }
        return assignment;
    }

    public abstract CSAssignment assignContainers(Resource var1, CandidateNodeSet<FiCaSchedulerNode> var2, SchedulingMode var3, ResourceLimits var4, RMContainer var5);
}

