/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind;

import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.executor.ExecutorUtil;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.AbstractWriteBehind;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations.SingleOperation;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBatchingLocalHeapWriteBehindQueue<K, V>
extends AbstractWriteBehind<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBatchingLocalHeapWriteBehindQueue.class);
    private final CacheLoaderWriter<K, V> cacheLoaderWriter;
    private final ConcurrentMap<K, SingleOperation<K, V>> latest = new ConcurrentHashMap<K, SingleOperation<K, V>>();
    private final BlockingQueue<Runnable> executorQueue;
    private final ExecutorService executor;

    public NonBatchingLocalHeapWriteBehindQueue(ExecutionService executionService, String defaultThreadPool, WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        super(cacheLoaderWriter);
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.executorQueue = new LinkedBlockingQueue<Runnable>(config.getMaxQueueSize());
        this.executor = config.getThreadPoolAlias() == null ? executionService.getOrderedExecutor(defaultThreadPool, this.executorQueue) : executionService.getOrderedExecutor(config.getThreadPoolAlias(), this.executorQueue);
    }

    @Override
    protected SingleOperation<K, V> getOperation(K key) {
        return (SingleOperation)this.latest.get(key);
    }

    @Override
    protected void addOperation(final SingleOperation<K, V> operation) {
        this.latest.put(operation.getKey(), operation);
        this.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    operation.performOperation(NonBatchingLocalHeapWriteBehindQueue.this.cacheLoaderWriter);
                }
                catch (Exception e) {
                    LOGGER.warn("Exception while processing key '{}' write behind queue : {}", operation.getKey(), (Object)e);
                }
                finally {
                    NonBatchingLocalHeapWriteBehindQueue.this.latest.remove(operation.getKey(), operation);
                }
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ExecutorUtil.shutdown(this.executor);
    }

    private void submit(Runnable operation) {
        this.executor.submit(operation);
    }

    @Override
    public long getQueueSize() {
        return this.executorQueue.size();
    }
}

