/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.test.framework.spi.container.grizzly2.web;

import io.hops.hadoop.shaded.com.sun.jersey.api.client.Client;
import io.hops.hadoop.shaded.com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import io.hops.hadoop.shaded.com.sun.jersey.test.framework.AppDescriptor;
import io.hops.hadoop.shaded.com.sun.jersey.test.framework.WebAppDescriptor;
import io.hops.hadoop.shaded.com.sun.jersey.test.framework.spi.container.TestContainer;
import io.hops.hadoop.shaded.com.sun.jersey.test.framework.spi.container.TestContainerException;
import io.hops.hadoop.shaded.com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import io.hops.hadoop.shaded.javax.servlet.DispatcherType;
import io.hops.hadoop.shaded.javax.servlet.Servlet;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServlet;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.ws.rs.core.UriBuilder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpServer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterRegistration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletRegistration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.WebappContext;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class GrizzlyWebTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new GrizzlyWebTestContainer(baseUri, (WebAppDescriptor)ad);
    }

    private static class GrizzlyWebTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyWebTestContainer.class.getName());
        final URI baseUri;
        final String contextPath;
        final String servletPath;
        final Class<? extends Servlet> servletClass;
        List<WebAppDescriptor.FilterDescriptor> filters = null;
        final List<Class<? extends EventListener>> eventListeners;
        final Map<String, String> initParams;
        final Map<String, String> contextParams;
        private HttpServer httpServer;

        private GrizzlyWebTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
            LOGGER.info("Creating Grizzly2 Web Container configured at the base URI " + this.baseUri);
            this.contextPath = ad.getContextPath();
            this.servletPath = ad.getServletPath();
            this.servletClass = ad.getServletClass();
            this.filters = ad.getFilters();
            this.initParams = ad.getInitParams();
            this.contextParams = ad.getContextParams();
            this.eventListeners = ad.getListeners();
            this.instantiateGrizzlyWebServer();
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.info("Starting the Grizzly2 Web Container...");
            try {
                this.httpServer.start();
            }
            catch (IOException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        public void stop() {
            LOGGER.info("Stopping the Grizzly2 Web Container...");
            this.httpServer.stop();
        }

        private void instantiateGrizzlyWebServer() {
            ServletRegistration registration;
            String servletPathLocal;
            String contextPathLocal = this.contextPath != null && this.contextPath.length() > 0 ? (!this.contextPath.startsWith("/") ? "/" + this.contextPath : this.contextPath) : "";
            servletPathLocal = this.servletPath != null && this.servletPath.length() > 0 ? ((servletPathLocal = !this.servletPath.startsWith("/") ? "/" + this.servletPath : this.servletPath).endsWith("/") ? servletPathLocal + "*" : servletPathLocal + "/*") : "/*";
            WebappContext context = new WebappContext("TestContext", contextPathLocal);
            if (this.servletClass != null) {
                registration = context.addServlet(this.servletClass.getName(), this.servletClass);
                for (String initParamName : this.initParams.keySet()) {
                    registration.setInitParameter(initParamName, this.initParams.get(initParamName));
                }
                registration.addMapping(servletPathLocal);
            } else {
                registration = context.addServlet("default", (Servlet)new HttpServlet(){

                    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                        resp.setStatus(404);
                    }
                });
                registration.addMapping("");
            }
            for (Class<? extends EventListener> eventListener : this.eventListeners) {
                context.addListener(eventListener);
            }
            for (String contextParamName : this.contextParams.keySet()) {
                context.addContextInitParameter(contextParamName, this.contextParams.get(contextParamName));
            }
            if (this.filters != null) {
                for (WebAppDescriptor.FilterDescriptor filterDescriptor : this.filters) {
                    FilterRegistration filterRegistration = context.addFilter(filterDescriptor.getFilterName(), filterDescriptor.getFilterClass());
                    filterRegistration.setInitParameters(filterDescriptor.getInitParams());
                    filterRegistration.addMappingForUrlPatterns(this.grizzlyDispatcherTypes(filterDescriptor.getDispatcherTypes()), servletPathLocal);
                }
            }
            try {
                this.httpServer = GrizzlyServerFactory.createHttpServer(this.baseUri, (HttpHandler)null);
                context.deploy(this.httpServer);
            }
            catch (IOException ioe) {
                throw new TestContainerException((Throwable)ioe);
            }
        }

        private EnumSet<io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DispatcherType> grizzlyDispatcherTypes(Set<DispatcherType> dispatcherTypes) {
            HashSet<io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DispatcherType> grizzlyDispatcherTypes = new HashSet<io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DispatcherType>();
            for (DispatcherType servletDispatchType : dispatcherTypes) {
                grizzlyDispatcherTypes.add(io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DispatcherType.valueOf(servletDispatchType.name()));
            }
            return EnumSet.copyOf(grizzlyDispatcherTypes);
        }
    }
}

