/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.util.ajax;

import io.hops.hadoop.shaded.org.eclipse.jetty.util.Loader;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.ajax.JSON;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.lang.reflect.Method;
import java.util.Map;

public class JSONEnumConvertor
implements JSON.Convertor {
    private static final Logger LOG = Log.getLogger(JSONEnumConvertor.class);
    private boolean _fromJSON;
    private Method _valueOf;

    public JSONEnumConvertor() {
        this(false);
    }

    public JSONEnumConvertor(boolean fromJSON) {
        try {
            Class e = Loader.loadClass(this.getClass(), (String)"java.lang.Enum");
            this._valueOf = e.getMethod("valueOf", Class.class, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("!Enums", e);
        }
        this._fromJSON = fromJSON;
    }

    @Override
    public Object fromJSON(Map map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        try {
            Class c = Loader.loadClass(this.getClass(), (String)((String)map.get("class")));
            return this._valueOf.invoke(null, c, map.get("value"));
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(obj.getClass());
            out.add("value", ((Enum)obj).name());
        } else {
            out.add(((Enum)obj).name());
        }
    }
}

