/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.statistics;

import io.hops.hadoop.shaded.org.ehcache.Cache;
import io.hops.hadoop.shaded.org.ehcache.Status;
import io.hops.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import io.hops.hadoop.shaded.org.ehcache.core.InternalCache;
import io.hops.hadoop.shaded.org.ehcache.core.events.CacheManagerListener;
import io.hops.hadoop.shaded.org.ehcache.core.spi.service.CacheManagerProviderService;
import io.hops.hadoop.shaded.org.ehcache.core.spi.service.StatisticsService;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.InternalCacheManager;
import io.hops.hadoop.shaded.org.ehcache.core.statistics.CacheStatistics;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.statistics.DefaultCacheStatistics;
import io.hops.hadoop.shaded.org.ehcache.spi.service.Service;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={CacheManagerProviderService.class})
public class DefaultStatisticsService
implements StatisticsService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final ConcurrentMap<String, CacheStatistics> cacheStatistics = new ConcurrentHashMap<String, CacheStatistics>();
    private volatile InternalCacheManager cacheManager;
    private volatile boolean started = false;

    @Override
    public CacheStatistics getCacheStatistics(String cacheName) {
        CacheStatistics stats = (CacheStatistics)this.cacheStatistics.get(cacheName);
        if (stats == null) {
            throw new IllegalArgumentException("Unknown cache: " + cacheName);
        }
        return stats;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        LOGGER.debug("Starting service");
        CacheManagerProviderService cacheManagerProviderService = serviceProvider.getService(CacheManagerProviderService.class);
        this.cacheManager = cacheManagerProviderService.getCacheManager();
        this.cacheManager.registerListener(this);
        this.started = true;
    }

    @Override
    public void stop() {
        LOGGER.debug("Stopping service");
        this.cacheManager.deregisterListener(this);
        this.cacheStatistics.clear();
        this.started = false;
    }

    @Override
    public void stateTransition(Status from, Status to) {
        LOGGER.debug("Moving from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        switch (to) {
            case AVAILABLE: {
                this.registerAllCaches();
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener(this);
                this.cacheStatistics.clear();
                break;
            }
            case MAINTENANCE: {
                throw new IllegalStateException("Should not be started in maintenance mode");
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + (Object)((Object)to)));
            }
        }
    }

    private void registerAllCaches() {
        for (Map.Entry<String, CacheConfiguration<?, ?>> entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String alias = entry.getKey();
            CacheConfiguration<?, ?> configuration = entry.getValue();
            Cache<?, ?> cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
            this.cacheAdded(alias, cache);
        }
    }

    @Override
    public void cacheAdded(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache added " + alias);
        this.cacheStatistics.put(alias, new DefaultCacheStatistics((InternalCache)cache));
    }

    @Override
    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache removed " + alias);
        this.cacheStatistics.remove(alias);
    }
}

