/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AbstractPreemptionEntity {
    final String queueName;
    protected final Resource current;
    protected final Resource amUsed;
    protected final Resource reserved;
    protected Resource pending;
    Resource idealAssigned;
    Resource toBePreempted;
    Resource selected;
    private Resource actuallyToBePreempted;
    private Resource toBePreemptFromOther;

    AbstractPreemptionEntity(String queueName, Resource usedPerPartition, Resource amUsedPerPartition, Resource reserved, Resource pendingPerPartition) {
        this.queueName = queueName;
        this.current = usedPerPartition;
        this.pending = pendingPerPartition;
        this.reserved = reserved;
        this.amUsed = amUsedPerPartition;
        this.idealAssigned = Resource.newInstance((int)0, (int)0);
        this.actuallyToBePreempted = Resource.newInstance((int)0, (int)0);
        this.toBePreempted = Resource.newInstance((int)0, (int)0);
        this.toBePreemptFromOther = Resource.newInstance((int)0, (int)0);
        this.selected = Resource.newInstance((int)0, (int)0);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Resource getUsed() {
        return this.current;
    }

    public Resource getUsedDeductAM() {
        return Resources.subtract((Resource)this.current, (Resource)this.amUsed);
    }

    public Resource getAMUsed() {
        return this.amUsed;
    }

    public Resource getPending() {
        return this.pending;
    }

    public Resource getReserved() {
        return this.reserved;
    }

    public Resource getActuallyToBePreempted() {
        return this.actuallyToBePreempted;
    }

    public void setActuallyToBePreempted(Resource actuallyToBePreempted) {
        this.actuallyToBePreempted = actuallyToBePreempted;
    }

    public Resource getToBePreemptFromOther() {
        return this.toBePreemptFromOther;
    }

    public void setToBePreemptFromOther(Resource toBePreemptFromOther) {
        this.toBePreemptFromOther = toBePreemptFromOther;
    }
}

