/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common.security;

import io.hops.common.security.FsSecurityActions;
import io.hops.hadoop.shaded.org.apache.http.HttpEntity;
import io.hops.hadoop.shaded.org.apache.http.HttpRequest;
import io.hops.hadoop.shaded.org.apache.http.HttpResponse;
import io.hops.hadoop.shaded.org.apache.http.client.ClientProtocolException;
import io.hops.hadoop.shaded.org.apache.http.client.ResponseHandler;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpGet;
import io.hops.hadoop.shaded.org.apache.http.client.utils.URIBuilder;
import io.hops.hadoop.shaded.org.apache.http.util.EntityUtils;
import io.hops.security.AbstractSecurityActions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;

public class HopsworksFsSecurityActions
extends AbstractSecurityActions
implements FsSecurityActions {
    private boolean configured = false;

    public HopsworksFsSecurityActions() {
        super("HopsworksFsSecurityActions");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (conf.getBoolean("ipc.server.ssl.enabled", false)) {
            super.serviceInit(conf);
        }
    }

    protected void serviceStart() throws Exception {
        if (this.getConfig().getBoolean("ipc.server.ssl.enabled", false)) {
            super.serviceStart();
            this.configured = true;
        }
    }

    protected void serviceStop() throws Exception {
        if (this.getConfig().getBoolean("ipc.server.ssl.enabled", false)) {
            super.serviceStop();
        }
    }

    @Override
    public X509CredentialsDTO getX509Credentials(String username) throws URISyntaxException, GeneralSecurityException, IOException {
        if (!this.configured) {
            this.notConfigured("getX509Credentials");
        }
        URI requestURI = new URIBuilder(this.getConfig().get("dfs.security-actions.x509.get-path", "/hopsworks-api/api/admin/credentials/x509")).addParameter("username", username).build();
        HttpGet request = new HttpGet(requestURI);
        this.addJWTAuthHeader((HttpRequest)request, this.serviceJWTManager.getMasterToken());
        try {
            return (X509CredentialsDTO)this.httpClient.execute(this.remoteHost, (HttpRequest)request, (ResponseHandler)new GetX509CredentialsHandler(username));
        }
        catch (ClientProtocolException ex) {
            throw new IOException(ex);
        }
    }

    private void notConfigured(String methodName) throws GeneralSecurityException {
        throw new GeneralSecurityException("Called method " + methodName + " of " + HopsworksFsSecurityActions.class.getSimpleName() + " but it is not configured yet");
    }

    public static class X509CredentialsDTO {
        private String fileExtension;
        private String kStore;
        private String tStore;
        private String password;

        public String getFileExtension() {
            return this.fileExtension;
        }

        public void setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public String getkStore() {
            return this.kStore;
        }

        public void setkStore(String kStore) {
            this.kStore = kStore;
        }

        public String gettStore() {
            return this.tStore;
        }

        public void settStore(String tStore) {
            this.tStore = tStore;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    private class GetX509CredentialsHandler
    implements ResponseHandler<X509CredentialsDTO> {
        private final String username;

        private GetX509CredentialsHandler(String username) {
            this.username = username;
        }

        public X509CredentialsDTO handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                return (X509CredentialsDTO)HopsworksFsSecurityActions.this.parser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), X509CredentialsDTO.class);
            }
            throw new ClientProtocolException("Failed to get X.509 for " + this.username + " Status: " + status + " Reason: " + response.getStatusLine().getReasonPhrase());
        }
    }
}

