/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.cedarsoftware.util.io;

import io.hops.hadoop.shaded.com.cedarsoftware.util.io.JsonReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonObject<K, V>
extends LinkedHashMap<K, V> {
    Object target;
    boolean isMap = false;
    String type;
    long id = -1L;
    int line;
    int col;

    public long getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != -1L;
    }

    public void setType(String type) {
        this.type = type != null ? type.intern() : null;
    }

    public String getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public boolean isPrimitive() {
        return "int".equals(this.type) || "long".equals(this.type) || "boolean".equals(this.type) || "double".equals(this.type) || "byte".equals(this.type) || "short".equals(this.type) || "float".equals(this.type) || "char".equals(this.type);
    }

    public static boolean isPrimitiveWrapper(Class c) {
        return Integer.class.equals((Object)c) || Long.class.equals((Object)c) || Boolean.class.equals((Object)c) || Double.class.equals((Object)c) || Byte.class.equals((Object)c) || Short.class.equals((Object)c) || Float.class.equals((Object)c) || Character.class.equals((Object)c);
    }

    public Object getPrimitiveValue() throws IOException {
        if ("int".equals(this.type)) {
            Number integer = (Number)this.get("value");
            return integer.intValue();
        }
        if ("long".equals(this.type) || "boolean".equals(this.type) || "double".equals(this.type)) {
            return this.get("value");
        }
        if ("byte".equals(this.type)) {
            Number b = (Number)this.get("value");
            return b.byteValue();
        }
        if ("float".equals(this.type)) {
            Number f = (Number)this.get("value");
            return Float.valueOf(f.floatValue());
        }
        if ("short".equals(this.type)) {
            Number s = (Number)this.get("value");
            return s.shortValue();
        }
        if ("char".equals(this.type)) {
            String s = (String)this.get("value");
            return Character.valueOf(s.charAt(0));
        }
        return JsonReader.error("Invalid primitive type");
    }

    public boolean isMap() {
        if (this.isMap || this.target instanceof Map) {
            return true;
        }
        if (this.type == null) {
            return false;
        }
        try {
            Class c = JsonReader.classForName2(this.type);
            if (Map.class.isAssignableFrom(c)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isCollection() {
        if (this.containsKey("@items") && !this.containsKey("@keys")) {
            return this.target instanceof Collection || this.type != null && !this.type.contains("[");
        }
        if (this.type == null) {
            return false;
        }
        try {
            Class c = JsonReader.classForName2(this.type);
            if (Collection.class.isAssignableFrom(c)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.type.contains("[");
            }
            return this.containsKey("@items") && !this.containsKey("@keys");
        }
        return this.target.getClass().isArray();
    }

    public Object[] getArray() {
        return (Object[])this.get("@items");
    }

    public int getLength() throws IOException {
        if (this.isArray()) {
            if (this.target == null) {
                Object[] items = (Object[])this.get("@items");
                return items.length;
            }
            return Array.getLength(this.target);
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = (Object[])this.get("@items");
            return items == null ? 0 : items.length;
        }
        throw new IllegalStateException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    public Class getComponentType() {
        return this.target.getClass().getComponentType();
    }

    void moveBytesToMate() {
        byte[] bytes = (byte[])this.target;
        Object[] items = this.getArray();
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            bytes[i] = ((Number)items[i]).byteValue();
        }
    }

    void moveCharsToMate() {
        Object[] items = this.getArray();
        if (items == null) {
            this.target = null;
        } else if (items.length == 0) {
            this.target = new char[0];
        } else if (items.length == 1) {
            String s = (String)items[0];
            this.target = s.toCharArray();
        } else {
            throw new IllegalStateException("char[] should only have one String in the [], found " + items.length + ", line " + this.line + ", col " + this.col);
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return super.put(key, value);
        }
        if (key.equals("@type")) {
            String oldType = this.type;
            this.type = (String)value;
            return (V)oldType;
        }
        if (key.equals("@id")) {
            Long oldId = this.id;
            this.id = (Long)value;
            return (V)oldId;
        }
        if ("@items".equals(key) && this.containsKey("@keys") || "@keys".equals(key) && this.containsKey("@items")) {
            this.isMap = true;
        }
        return super.put(key, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.type = null;
    }

    void clearArray() {
        this.remove("@items");
    }

    @Deprecated
    public long getPos() {
        return this.line;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    @Override
    public int size() {
        if (this.containsKey("@keys")) {
            Object value = this.get("@keys");
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
            if (value == null) {
                return 0;
            }
            throw new IllegalStateException("JsonObject with @keys, but no array [] associated to it, line " + this.line + ", col " + this.col);
        }
        if (this.containsKey("@items")) {
            Object value = this.get("@items");
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
            if (value == null) {
                return 0;
            }
            throw new IllegalStateException("JsonObject with @items, but no array [] associated to it, line " + this.line + ", col " + this.col);
        }
        if (this.containsKey("@ref")) {
            return 0;
        }
        return super.size();
    }
}

