/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.ISQLServerResultSet42;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.JDBCType;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerStatement;
import java.sql.SQLType;
import java.util.logging.Level;

public class SQLServerResultSet42
extends SQLServerResultSet
implements ISQLServerResultSet42 {
    public SQLServerResultSet42(SQLServerStatement stmtIn) throws SQLServerException {
        super(stmtIn);
    }

    @Override
    public void updateObject(int index, Object obj, SQLType targetSqlType) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{index, obj, targetSqlType});
        }
        this.checkClosed();
        this.updateObject(index, obj, null, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, false);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(int index, Object obj, SQLType targetSqlType, int scale) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{index, obj, targetSqlType, scale});
        }
        this.checkClosed();
        this.updateObject(index, obj, scale, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, false);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(int index, Object obj, SQLType targetSqlType, int scale, boolean forceEncrypt) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{index, obj, targetSqlType, scale, forceEncrypt});
        }
        this.checkClosed();
        this.updateObject(index, obj, scale, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(String columnName, Object obj, SQLType targetSqlType, int scale) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{columnName, obj, targetSqlType, scale});
        }
        this.checkClosed();
        this.updateObject(this.findColumn(columnName), obj, scale, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, false);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(String columnName, Object obj, SQLType targetSqlType, int scale, boolean forceEncrypt) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{columnName, obj, targetSqlType, scale, forceEncrypt});
        }
        this.checkClosed();
        this.updateObject(this.findColumn(columnName), obj, scale, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(String columnName, Object obj, SQLType targetSqlType) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{columnName, obj, targetSqlType});
        }
        this.checkClosed();
        this.updateObject(this.findColumn(columnName), obj, null, JDBCType.of(targetSqlType.getVendorTypeNumber()), null, false);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }
}

