/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter;

import io.hops.hadoop.shaded.com.sun.jersey.api.ParamException;
import io.hops.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import io.hops.hadoop.shaded.com.sun.jersey.api.core.HttpRequestContext;
import io.hops.hadoop.shaded.com.sun.jersey.api.model.Parameter;
import io.hops.hadoop.shaded.com.sun.jersey.api.representation.Form;
import io.hops.hadoop.shaded.com.sun.jersey.core.header.MediaTypes;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentContext;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.BaseParamInjectableProvider;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.Injectable;
import io.hops.hadoop.shaded.javax.ws.rs.FormParam;
import io.hops.hadoop.shaded.javax.ws.rs.core.MediaType;
import io.hops.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;

public final class FormParamInjectableProvider
extends BaseParamInjectableProvider<FormParam> {
    public FormParamInjectableProvider(MultivaluedParameterExtractorProvider w) {
        super(w);
    }

    public Injectable getInjectable(ComponentContext ic, FormParam a, Parameter c) {
        String parameterName = c.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor e = this.get(c);
        if (e == null) {
            return null;
        }
        return new FormParamInjectable(e, !c.isEncoded());
    }

    private static final class FormParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MultivaluedParameterExtractor extractor;

        FormParamInjectable(MultivaluedParameterExtractor extractor, boolean decode) {
            this.extractor = extractor;
        }

        @Override
        public Object getValue(HttpContext context) {
            Form form = this.getCachedForm(context);
            if (form == null) {
                form = this.getForm(context);
                this.cacheForm(context, form);
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)form);
            }
            catch (ExtractorContainerException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultStringValue());
            }
        }

        private void cacheForm(HttpContext context, Form form) {
            context.getProperties().put("io.hops.hadoop.shaded.com.sun.jersey.api.representation.form", form);
        }

        private Form getCachedForm(HttpContext context) {
            return (Form)context.getProperties().get("io.hops.hadoop.shaded.com.sun.jersey.api.representation.form");
        }

        private HttpRequestContext ensureValidRequest(HttpRequestContext r) throws IllegalStateException {
            if (r.getMethod().equals("GET")) {
                throw new IllegalStateException("The @FormParam is utilized when the request method is GET");
            }
            if (!MediaTypes.typeEquals((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)r.getMediaType())) {
                throw new IllegalStateException("The @FormParam is utilized when the content type of the request entity is not application/x-www-form-urlencoded");
            }
            return r;
        }

        private Form getForm(HttpContext context) {
            HttpRequestContext r = this.ensureValidRequest(context.getRequest());
            return r.getFormParameters();
        }
    }
}

