/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.daemon.support;

import io.hops.hadoop.shaded.org.apache.commons.daemon.Daemon;
import io.hops.hadoop.shaded.org.apache.commons.daemon.DaemonContext;
import io.hops.hadoop.shaded.org.apache.commons.daemon.support.DaemonConfiguration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class DaemonWrapper
implements Daemon {
    private static final String ARGS = "args";
    private static final String START_CLASS = "start";
    private static final String START_METHOD = "start.method";
    private static final String STOP_CLASS = "stop";
    private static final String STOP_METHOD = "stop.method";
    private static final String STOP_ARGS = "stop.args";
    private String configFileName = null;
    private final DaemonConfiguration config = new DaemonConfiguration();
    private final Invoker startup = new Invoker();
    private final Invoker shutdown = new Invoker();
    static /* synthetic */ Class class$org$apache$commons$daemon$support$DaemonWrapper;

    public void init(DaemonContext context) throws Exception {
        String[] args = context.getArguments();
        if (args != null) {
            int i;
            for (i = 0; i < args.length && !args[i].equals("--"); ++i) {
                if (args[i].equals("-daemon-properties")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException(args[i - 1]);
                    }
                    this.configFileName = args[i];
                    continue;
                }
                if (args[i].equals("-start")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException(args[i - 1]);
                    }
                    this.startup.setClassName(args[i]);
                    continue;
                }
                if (args[i].equals("-start-method")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException(args[i - 1]);
                    }
                    this.startup.setMethodName(args[i]);
                    continue;
                }
                if (args[i].equals("-stop")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException(args[i - 1]);
                    }
                    this.shutdown.setClassName(args[i]);
                    continue;
                }
                if (args[i].equals("-stop-method")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException(args[i - 1]);
                    }
                    this.shutdown.setMethodName(args[i]);
                    continue;
                }
                if (!args[i].equals("-stop-argument")) break;
                if (++i == args.length) {
                    throw new IllegalArgumentException(args[i - 1]);
                }
                String[] aa = new String[]{args[i]};
                this.shutdown.addArguments(aa);
            }
            if (args.length > i) {
                String[] copy = new String[args.length - i];
                System.arraycopy(args, i, copy, 0, copy.length);
                this.startup.addArguments(copy);
            }
        }
        if (this.config.load(this.configFileName)) {
            this.startup.setClassName(this.config.getProperty(START_CLASS));
            this.startup.setMethodName(this.config.getProperty(START_METHOD));
            this.startup.addArguments(this.config.getPropertyArray(ARGS));
            this.shutdown.setClassName(this.config.getProperty(STOP_CLASS));
            this.shutdown.setMethodName(this.config.getProperty(STOP_METHOD));
            this.shutdown.addArguments(this.config.getPropertyArray(STOP_ARGS));
        }
        this.startup.validate();
        this.shutdown.validate();
    }

    public void start() throws Exception {
        this.startup.invoke();
    }

    public void stop() throws Exception {
        this.shutdown.invoke();
    }

    public void destroy() {
        System.err.println("DaemonWrapper: instance " + this.hashCode() + " destroy");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Invoker {
        private String name = null;
        private String call = null;
        private String[] args = null;
        private Method inst = null;
        private Class main = null;

        protected Invoker() {
        }

        protected void setClassName(String name) {
            if (this.name == null) {
                this.name = name;
            }
        }

        protected void setMethodName(String name) {
            if (this.call == null) {
                this.call = name;
            }
        }

        protected void addArguments(String[] args) {
            if (args != null) {
                ArrayList<String> aa = new ArrayList<String>();
                if (this.args != null) {
                    aa.addAll(Arrays.asList(this.args));
                }
                aa.addAll(Arrays.asList(args));
                this.args = aa.toArray(new String[aa.size()]);
            }
        }

        protected void invoke() throws Exception {
            if (this.name.equals("System") && this.call.equals("exit")) {
                System.exit(0);
            } else {
                Object obj = this.main.newInstance();
                Object[] arg = new Object[]{this.args};
                this.inst.invoke(obj, arg);
            }
        }

        protected void validate() throws Exception {
            ClassLoader cl;
            if (this.name == null) {
                this.name = "System";
                this.call = "exit";
                return;
            }
            if (this.args == null) {
                this.args = new String[0];
            }
            if (this.call == null) {
                this.call = "main";
            }
            if ((cl = (class$org$apache$commons$daemon$support$DaemonWrapper == null ? (class$org$apache$commons$daemon$support$DaemonWrapper = DaemonWrapper.class$("io.hops.hadoop.shaded.org.apache.commons.daemon.support.DaemonWrapper")) : class$org$apache$commons$daemon$support$DaemonWrapper).getClassLoader()) == null) {
                throw new NullPointerException("Cannot retrieve ClassLoader instance");
            }
            Class[] ca = new Class[]{this.args.getClass()};
            this.main = cl.loadClass(this.name);
            if (this.main == null) {
                throw new ClassNotFoundException(this.name);
            }
            this.inst = this.main.getMethod(this.call, ca);
        }
    }
}

