/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.PurgeTxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeTxnTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTxnTest.class);
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final long OP_TIMEOUT_IN_MILLIS = 90000L;
    private File tmpDir;

    @After
    public void teardown() {
        if (null != this.tmpDir) {
            ClientBase.recursiveDelete(this.tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurge() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, this);
        try {
            for (int i = 0; i < 2000; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        zks.getTxnLogFactory().close();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        PurgeTxnLog.purge(this.tmpDir, this.tmpDir, 3);
        FileTxnSnapLog snaplog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        List<File> listLogs = snaplog.findNRecentSnapshots(4);
        int numSnaps = 0;
        for (File ff : listLogs) {
            if (!ff.getName().startsWith("snapshot")) continue;
            ++numSnaps;
        }
        Assert.assertTrue((String)"exactly 3 snapshots ", (numSnaps == 3 ? 1 : 0) != 0);
        snaplog.close();
        zks.shutdown();
    }

    @Test
    public void testPurgeWhenLogRollingInProgress() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(30);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, this);
        final CountDownLatch doPurge = new CountDownLatch(1);
        final CountDownLatch purgeFinished = new CountDownLatch(1);
        final AtomicBoolean opFailed = new AtomicBoolean(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    doPurge.await(45000L, TimeUnit.MILLISECONDS);
                    PurgeTxnLog.purge(PurgeTxnTest.this.tmpDir, PurgeTxnTest.this.tmpDir, 3);
                }
                catch (IOException ioe) {
                    LOG.error("Exception when purge", (Throwable)ioe);
                    opFailed.set(true);
                }
                catch (InterruptedException ie) {
                    LOG.error("Exception when purge", (Throwable)ie);
                    opFailed.set(true);
                }
                finally {
                    purgeFinished.countDown();
                }
            }
        }.start();
        int thCount = 3;
        List<String> znodes = this.manyClientOps(zk, doPurge, 3, "/invalidsnap");
        Assert.assertTrue((String)"Purging is not finished!", (boolean)purgeFinished.await(90000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Purging failed!", (boolean)opFailed.get());
        for (String znode : znodes) {
            try {
                zk.getData(znode, false, null);
            }
            catch (Exception ke) {
                LOG.error("Unexpected exception when visiting znode!", (Throwable)ke);
                Assert.fail((String)"Unexpected exception when visiting znode!");
            }
        }
        zk.close();
        f.shutdown();
        zks.shutdown();
        zks.getTxnLogFactory().close();
    }

    @Test
    public void testFindNRecentSnapshots() throws Exception {
        int nRecentSnap = 4;
        int nRecentCount = 30;
        int offset = 0;
        this.tmpDir = ClientBase.createTmpDir();
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assert.assertTrue((String)("Failed to create version_2 dir:" + version2.toString()), (boolean)version2.mkdir());
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        List<File> foundSnaps = txnLog.findNRecentSnapshots(1);
        Assert.assertEquals((long)0L, (long)foundSnaps.size());
        ArrayList<File> expectedNRecentSnapFiles = new ArrayList<File>();
        int counter = offset + 2 * nRecentCount;
        for (int i = 0; i < nRecentCount; ++i) {
            File logFile = new File(version2 + "/log." + Long.toHexString(--counter));
            Assert.assertTrue((String)("Failed to create log File:" + logFile.toString()), (boolean)logFile.createNewFile());
            File snapFile = new File(version2 + "/snapshot." + Long.toHexString(--counter));
            Assert.assertTrue((String)("Failed to create snap File:" + snapFile.toString()), (boolean)snapFile.createNewFile());
            if (i >= nRecentSnap) continue;
            expectedNRecentSnapFiles.add(snapFile);
        }
        List<File> nRecentSnapFiles = txnLog.findNRecentSnapshots(nRecentSnap);
        Assert.assertEquals((String)"exactly 4 snapshots ", (long)4L, (long)nRecentSnapFiles.size());
        expectedNRecentSnapFiles.removeAll(nRecentSnapFiles);
        Assert.assertEquals((String)"Didn't get the recent snap files", (long)0L, (long)expectedNRecentSnapFiles.size());
        nRecentSnapFiles = txnLog.findNRecentSnapshots(nRecentCount + 5);
        Assert.assertEquals((long)nRecentCount, (long)nRecentSnapFiles.size());
        for (File f : nRecentSnapFiles) {
            Assert.assertTrue((String)("findNRecentSnapshots() returned a non-snapshot: " + f.getPath()), (Util.getZxidFromName(f.getName(), "snapshot") != -1L ? 1 : 0) != 0);
        }
        txnLog.close();
    }

    @Test
    public void testSnapFilesGreaterThanToRetain() throws Exception {
        int nRecentCount = 4;
        int fileAboveRecentCount = 4;
        int fileToPurgeCount = 2;
        AtomicInteger offset = new AtomicInteger(0);
        this.tmpDir = ClientBase.createTmpDir();
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assert.assertTrue((String)("Failed to create version_2 dir:" + version2.toString()), (boolean)version2.mkdir());
        ArrayList<File> snapsToPurge = new ArrayList<File>();
        ArrayList<File> logsToPurge = new ArrayList<File>();
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        ArrayList<File> snapsAboveRecentFiles = new ArrayList<File>();
        ArrayList<File> logsAboveRecentFiles = new ArrayList<File>();
        this.createDataDirFiles(offset, fileToPurgeCount, false, version2, snapsToPurge, logsToPurge);
        this.createDataDirFiles(offset, nRecentCount, false, version2, snaps, logs);
        logs.add((File)logsToPurge.remove(0));
        this.createDataDirFiles(offset, fileAboveRecentCount, false, version2, snapsAboveRecentFiles, logsAboveRecentFiles);
        logsToPurge.remove(0);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots(txnLog, (File)snaps.get(snaps.size() - 1));
        txnLog.close();
        this.verifyFilesAfterPurge(snapsToPurge, false);
        this.verifyFilesAfterPurge(logsToPurge, false);
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
        this.verifyFilesAfterPurge(snapsAboveRecentFiles, true);
        this.verifyFilesAfterPurge(logsAboveRecentFiles, true);
    }

    @Test
    public void testSnapFilesEqualsToRetain() throws Exception {
        this.internalTestSnapFilesEqualsToRetain(false);
    }

    @Test
    public void testSnapFilesEqualsToRetainWithPrecedingLog() throws Exception {
        this.internalTestSnapFilesEqualsToRetain(true);
    }

    public void internalTestSnapFilesEqualsToRetain(boolean testWithPrecedingLogFile) throws Exception {
        int nRecentCount = 3;
        AtomicInteger offset = new AtomicInteger(0);
        this.tmpDir = ClientBase.createTmpDir();
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assert.assertTrue((String)("Failed to create version_2 dir:" + version2.toString()), (boolean)version2.mkdir());
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        this.createDataDirFiles(offset, nRecentCount, testWithPrecedingLogFile, version2, snaps, logs);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots(txnLog, (File)snaps.get(snaps.size() - 1));
        txnLog.close();
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
    }

    @Test
    public void testSnapFilesLessThanToRetain() throws Exception {
        int nRecentCount = 4;
        int fileToPurgeCount = 2;
        AtomicInteger offset = new AtomicInteger(0);
        this.tmpDir = ClientBase.createTmpDir();
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assert.assertTrue((String)("Failed to create version_2 dir:" + version2.toString()), (boolean)version2.mkdir());
        ArrayList<File> snapsToPurge = new ArrayList<File>();
        ArrayList<File> logsToPurge = new ArrayList<File>();
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        this.createDataDirFiles(offset, fileToPurgeCount, false, version2, snapsToPurge, logsToPurge);
        this.createDataDirFiles(offset, nRecentCount, false, version2, snaps, logs);
        logs.add((File)logsToPurge.remove(0));
        logsToPurge.remove(0);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots(txnLog, (File)snaps.get(snaps.size() - 1));
        txnLog.close();
        this.verifyFilesAfterPurge(snapsToPurge, false);
        this.verifyFilesAfterPurge(logsToPurge, false);
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
    }

    @Test
    public void testPurgeTxnLogWithDataDir() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        File dataDir = new File(this.tmpDir, "dataDir");
        File dataLogDir = new File(this.tmpDir, "dataLogDir");
        File dataDirVersion2 = new File(dataDir, "version-2");
        dataDirVersion2.mkdirs();
        File dataLogDirVersion2 = new File(dataLogDir, "version-2");
        dataLogDirVersion2.mkdirs();
        int totalFiles = 20;
        for (int i = 0; i < totalFiles; ++i) {
            File logFile = new File(dataLogDirVersion2, "log." + Long.toHexString(i));
            logFile.createNewFile();
            File snapFile = new File(dataDirVersion2, "snapshot." + Long.toHexString(i));
            snapFile.createNewFile();
        }
        int numberOfSnapFilesToKeep = 10;
        String[] args = new String[]{dataLogDir.getAbsolutePath(), dataDir.getAbsolutePath(), "-n", Integer.toString(numberOfSnapFilesToKeep)};
        PurgeTxnLog.main(args);
        Assert.assertEquals((long)numberOfSnapFilesToKeep, (long)dataDirVersion2.listFiles().length);
        Assert.assertEquals((long)numberOfSnapFilesToKeep, (long)dataLogDirVersion2.listFiles().length);
        ClientBase.recursiveDelete(this.tmpDir);
    }

    @Test
    public void testPurgeTxnLogWithoutDataDir() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        File dataDir = new File(this.tmpDir, "dataDir");
        File dataLogDir = new File(this.tmpDir, "dataLogDir");
        File dataDirVersion2 = new File(dataDir, "version-2");
        dataDirVersion2.mkdirs();
        File dataLogDirVersion2 = new File(dataLogDir, "version-2");
        dataLogDirVersion2.mkdirs();
        int totalFiles = 20;
        for (int i = 0; i < totalFiles; ++i) {
            File logFile = new File(dataLogDirVersion2, "log." + Long.toHexString(i));
            logFile.createNewFile();
            File snapFile = new File(dataLogDirVersion2, "snapshot." + Long.toHexString(i));
            snapFile.createNewFile();
        }
        int numberOfSnapFilesToKeep = 10;
        String[] args = new String[]{dataLogDir.getAbsolutePath(), "-n", Integer.toString(numberOfSnapFilesToKeep)};
        PurgeTxnLog.main(args);
        Assert.assertEquals((long)(numberOfSnapFilesToKeep * 2), (long)dataLogDirVersion2.listFiles().length);
        ClientBase.recursiveDelete(this.tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeDoesNotDeleteOverlappingLogFile() throws Exception {
        int SNAP_RETAIN_COUNT = 3;
        int NUM_ZNODES_PER_SNAPSHOT = 100;
        SyncRequestProcessor.setSnapCount(3000);
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        int unique = 0;
        try {
            for (int snapshotCount = 0; snapshotCount < 3; ++snapshotCount) {
                int i = 0;
                while (i < 100) {
                    zk.create("/snap-" + unique, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    ++i;
                    ++unique;
                }
                zks.takeSnapshot();
            }
            int i = 0;
            while (i < 100) {
                zk.create("/snap-" + unique, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                ++i;
                ++unique;
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        zks.getTxnLogFactory().close();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        PurgeTxnLog.purge(this.tmpDir, this.tmpDir, 3);
        zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        zk = ClientBase.createZKClient(HOSTPORT);
        String lastZnode = "/snap-" + (unique - 1);
        Stat stat = zk.exists(lastZnode, false);
        Assert.assertNotNull((String)("Last znode does not exist: " + lastZnode), (Object)stat);
        f.shutdown();
        zks.getTxnLogFactory().close();
        zks.shutdown();
    }

    private File createDataDirLogFile(File version_2, int Zxid) throws IOException {
        File logFile = new File(version_2 + "/log." + Long.toHexString(Zxid));
        Assert.assertTrue((String)("Failed to create log File:" + logFile.toString()), (boolean)logFile.createNewFile());
        return logFile;
    }

    private void createDataDirFiles(AtomicInteger offset, int limit, boolean createPrecedingLogFile, File version_2, List<File> snaps, List<File> logs) throws IOException {
        int counter = offset.get() + 2 * limit;
        if (createPrecedingLogFile) {
            ++counter;
        }
        offset.set(counter);
        for (int i = 0; i < limit; ++i) {
            logs.add(this.createDataDirLogFile(version_2, --counter));
            File snapFile = new File(version_2 + "/snapshot." + Long.toHexString(--counter));
            Assert.assertTrue((String)("Failed to create snap File:" + snapFile.toString()), (boolean)snapFile.createNewFile());
            snaps.add(snapFile);
        }
        if (createPrecedingLogFile) {
            logs.add(this.createDataDirLogFile(version_2, --counter));
        }
    }

    private void verifyFilesAfterPurge(List<File> logs, boolean exists) {
        for (File file : logs) {
            Assert.assertEquals((String)("After purging, file " + file), (Object)exists, (Object)file.exists());
        }
    }

    private List<String> manyClientOps(final ZooKeeper zk, final CountDownLatch doPurge, int thCount, String prefix) {
        Thread[] ths = new Thread[thCount];
        final List<String> znodes = Collections.synchronizedList(new ArrayList());
        final CountDownLatch finished = new CountDownLatch(thCount);
        for (int indx = 0; indx < thCount; ++indx) {
            Thread th;
            final String myprefix = prefix + "-" + indx;
            ths[indx] = th = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 1000; ++i) {
                        try {
                            String mynode = myprefix + "-" + i;
                            znodes.add(mynode);
                            zk.create(mynode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        }
                        catch (Exception e) {
                            LOG.error("Unexpected exception occurred!", (Throwable)e);
                        }
                        if (i != 200) continue;
                        doPurge.countDown();
                    }
                    finished.countDown();
                }
            };
        }
        for (Thread thread : ths) {
            thread.start();
        }
        try {
            Assert.assertTrue((String)"ZkClient ops is not finished!", (boolean)finished.await(90000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ie) {
            LOG.error("Unexpected exception occurred!", (Throwable)ie);
            Assert.fail((String)"Unexpected exception occurred!");
        }
        return znodes;
    }

    @Override
    public void process(WatchedEvent event) {
    }
}

