/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.MiniKdc;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.QuorumAuthTestBase;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class KerberosSecurityTestcase
extends QuorumAuthTestBase {
    private static MiniKdc kdc;
    private static File workDir;
    private static Properties conf;

    @BeforeClass
    public static void setUpSasl() throws Exception {
        KerberosSecurityTestcase.startMiniKdc();
    }

    @AfterClass
    public static void tearDownSasl() throws Exception {
        KerberosSecurityTestcase.stopMiniKdc();
        FileUtils.deleteQuietly((File)workDir);
    }

    public static void startMiniKdc() throws Exception {
        KerberosSecurityTestcase.createTestDir();
        KerberosSecurityTestcase.createMiniKdcConf();
        kdc = new MiniKdc(conf, workDir);
        kdc.start();
    }

    public static void createTestDir() throws IOException {
        workDir = KerberosSecurityTestcase.createTmpDir(new File(System.getProperty("build.test.dir", "build")));
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    public static void createMiniKdcConf() {
        conf = MiniKdc.createConf();
    }

    public static void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
        }
    }

    public static MiniKdc getKdc() {
        return kdc;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public static Properties getConf() {
        return conf;
    }
}

