/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    volatile int counter = 0;
    volatile int errors = 0;

    @Test
    public void testFollowersStartAfterLeader() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        qu.shutdown(index);
        watcher.waitForDisconnected(CONNECTION_TIMEOUT);
        qu.start(index);
        try {
            watcher.waitForConnected(30000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
        }
        zk.close();
        qu.tearDown();
    }

    @Test
    public void testMultiToFollower() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        List<Object> results = new ArrayList();
        results = zk.multi(Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT)));
        zk.getData("/multi0", false, null);
        zk.getData("/multi1", false, null);
        zk.getData("/multi2", false, null);
        zk.close();
        qu.tearDown();
    }
}

