/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientHammerTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.JMXEnv;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalQuorumTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumBase.class);
    File s1dir;
    File s2dir;
    File s3dir;
    File s4dir;
    File s5dir;
    QuorumPeer s1;
    QuorumPeer s2;
    QuorumPeer s3;
    QuorumPeer s4;
    QuorumPeer s5;
    protected int port1;
    protected int port2;
    protected int port3;
    protected int port4;
    protected int port5;
    protected int leport1;
    protected int leport2;
    protected int leport3;
    protected int leport4;
    protected int leport5;
    Properties qp;
    protected final ClientHammerTest cht = new ClientHammerTest();

    @Override
    public void setUp() throws Exception {
        HierarchicalQuorumTest.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.port1 = PortAssignment.unique();
        this.port2 = PortAssignment.unique();
        this.port3 = PortAssignment.unique();
        this.port4 = PortAssignment.unique();
        this.port5 = PortAssignment.unique();
        this.leport1 = PortAssignment.unique();
        this.leport2 = PortAssignment.unique();
        this.leport3 = PortAssignment.unique();
        this.leport4 = PortAssignment.unique();
        this.leport5 = PortAssignment.unique();
        this.hostPort = "127.0.0.1:" + this.port1 + ",127.0.0.1:" + this.port2 + ",127.0.0.1:" + this.port3 + ",127.0.0.1:" + this.port4 + ",127.0.0.1:" + this.port5;
        LOG.info("Ports are: " + this.hostPort);
        this.s1dir = ClientBase.createTmpDir();
        this.s2dir = ClientBase.createTmpDir();
        this.s3dir = ClientBase.createTmpDir();
        this.s4dir = ClientBase.createTmpDir();
        this.s5dir = ClientBase.createTmpDir();
        String config = "group.1=1:2:3\ngroup.2=4:5\nweight.1=1\nweight.2=1\nweight.3=1\nweight.4=0\nweight.5=0\n";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.qp = new Properties();
        this.qp.load(is);
        this.startServers();
        this.cht.hostPort = this.hostPort;
        this.cht.setUpAll();
        LOG.info("Setup finished");
    }

    void startServers() throws Exception {
        this.startServers(false);
    }

    void startServers(boolean withObservers) throws Exception {
        int i;
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, "127.0.0.1", this.port1 + 1000, this.leport1 + 1000, null));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, "127.0.0.1", this.port2 + 1000, this.leport2 + 1000, null));
        peers.put(3L, new QuorumPeer.QuorumServer(3L, "127.0.0.1", this.port3 + 1000, this.leport3 + 1000, null));
        peers.put(4L, new QuorumPeer.QuorumServer(4L, "127.0.0.1", this.port4 + 1000, this.leport4 + 1000, withObservers ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(5L, new QuorumPeer.QuorumServer(5L, "127.0.0.1", this.port5 + 1000, this.leport5 + 1000, withObservers ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT));
        LOG.info("creating QuorumPeer 1 port " + this.port1);
        ArrayList<QuorumPeer> qps = new ArrayList<QuorumPeer>();
        QuorumHierarchical hq1 = new QuorumHierarchical(this.qp);
        this.s1 = new QuorumPeer(peers, this.s1dir, this.s1dir, this.port1, 3, 1L, tickTime, initLimit, syncLimit, hq1);
        qps.add(this.s1);
        Assert.assertEquals((long)this.port1, (long)this.s1.getClientPort());
        LOG.info("creating QuorumPeer 2 port " + this.port2);
        QuorumHierarchical hq2 = new QuorumHierarchical(this.qp);
        this.s2 = new QuorumPeer(peers, this.s2dir, this.s2dir, this.port2, 3, 2L, tickTime, initLimit, syncLimit, hq2);
        qps.add(this.s2);
        Assert.assertEquals((long)this.port2, (long)this.s2.getClientPort());
        LOG.info("creating QuorumPeer 3 port " + this.port3);
        QuorumHierarchical hq3 = new QuorumHierarchical(this.qp);
        this.s3 = new QuorumPeer(peers, this.s3dir, this.s3dir, this.port3, 3, 3L, tickTime, initLimit, syncLimit, hq3);
        qps.add(this.s3);
        Assert.assertEquals((long)this.port3, (long)this.s3.getClientPort());
        LOG.info("creating QuorumPeer 4 port " + this.port4);
        QuorumHierarchical hq4 = new QuorumHierarchical(this.qp);
        this.s4 = new QuorumPeer(peers, this.s4dir, this.s4dir, this.port4, 3, 4L, tickTime, initLimit, syncLimit, hq4);
        qps.add(this.s4);
        if (withObservers) {
            this.s4.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        Assert.assertEquals((long)this.port4, (long)this.s4.getClientPort());
        LOG.info("creating QuorumPeer 5 port " + this.port5);
        QuorumHierarchical hq5 = new QuorumHierarchical(this.qp);
        this.s5 = new QuorumPeer(peers, this.s5dir, this.s5dir, this.port5, 3, 5L, tickTime, initLimit, syncLimit, hq5);
        qps.add(this.s5);
        if (withObservers) {
            this.s5.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        Assert.assertEquals((long)this.port5, (long)this.s5.getClientPort());
        if (withObservers) {
            this.s1.setElectionType(0);
            this.s2.setElectionType(0);
            this.s3.setElectionType(0);
            this.s4.setElectionType(0);
            this.s5.setElectionType(0);
        }
        LOG.info("start QuorumPeer 1");
        this.s1.start();
        LOG.info("start QuorumPeer 2");
        this.s2.start();
        LOG.info("start QuorumPeer 3");
        this.s3.start();
        LOG.info("start QuorumPeer 4" + (withObservers ? "(observer)" : ""));
        this.s4.start();
        LOG.info("start QuorumPeer 5" + (withObservers ? "(observer)" : ""));
        this.s5.start();
        LOG.info("started QuorumPeer 5");
        LOG.info("Closing ports " + this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        JMXEnv.dump();
        LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("InMemoryDataTree");
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
        }
        for (i = 1; i <= 5; ++i) {
            for (int j = 1; j <= 5; ++j) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
            }
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i);
        }
        JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
        this.verifyElectionTimeTakenJMXAttribute(qps);
    }

    @Override
    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        this.cht.tearDownAll();
        LOG.info("Shutting down server 1");
        this.shutdown(this.s1);
        LOG.info("Shutting down server 2");
        this.shutdown(this.s2);
        LOG.info("Shutting down server 3");
        this.shutdown(this.s3);
        LOG.info("Shutting down server 4");
        this.shutdown(this.s4);
        LOG.info("Shutting down server 5");
        this.shutdown(this.s5);
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is no longer accepting client connections");
        }
        JMXEnv.tearDown();
    }

    protected void shutdown(QuorumPeer qp) {
        QuorumBase.shutdown(qp);
    }

    @Override
    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    private void verifyElectionTimeTakenJMXAttribute(List<QuorumPeer> peers) throws Exception {
        LOG.info("Verify QuorumPeer#electionTimeTaken jmx bean attribute");
        for (int i = 1; i <= peers.size(); ++i) {
            QuorumPeer qp = peers.get(i - 1);
            if (qp.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) continue;
            Long electionTimeTaken = -1L;
            String bean = "";
            if (qp.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Follower", "io.hops.hadoop.shaded.org.apache.ZooKeeperService", i, i);
            } else if (qp.getPeerState() == QuorumPeer.ServerState.LEADING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Leader", "io.hops.hadoop.shaded.org.apache.ZooKeeperService", i, i);
            }
            electionTimeTaken = (Long)JMXEnv.ensureBeanAttribute(bean, "ElectionTimeTaken");
            Assert.assertTrue((String)"Wrong electionTimeTaken value!", (electionTimeTaken >= 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHierarchicalQuorum() throws Throwable {
        this.cht.runHammer(5, 10);
    }
}

