/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFromLogTest
extends ClientBase {
    private static final int NUM_MESSAGES = 300;
    protected static final Logger LOG = LoggerFactory.getLogger(LoadFromLogTest.class);
    private static final int TRANSACTION_OVERHEAD = 2;
    private static final int TOTAL_TRANSACTIONS = 302;

    @Override
    @Before
    public void setUp() throws Exception {
        SyncRequestProcessor.setSnapCount(50);
        super.setUp();
    }

    @Test
    public void testLoad() throws Exception {
        ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);
        try {
            for (int i = 0; i < 300; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        this.stopServer();
        File logDir = new File(this.tmpDir, "version-2");
        FileTxnLog txnLog = new FileTxnLog(logDir);
        TxnLog.TxnIterator itr = txnLog.read(0L);
        long expectedZxid = 0L;
        long lastZxid = 0L;
        do {
            TxnHeader hdr = itr.getHeader();
            Assert.assertTrue((String)("not the same transaction. lastZxid=" + lastZxid + ", zxid=" + hdr.getZxid()), (lastZxid != hdr.getZxid() ? 1 : 0) != 0);
            Assert.assertTrue((String)("excepting next transaction. expected=" + ++expectedZxid + ", retreived=" + hdr.getZxid()), (hdr.getZxid() == expectedZxid ? 1 : 0) != 0);
            lastZxid = hdr.getZxid();
        } while (itr.next());
        Assert.assertTrue((String)("processed all transactions. " + expectedZxid + " == " + 302), (expectedZxid == 302L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestore() throws Exception {
        String path;
        String[] children;
        ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);
        String lastPath = null;
        try {
            zk.create("/invalidsnap", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i = 0; i < 300; ++i) {
                lastPath = zk.create("/invalidsnap/test-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        }
        finally {
            zk.close();
        }
        String[] tokens = lastPath.split("-");
        String expectedPath = "/invalidsnap/test-" + String.format("%010d", Integer.parseInt(tokens[1]) + 1);
        ZooKeeperServer zks = LoadFromLogTest.getServer(this.serverFactory);
        long eZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to " + zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        this.startServer();
        zks = LoadFromLogTest.getServer(this.serverFactory);
        long fZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        Assert.assertTrue((String)("Restore failed expected zxid=" + eZxid + " found=" + fZxid), (fZxid == eZxid ? 1 : 0) != 0);
        zk = LoadFromLogTest.createZKClient(this.hostPort);
        try {
            children = zk.getChildren("/invalidsnap", false).toArray(new String[0]);
            path = zk.create("/invalidsnap/test-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        finally {
            zk.close();
        }
        LOG.info("Expected " + expectedPath + " found " + path);
        Assert.assertTrue((String)("Error in sequential znode creation expected " + expectedPath + " found " + path), (boolean)path.equals(expectedPath));
        Assert.assertTrue((String)("Unexpected number of children " + children.length + " expected " + 300), (children.length == 300 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithTransactionErrors() throws Exception {
        ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);
        try {
            for (int i = 0; i < 300; ++i) {
                try {
                    zk.create("/invaliddir/test-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                    continue;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }
        finally {
            zk.close();
        }
        ZooKeeperServer zks = LoadFromLogTest.getServer(this.serverFactory);
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to " + zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        this.startServer();
    }

    @Test
    public void testReloadSnapshotWithMissingParent() throws Exception {
        ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);
        zk.create("/a", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = zk.exists("/a", false);
        long createZxId = stat.getMzxid();
        zk.create("/a/b", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.delete("/a/b", -1);
        zk.delete("/a", -1);
        ZooKeeperServer zks = LoadFromLogTest.getServer(this.serverFactory);
        zks.getZKDatabase().setlastProcessedZxid(createZxId);
        LOG.info("Set lastProcessedZxid to {}", (Object)zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        this.startServer();
    }
}

