/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.OpResult;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.Transaction;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiTransactionTest
extends ClientBase {
    private static final Logger LOG = Logger.getLogger(MultiTransactionTest.class);
    private ZooKeeper zk;
    private ZooKeeper zk_chroot;
    private final boolean useAsync;

    public MultiTransactionTest(boolean useAsync) {
        this.useAsync = useAsync;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({false}, {true});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        SyncRequestProcessor.setSnapCount(150);
        super.setUp();
        this.zk = this.createClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpResult> multi(ZooKeeper zk, Iterable<Op> ops) throws KeeperException, InterruptedException {
        if (this.useAsync) {
            final MultiResult res = new MultiResult();
            zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            if (KeeperException.Code.OK.intValue() != res.rc) {
                KeeperException ke = KeeperException.create(KeeperException.Code.get(res.rc));
                throw ke;
            }
            return res.results;
        }
        return zk.multi(ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multiHavingErrors(ZooKeeper zk, Iterable<Op> ops, List<Integer> expectedResultCodes, String expectedErr) throws KeeperException, InterruptedException {
        if (this.useAsync) {
            final MultiResult res = new MultiResult();
            zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            for (int i = 0; i < res.results.size(); ++i) {
                OpResult opResult = res.results.get(i);
                Assert.assertTrue((String)"Did't recieve proper error response", (boolean)(opResult instanceof OpResult.ErrorResult));
                OpResult.ErrorResult errRes = (OpResult.ErrorResult)opResult;
                Assert.assertEquals((String)"Did't recieve proper error code", (long)expectedResultCodes.get(i).intValue(), (long)errRes.getErr());
            }
        } else {
            try {
                zk.multi(ops);
                Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
            }
            catch (KeeperException e) {
                Assert.assertEquals((String)"Wrong exception", (Object)expectedErr, (Object)e.code().name());
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((String)"Wrong exception", (Object)expectedErr, (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpResult> commit(Transaction txn) throws KeeperException, InterruptedException {
        if (this.useAsync) {
            final MultiResult res = new MultiResult();
            txn.commit(new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            if (KeeperException.Code.OK.intValue() != res.rc) {
                KeeperException ke = KeeperException.create(KeeperException.Code.get(res.rc));
                throw ke;
            }
            return res.results;
        }
        return txn.commit();
    }

    @Test(timeout=90000L)
    public void testInvalidPath() throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        List<Op> opList = Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi1/", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
        String expectedErr = "Path must not end with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
        opList = Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("multi1/", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL.toFlag()), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
        expectedErr = "Path must start with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
        opList = Arrays.asList(Op.check("/multi0", -1), Op.check("/multi1/", 100), Op.check("/multi2", 5));
        expectedErr = "Path must not end with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
        opList = Arrays.asList(Op.delete("/multi0", -1), Op.delete("/multi1/", 100), Op.delete("/multi2", 5));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        opList = Arrays.asList(Op.setData("/multi0", new byte[0], -1), Op.setData("/multi1/", new byte[0], -1), Op.setData("/multi2", new byte[0], -1), Op.setData("multi3", new byte[0], -1));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
    }

    @Test(timeout=90000L)
    public void testBlankPath() throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        String expectedErr = "Path cannot be null";
        List<Op> opList = Arrays.asList(Op.delete("/multi0", -1), Op.delete(null, 100), Op.delete("/multi2", 5), Op.delete("", -1));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
    }

    @Test(timeout=90000L)
    public void testInvalidCreateModeFlag() throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        int createModeFlag = 6789;
        List<Op> opList = Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, createModeFlag), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
        String expectedErr = KeeperException.Code.BADARGUMENTS.name();
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr);
    }

    @Test
    public void testMultiRollback() throws Exception {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        TestableZooKeeper epheZk = this.createClient();
        epheZk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        List<Op> opList = Arrays.asList(Op.delete("/foo", -1));
        try {
            this.multi(this.zk, opList);
            Assert.fail((String)"multi delete should failed for not empty directory");
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
            // empty catch block
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.zk.exists("/foo/bar", new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    latch.countDown();
                }
            }
        });
        epheZk.close();
        latch.await();
        try {
            this.zk.getData("/foo/bar", false, null);
            Assert.fail((String)"ephemeral node should have been deleted");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        this.multi(this.zk, opList);
        try {
            this.zk.getData("/foo", false, null);
            Assert.fail((String)"persistent node should have been deleted after multi");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @Test
    public void testChRootCreateDelete() throws Exception {
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        Op createChild = Op.create("/myid", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.multi(this.zk_chroot, Arrays.asList(createChild));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk_chroot.exists("/myid", false));
        Assert.assertNull((String)"zNode is created directly under '/', ignored configured chroot", (Object)this.zk.exists("/myid", false));
        Op deleteChild = Op.delete("/myid", 0);
        this.multi(this.zk_chroot, Arrays.asList(deleteChild));
        Assert.assertNull((String)("zNode exists under chroot:" + chRoot), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNull((String)("zNode exists under chroot:" + chRoot), (Object)this.zk_chroot.exists("/myid", false));
    }

    @Test
    public void testChRootSetData() throws Exception {
        int i;
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create(names[i], new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
            ops.add(Op.setData(names[i], names[i].getBytes(), 0));
        }
        this.multi(this.zk_chroot, ops);
        for (i = 0; i < names.length; ++i) {
            Assert.assertArrayEquals((String)"zNode data not matching", (byte[])names[i].getBytes(), (byte[])this.zk_chroot.getData(names[i], false, null));
        }
    }

    @Test
    public void testChRootCheck() throws Exception {
        int i;
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            this.zk.create(chRoot + names[i], new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.check(names[i], 0));
        }
        this.multi(this.zk_chroot, ops);
    }

    @Test
    public void testChRootTransaction() throws Exception {
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String childPath = "/myid";
        Transaction transaction = this.zk_chroot.transaction();
        transaction.create(childPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        transaction.check(childPath, 0);
        transaction.setData(childPath, childPath.getBytes(), 0);
        this.commit(transaction);
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk.exists(chRoot + childPath, false));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk_chroot.exists(childPath, false));
        Assert.assertNull((String)"zNode is created directly under '/', ignored configured chroot", (Object)this.zk.exists(childPath, false));
        Assert.assertArrayEquals((String)"zNode data not matching", (byte[])childPath.getBytes(), (byte[])this.zk_chroot.getData(childPath, false, null));
        transaction = this.zk_chroot.transaction();
        transaction.delete(childPath, 1);
        this.commit(transaction);
        Assert.assertNull((String)("chroot:" + chRoot + " exists after delete"), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNull((String)("chroot:" + chRoot + " exists after delete"), (Object)this.zk_chroot.exists("/myid", false));
    }

    private String createNameSpace() throws InterruptedException, KeeperException {
        String chRoot = "/appsX";
        Op createChRoot = Op.create(chRoot, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.multi(this.zk, Arrays.asList(createChRoot));
        return chRoot;
    }

    @Test
    public void testCreate() throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT)));
        this.zk.getData("/multi0", false, null);
        this.zk.getData("/multi1", false, null);
        this.zk.getData("/multi2", false, null);
    }

    @Test
    public void testCreateDelete() throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/multi", 0)));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testInvalidVersion() throws Exception {
        try {
            this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/multi", 1)));
            Assert.fail((String)"delete /multi should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedCreate() throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi/a/1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/multi/a/1", 0), Op.delete("/multi/a", 0), Op.delete("/multi", 0)));
        Assert.assertNull((Object)this.zk.exists("/multi/a/1", null));
        Assert.assertNull((Object)this.zk.exists("/multi/a", null));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testSetData() throws Exception {
        int i;
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create(names[i], new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
            ops.add(Op.setData(names[i], names[i].getBytes(), 0));
        }
        this.multi(this.zk, ops);
        for (i = 0; i < names.length; ++i) {
            Assert.assertArrayEquals((byte[])names[i].getBytes(), (byte[])this.zk.getData(names[i], false, null));
        }
    }

    @Test
    public void testUpdateConflict() throws Exception {
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        try {
            this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.setData("/multi", "X".getBytes(), 0), Op.setData("/multi", "Y".getBytes(), 0)));
            Assert.fail((String)"Should have thrown a KeeperException for invalid version");
        }
        catch (KeeperException e) {
            LOG.error((Object)("STACKTRACE: " + e));
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.setData("/multi", "X".getBytes(), 0), Op.setData("/multi", "Y".getBytes(), 1)));
        Assert.assertArrayEquals((byte[])this.zk.getData("/multi", false, null), (byte[])"Y".getBytes());
    }

    @Test
    public void TestDeleteUpdateConflict() throws Exception {
        try {
            this.multi(this.zk, Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/multi", 0), Op.setData("/multi", "Y".getBytes(), 0)));
            Assert.fail((String)"/multi should have been deleted so setData should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestGetResults() throws Exception {
        List<Op> ops = Arrays.asList(Op.create("/multi", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/multi", 0), Op.setData("/multi", "Y".getBytes(), 0), Op.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
        List<OpResult> results = null;
        if (this.useAsync) {
            final MultiResult res = new MultiResult();
            this.zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            Assert.assertFalse((String)"/multi should have been deleted so setData should have failed", (KeeperException.Code.OK.intValue() == res.rc ? 1 : 0) != 0);
            Assert.assertNull((Object)this.zk.exists("/multi", null));
            results = res.results;
        } else {
            try {
                this.zk.multi(ops);
                Assert.fail((String)"/multi should have been deleted so setData should have failed");
            }
            catch (KeeperException e) {
                Assert.assertNull((Object)this.zk.exists("/multi", null));
                results = e.getResults();
            }
        }
        Assert.assertNotNull(results);
        for (OpResult r : results) {
            LOG.info((Object)("RESULT==> " + r));
            if (!(r instanceof OpResult.ErrorResult)) continue;
            OpResult.ErrorResult er = (OpResult.ErrorResult)r;
            LOG.info((Object)("ERROR RESULT: " + er + " ERR=>" + KeeperException.Code.get(er.getErr())));
        }
    }

    @Test
    public void testOpResultEquals() {
        this.opEquals(new OpResult.CreateResult("/foo"), new OpResult.CreateResult("/foo"), new OpResult.CreateResult("nope"));
        this.opEquals(new OpResult.CheckResult(), new OpResult.CheckResult(), null);
        this.opEquals(new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), new OpResult.SetDataResult(new Stat(11L, 12L, 13L, 14L, 15, 16, 17, 18L, 19, 110, 111L)));
        this.opEquals(new OpResult.ErrorResult(1), new OpResult.ErrorResult(1), new OpResult.ErrorResult(2));
        this.opEquals(new OpResult.DeleteResult(), new OpResult.DeleteResult(), null);
        this.opEquals(new OpResult.ErrorResult(1), new OpResult.ErrorResult(1), new OpResult.ErrorResult(2));
    }

    private void opEquals(OpResult expected, OpResult value, OpResult near) {
        Assert.assertEquals((Object)value, (Object)value);
        Assert.assertFalse((boolean)value.equals(new Object()));
        Assert.assertFalse((boolean)value.equals(near));
        Assert.assertFalse((boolean)value.equals(value instanceof OpResult.CreateResult ? new OpResult.ErrorResult(1) : new OpResult.CreateResult("nope2")));
        Assert.assertTrue((boolean)value.equals(expected));
    }

    @Test
    public void testWatchesTriggered() throws KeeperException, InterruptedException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", watcher);
        this.multi(this.zk, Arrays.asList(Op.create("/t", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/t", -1)));
        Assert.assertTrue((boolean)watcher.triggered.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testNoWatchesTriggeredForFailedMultiRequest() throws InterruptedException, KeeperException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", watcher);
        try {
            this.multi(this.zk, Arrays.asList(Op.create("/t", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.delete("/nonexisting", -1)));
            Assert.fail((String)"expected previous multi op to fail!");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        SyncCallback cb = new SyncCallback();
        this.zk.sync("/", cb, null);
        cb.done.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)watcher.triggered.getCount());
    }

    @Test
    public void testTransactionBuilder() throws Exception {
        OpResult c;
        List<OpResult> results = this.commit(this.zk.transaction().create("/t1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t1/child", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL));
        Assert.assertEquals((long)3L, (long)results.size());
        for (OpResult r : results) {
            c = (OpResult.CreateResult)r;
            Assert.assertTrue((boolean)((OpResult.CreateResult)c).getPath().startsWith("/t"));
            Assert.assertNotNull((Object)c.toString());
        }
        Assert.assertNotNull((Object)this.zk.exists("/t1", false));
        Assert.assertNotNull((Object)this.zk.exists("/t1/child", false));
        Assert.assertNotNull((Object)this.zk.exists("/t2", false));
        results = this.commit(this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 0));
        Assert.assertEquals((long)3L, (long)results.size());
        for (OpResult r : results) {
            c = (OpResult.CheckResult)r;
            Assert.assertNotNull((Object)c.toString());
        }
        try {
            results = this.commit(this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 1));
            Assert.fail();
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        results = this.commit(this.zk.transaction().check("/t1", 0).setData("/t1", new byte[0], 0));
        Assert.assertEquals((long)2L, (long)results.size());
        for (OpResult r : results) {
            Assert.assertNotNull((Object)r.toString());
        }
        try {
            results = this.commit(this.zk.transaction().check("/t1", 1).setData("/t1", new byte[0], 2));
            Assert.fail();
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        results = this.commit(this.zk.transaction().check("/t1", 1).check("/t1/child", 0).check("/t2", 0));
        Assert.assertEquals((long)3L, (long)results.size());
        results = this.commit(this.zk.transaction().delete("/t2", -1).delete("/t1/child", -1));
        Assert.assertEquals((long)2L, (long)results.size());
        for (OpResult r : results) {
            OpResult.DeleteResult d = (OpResult.DeleteResult)r;
            Assert.assertNotNull((Object)d.toString());
        }
        Assert.assertNotNull((Object)this.zk.exists("/t1", false));
        Assert.assertNull((Object)this.zk.exists("/t1/child", false));
        Assert.assertNull((Object)this.zk.exists("/t2", false));
    }

    private static class SyncCallback
    implements AsyncCallback.VoidCallback {
        private final CountDownLatch done = new CountDownLatch(1);

        private SyncCallback() {
        }

        @Override
        public void processResult(int rc, String path, Object ctx) {
            this.done.countDown();
        }
    }

    private static class HasTriggeredWatcher
    implements Watcher {
        private final CountDownLatch triggered = new CountDownLatch(1);

        private HasTriggeredWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            this.triggered.countDown();
        }
    }

    static class MultiResult {
        int rc;
        List<OpResult> results;
        boolean finished = false;

        MultiResult() {
        }
    }
}

