/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.sizeof;

import io.hops.hadoop.shaded.org.ehcache.config.ResourceUnit;
import io.hops.hadoop.shaded.org.ehcache.config.units.MemoryUnit;
import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ServiceUtils;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.heap.SizeOfEngine;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.heap.SizeOfEngineProvider;
import io.hops.hadoop.shaded.org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.sizeof.DefaultSizeOfEngine;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.sizeof.NoopSizeOfEngine;
import io.hops.hadoop.shaded.org.ehcache.spi.service.Service;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;

public class DefaultSizeOfEngineProvider
implements SizeOfEngineProvider {
    private final long maxObjectGraphSize;
    private final long maxObjectSize;

    public DefaultSizeOfEngineProvider(long maxObjectGraphSize, long maxObjectSize) {
        this.maxObjectGraphSize = maxObjectGraphSize;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
    }

    @Override
    public void stop() {
    }

    @Override
    public SizeOfEngine createSizeOfEngine(ResourceUnit resourceUnit, ServiceConfiguration<?> ... serviceConfigs) {
        boolean isByteSized = resourceUnit instanceof MemoryUnit;
        if (!isByteSized) {
            return new NoopSizeOfEngine();
        }
        DefaultSizeOfEngineConfiguration config = ServiceUtils.findSingletonAmongst(DefaultSizeOfEngineConfiguration.class, serviceConfigs);
        if (config != null) {
            long maxSize = config.getUnit().toBytes(config.getMaxObjectSize());
            return new DefaultSizeOfEngine(config.getMaxObjectGraphSize(), maxSize);
        }
        return new DefaultSizeOfEngine(this.maxObjectGraphSize, this.maxObjectSize);
    }
}

