/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Appendable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Appender;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Context;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ProcessorExecutor;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import io.hops.hadoop.shaded.org.glassfish.grizzly.WriteResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.asyncqueue.MessageCloner;
import io.hops.hadoop.shaded.org.glassfish.grizzly.asyncqueue.PushBackHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeHolder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChain;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.ForkAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.InternalContextImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.InvokeAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.RerunFilterAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.StopAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.SuspendAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.TransportFilter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FilterChainContext
implements AttributeStorage {
    private static final Logger logger = Grizzly.logger(FilterChainContext.class);
    private static final ThreadCache.CachedTypeIndex<FilterChainContext> CACHE_IDX = ThreadCache.obtainIndex(FilterChainContext.class, 8);
    public static final int NO_FILTER_INDEX = Integer.MIN_VALUE;
    private static final NextAction INVOKE_ACTION = new InvokeAction();
    private static final NextAction STOP_ACTION = new StopAction();
    private static final NextAction SUSPEND_ACTION = new SuspendAction();
    private static final NextAction RERUN_FILTER_ACTION = new RerunFilterAction();
    final InternalContextImpl internalContext = new InternalContextImpl(this);
    final TransportContext transportFilterContext = new TransportContext();
    private volatile State state;
    private Operation operation = Operation.NONE;
    private AttributeHolder customAttributes;
    protected CompletionHandler<FilterChainContext> operationCompletionHandler;
    private final Runnable contextRunnable;
    private Object message;
    protected FilterChainEvent event;
    private Object address;
    private int filterIdx;
    private int startIdx;
    private int endIdx;
    private final StopAction cachedStopAction = new StopAction();
    private final InvokeAction cachedInvokeAction = new InvokeAction();
    private final List<CompletionListener> completionListeners = new ArrayList<CompletionListener>(2);
    private final List<CopyListener> copyListeners = new ArrayList<CopyListener>(2);

    public static FilterChainContext create(Connection connection) {
        FilterChainContext context = ThreadCache.takeFromCache(CACHE_IDX);
        if (context == null) {
            context = new FilterChainContext();
        }
        context.setConnection(connection);
        context.getTransportContext().isBlocking = connection.isBlocking();
        return context;
    }

    public FilterChainContext() {
        this.filterIdx = Integer.MIN_VALUE;
        this.contextRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FilterChainContext.this.state == State.SUSPEND) {
                        FilterChainContext.this.state = State.RUNNING;
                    }
                    ProcessorExecutor.execute(FilterChainContext.this.internalContext);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception during running Processor", e);
                }
            }
        };
    }

    public Runnable suspend() {
        this.internalContext.suspend();
        this.state = State.SUSPEND;
        return this.getRunnable();
    }

    public void resume() {
        this.internalContext.resume();
        this.getRunnable().run();
    }

    public State state() {
        return this.state;
    }

    public int nextFilterIdx() {
        return ++this.filterIdx;
    }

    public int previousFilterIdx() {
        return --this.filterIdx;
    }

    public int getFilterIdx() {
        return this.filterIdx;
    }

    public void setFilterIdx(int index) {
        this.filterIdx = index;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int startIdx) {
        this.startIdx = startIdx;
    }

    public int getEndIdx() {
        return this.endIdx;
    }

    public void setEndIdx(int endIdx) {
        this.endIdx = endIdx;
    }

    public FilterChain getFilterChain() {
        return (FilterChain)this.internalContext.getProcessor();
    }

    public Connection getConnection() {
        return this.internalContext.getConnection();
    }

    void setConnection(Connection connection) {
        this.internalContext.setConnection(connection);
    }

    public <T> T getMessage() {
        return (T)this.message;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public Object getAddress() {
        return this.address;
    }

    public void setAddress(Object address) {
        this.address = address;
    }

    protected final Runnable getRunnable() {
        return this.contextRunnable;
    }

    public TransportContext getTransportContext() {
        return this.transportFilterContext;
    }

    public final Context getInternalContext() {
        return this.internalContext;
    }

    Operation getOperation() {
        return this.operation;
    }

    void setOperation(Operation operation) {
        this.operation = operation;
    }

    public NextAction getInvokeAction(Object remainder) {
        this.cachedInvokeAction.setRemainder(remainder);
        return this.cachedInvokeAction;
    }

    public NextAction getInvokeAction() {
        return INVOKE_ACTION;
    }

    public NextAction getStopAction() {
        return STOP_ACTION;
    }

    public NextAction getForkAction() {
        FilterChainContext contextCopy = this.copy();
        contextCopy.setAddress(this.address);
        return new ForkAction(contextCopy);
    }

    public NextAction getSuspendingStopAction() {
        return this.getForkAction();
    }

    public <E> NextAction getStopAction(E remainder, Appender<E> appender) {
        this.cachedStopAction.setRemainder(remainder, appender);
        return this.cachedStopAction;
    }

    public NextAction getStopAction(Appendable appendable) {
        this.cachedStopAction.setRemainder(appendable);
        return this.cachedStopAction;
    }

    public NextAction getStopAction(Object unknownObject) {
        if (unknownObject instanceof Buffer) {
            return this.getStopAction((Buffer)unknownObject, Buffers.getBufferAppender(true));
        }
        return this.getStopAction((Appendable)unknownObject);
    }

    public NextAction getSuspendAction() {
        return SUSPEND_ACTION;
    }

    public NextAction getRerunFilterAction() {
        return RERUN_FILTER_ACTION;
    }

    public ReadResult read() throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.READ);
        newContext.getTransportContext().configureBlocking(true);
        newContext.setStartIdx(0);
        newContext.setFilterIdx(0);
        newContext.setEndIdx(this.filterIdx);
        newContext.customAttributes = this.getAttributes();
        ReadResult rr = this.getFilterChain().read(newContext);
        newContext.completeAndRecycle();
        return rr;
    }

    public void write(Object message) {
        this.write(null, message, null, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object message, boolean blocking) {
        this.write(null, message, null, null, null, blocking);
    }

    public void write(Object message, CompletionHandler<WriteResult> completionHandler) {
        this.write(null, message, completionHandler, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object message, CompletionHandler<WriteResult> completionHandler, boolean blocking) {
        this.write(null, message, completionHandler, null, null, blocking);
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler) {
        this.write(address, message, completionHandler, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, boolean blocking) {
        this.write(address, message, completionHandler, null, null, blocking);
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler) {
        this.write(address, message, completionHandler, pushBackHandler, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, boolean blocking) {
        this.write(address, message, completionHandler, pushBackHandler, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, MessageCloner cloner) {
        this.write(address, message, completionHandler, pushBackHandler, cloner, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, MessageCloner cloner, boolean blocking) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.WRITE);
        newContext.getTransportContext().configureBlocking(blocking);
        newContext.setMessage(message);
        newContext.setAddress(address);
        newContext.transportFilterContext.completionHandler = completionHandler;
        newContext.transportFilterContext.pushBackHandler = pushBackHandler;
        newContext.transportFilterContext.cloner = cloner;
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void flush(CompletionHandler completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = TransportFilter.createFlushEvent(completionHandler);
        newContext.getTransportContext().configureBlocking(this.transportFilterContext.isBlocking());
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyUpstream(FilterChainEvent event) {
        this.notifyUpstream(event, null);
    }

    public void notifyUpstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx + 1);
        newContext.setFilterIdx(this.filterIdx + 1);
        newContext.setEndIdx(this.endIdx);
        newContext.customAttributes = this.getAttributes();
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyDownstream(FilterChainEvent event) {
        this.notifyDownstream(event, null);
    }

    public void notifyDownstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void fail(Throwable error) {
        this.getFilterChain().fail(this, error);
    }

    @Override
    public AttributeHolder getAttributes() {
        if (this.customAttributes == null) {
            return this.internalContext.getAttributes();
        }
        return this.customAttributes;
    }

    public final void addCompletionListener(CompletionListener listener) {
        this.completionListeners.add(listener);
    }

    public final boolean removeCompletionListener(CompletionListener listener) {
        return this.completionListeners.remove(listener);
    }

    public final void addCopyListener(CopyListener listener) {
        this.copyListeners.add(listener);
    }

    public final boolean removeCopyListener(CopyListener listener) {
        return this.copyListeners.remove(listener);
    }

    public final MemoryManager getMemoryManager() {
        return this.getConnection().getTransport().getMemoryManager();
    }

    public FilterChainContext copy() {
        FilterChain p = this.getFilterChain();
        FilterChainContext newContext = p.obtainFilterChainContext(this.getConnection());
        newContext.setOperation(this.getOperation());
        this.internalContext.softCopyTo(newContext.internalContext);
        newContext.setStartIdx(this.getStartIdx());
        newContext.setEndIdx(this.getEndIdx());
        newContext.setFilterIdx(this.getFilterIdx());
        FilterChainContext.notifyCopy(this, newContext, this.copyListeners);
        return newContext;
    }

    public void reset() {
        this.cachedInvokeAction.reset();
        this.cachedStopAction.reset();
        this.message = null;
        this.event = null;
        this.address = null;
        this.filterIdx = Integer.MIN_VALUE;
        this.state = State.RUNNING;
        this.operationCompletionHandler = null;
        this.customAttributes = null;
        this.operation = Operation.NONE;
        this.internalContext.reset();
        this.transportFilterContext.reset();
        this.copyListeners.clear();
    }

    public void completeAndRecycle() {
        FilterChainContext.notifyComplete(this, this.completionListeners);
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(384);
        sb.append("FilterChainContext [");
        sb.append("connection=").append(this.getConnection());
        sb.append(", operation=").append((Object)this.getOperation());
        sb.append(", message=").append(this.getMessage());
        sb.append(", address=").append(this.getAddress());
        sb.append(']');
        return sb.toString();
    }

    static Operation ioEvent2Operation(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: {
                return Operation.READ;
            }
            case WRITE: {
                return Operation.WRITE;
            }
            case ACCEPTED: {
                return Operation.ACCEPT;
            }
            case CONNECTED: {
                return Operation.CONNECT;
            }
            case CLOSED: {
                return Operation.CLOSE;
            }
        }
        return Operation.NONE;
    }

    static void notifyComplete(FilterChainContext context, List<CompletionListener> completionListeners) {
        int size = completionListeners.size();
        for (int i = size - 1; i >= 0; --i) {
            completionListeners.remove(i).onComplete(context);
        }
    }

    static void notifyCopy(FilterChainContext srcContext, FilterChainContext copiedContext, List<CopyListener> copyListeners) {
        int size = copyListeners.size();
        for (int i = 0; i < size; ++i) {
            copyListeners.get(i).onCopy(srcContext, copiedContext);
        }
    }

    public static interface CopyListener {
        public void onCopy(FilterChainContext var1, FilterChainContext var2);
    }

    public static interface CompletionListener {
        public void onComplete(FilterChainContext var1);
    }

    public static final class TransportContext {
        private boolean isBlocking;
        CompletionHandler completionHandler;
        PushBackHandler pushBackHandler;
        MessageCloner cloner;

        public void configureBlocking(boolean isBlocking) {
            this.isBlocking = isBlocking;
        }

        public boolean isBlocking() {
            return this.isBlocking;
        }

        public CompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }

        public void setCompletionHandler(CompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
        }

        public PushBackHandler getPushBackHandler() {
            return this.pushBackHandler;
        }

        public void setPushBackHandler(PushBackHandler pushBackHandler) {
            this.pushBackHandler = pushBackHandler;
        }

        public MessageCloner getMessageCloner() {
            return this.cloner;
        }

        public void setMessageCloner(MessageCloner cloner) {
            this.cloner = cloner;
        }

        void reset() {
            this.isBlocking = false;
            this.completionHandler = null;
            this.pushBackHandler = null;
            this.cloner = null;
        }
    }

    public static enum Operation {
        NONE,
        ACCEPT,
        CONNECT,
        READ,
        WRITE,
        EVENT,
        CLOSE;

    }

    public static enum State {
        RUNNING,
        SUSPEND;

    }
}

