/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.memory;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.HeapMemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.SelectionKeyHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemoryManagerInitializer {
    private static final String PROP = "io.hops.hadoop.shaded.org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER";
    private static final Logger LOGGER = Grizzly.logger(MemoryManagerInitializer.class);

    MemoryManagerInitializer() {
    }

    static MemoryManager initManager() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> mmClass = Class.forName(className, true, SelectionKeyHandler.class.getClassLoader());
                return (MemoryManager)mmClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of MemoryManager {0}.  Cause: {1}", new Object[]{className, e.getMessage()});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                return new HeapMemoryManager();
            }
        }
        return new HeapMemoryManager();
    }
}

