/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito;

import io.hops.hadoop.shaded.org.mockito.Answers;
import io.hops.hadoop.shaded.org.mockito.InOrder;
import io.hops.hadoop.shaded.org.mockito.Matchers;
import io.hops.hadoop.shaded.org.mockito.MockSettings;
import io.hops.hadoop.shaded.org.mockito.MockitoDebugger;
import io.hops.hadoop.shaded.org.mockito.ReturnValues;
import io.hops.hadoop.shaded.org.mockito.internal.MockitoCore;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MockSettingsImpl;
import io.hops.hadoop.shaded.org.mockito.internal.debugging.MockitoDebuggerImpl;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.answers.AnswerReturnValuesAdapter;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.answers.CallsRealMethods;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.answers.DoesNothing;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.answers.Returns;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.answers.ThrowsException;
import io.hops.hadoop.shaded.org.mockito.internal.verification.VerificationModeFactory;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import io.hops.hadoop.shaded.org.mockito.stubbing.DeprecatedOngoingStubbing;
import io.hops.hadoop.shaded.org.mockito.stubbing.OngoingStubbing;
import io.hops.hadoop.shaded.org.mockito.stubbing.Stubber;
import io.hops.hadoop.shaded.org.mockito.stubbing.VoidMethodStubbable;
import io.hops.hadoop.shaded.org.mockito.verification.Timeout;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationMode;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationWithTimeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mockito
extends Matchers {
    static final MockitoCore MOCKITO_CORE = new MockitoCore();
    public static final Answer<Object> RETURNS_DEFAULTS = Answers.RETURNS_DEFAULTS.get();
    public static final Answer<Object> RETURNS_SMART_NULLS = Answers.RETURNS_SMART_NULLS.get();
    public static final Answer<Object> RETURNS_MOCKS = Answers.RETURNS_MOCKS.get();
    public static final Answer<Object> RETURNS_DEEP_STUBS = Answers.RETURNS_DEEP_STUBS.get();
    public static final Answer<Object> CALLS_REAL_METHODS = Answers.CALLS_REAL_METHODS.get();

    public static <T> T mock(Class<T> classToMock) {
        return Mockito.mock(classToMock, Mockito.withSettings().defaultAnswer(RETURNS_DEFAULTS));
    }

    public static <T> T mock(Class<T> classToMock, String name) {
        return Mockito.mock(classToMock, Mockito.withSettings().name(name).defaultAnswer(RETURNS_DEFAULTS));
    }

    @Deprecated
    public static <T> T mock(Class<T> classToMock, ReturnValues returnValues) {
        return Mockito.mock(classToMock, Mockito.withSettings().defaultAnswer(new AnswerReturnValuesAdapter(returnValues)));
    }

    public static <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return Mockito.mock(classToMock, Mockito.withSettings().defaultAnswer(defaultAnswer));
    }

    public static <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return MOCKITO_CORE.mock(classToMock, mockSettings);
    }

    public static <T> T spy(T object) {
        return (T)MOCKITO_CORE.mock(object.getClass(), Mockito.withSettings().spiedInstance(object).defaultAnswer(CALLS_REAL_METHODS));
    }

    public static <T> DeprecatedOngoingStubbing<T> stub(T methodCall) {
        return MOCKITO_CORE.stub(methodCall);
    }

    public static <T> OngoingStubbing<T> when(T methodCall) {
        return MOCKITO_CORE.when(methodCall);
    }

    public static <T> T verify(T mock) {
        return MOCKITO_CORE.verify(mock, Mockito.times(1));
    }

    public static <T> T verify(T mock, VerificationMode mode) {
        return MOCKITO_CORE.verify(mock, mode);
    }

    public static <T> void reset(T ... mocks) {
        MOCKITO_CORE.reset(mocks);
    }

    public static void verifyNoMoreInteractions(Object ... mocks) {
        MOCKITO_CORE.verifyNoMoreInteractions(mocks);
    }

    public static void verifyZeroInteractions(Object ... mocks) {
        MOCKITO_CORE.verifyNoMoreInteractions(mocks);
    }

    public static <T> VoidMethodStubbable<T> stubVoid(T mock) {
        return MOCKITO_CORE.stubVoid(mock);
    }

    public static Stubber doThrow(Throwable toBeThrown) {
        return MOCKITO_CORE.doAnswer(new ThrowsException(toBeThrown));
    }

    public static Stubber doCallRealMethod() {
        return MOCKITO_CORE.doAnswer(new CallsRealMethods());
    }

    public static Stubber doAnswer(Answer answer) {
        return MOCKITO_CORE.doAnswer(answer);
    }

    public static Stubber doNothing() {
        return MOCKITO_CORE.doAnswer(new DoesNothing());
    }

    public static Stubber doReturn(Object toBeReturned) {
        return MOCKITO_CORE.doAnswer(new Returns(toBeReturned));
    }

    public static InOrder inOrder(Object ... mocks) {
        return MOCKITO_CORE.inOrder(mocks);
    }

    public static VerificationMode times(int wantedNumberOfInvocations) {
        return VerificationModeFactory.times(wantedNumberOfInvocations);
    }

    public static VerificationMode never() {
        return Mockito.times(0);
    }

    public static VerificationMode atLeastOnce() {
        return VerificationModeFactory.atLeastOnce();
    }

    public static VerificationMode atLeast(int minNumberOfInvocations) {
        return VerificationModeFactory.atLeast(minNumberOfInvocations);
    }

    public static VerificationMode atMost(int maxNumberOfInvocations) {
        return VerificationModeFactory.atMost(maxNumberOfInvocations);
    }

    public static VerificationMode only() {
        return VerificationModeFactory.only();
    }

    public static VerificationWithTimeout timeout(int millis) {
        return new Timeout(millis, VerificationModeFactory.times(1));
    }

    public static void validateMockitoUsage() {
        MOCKITO_CORE.validateMockitoUsage();
    }

    public static MockSettings withSettings() {
        return new MockSettingsImpl().defaultAnswer(RETURNS_DEFAULTS);
    }

    @Deprecated
    static MockitoDebugger debug() {
        return new MockitoDebuggerImpl();
    }
}

