/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal;

import io.hops.hadoop.shaded.org.mockito.InOrder;
import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import io.hops.hadoop.shaded.org.mockito.internal.MockitoCore;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.verification.InOrderContextImpl;
import io.hops.hadoop.shaded.org.mockito.internal.verification.InOrderWrapper;
import io.hops.hadoop.shaded.org.mockito.internal.verification.VerificationModeFactory;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.InOrderContext;
import io.hops.hadoop.shaded.org.mockito.internal.verification.api.VerificationInOrderMode;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationMode;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOrderImpl
implements InOrder,
InOrderContext {
    private final MockitoCore mockitoCore = new MockitoCore();
    private final Reporter reporter = new Reporter();
    private final List<Object> mocksToBeVerifiedInOrder = new LinkedList<Object>();
    private final InOrderContext inOrderContext = new InOrderContextImpl();

    public List<Object> getMocksToBeVerifiedInOrder() {
        return this.mocksToBeVerifiedInOrder;
    }

    public InOrderImpl(List<Object> mocksToBeVerifiedInOrder) {
        this.mocksToBeVerifiedInOrder.addAll(mocksToBeVerifiedInOrder);
    }

    @Override
    public <T> T verify(T mock) {
        return this.verify(mock, VerificationModeFactory.times(1));
    }

    @Override
    public <T> T verify(T mock, VerificationMode mode) {
        if (!this.mocksToBeVerifiedInOrder.contains(mock)) {
            this.reporter.inOrderRequiresFamiliarMock();
        } else if (!(mode instanceof VerificationInOrderMode)) {
            throw new MockitoException(mode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
        return this.mockitoCore.verify(mock, new InOrderWrapper((VerificationInOrderMode)((Object)mode), this));
    }

    @Override
    public boolean isVerified(Invocation i) {
        return this.inOrderContext.isVerified(i);
    }

    @Override
    public void markVerified(Invocation i) {
        this.inOrderContext.markVerified(i);
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.mockitoCore.verifyNoMoreInteractionsInOrder(this.mocksToBeVerifiedInOrder, this);
    }
}

