/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal;

import io.hops.hadoop.shaded.org.mockito.internal.MockHandlerInterface;
import io.hops.hadoop.shaded.org.mockito.internal.MockitoInvocationHandler;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MockSettingsImpl;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.MatchersBinder;
import io.hops.hadoop.shaded.org.mockito.internal.progress.MockingProgress;
import io.hops.hadoop.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.InvocationContainer;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.OngoingStubbingImpl;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.StubbedInvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.stubbing.VoidMethodStubbableImpl;
import io.hops.hadoop.shaded.org.mockito.internal.verification.MockAwareVerificationMode;
import io.hops.hadoop.shaded.org.mockito.internal.verification.VerificationDataImpl;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import io.hops.hadoop.shaded.org.mockito.stubbing.VoidMethodStubbable;
import io.hops.hadoop.shaded.org.mockito.verification.VerificationMode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHandler<T>
implements MockitoInvocationHandler,
MockHandlerInterface<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainerImpl;
    MatchersBinder matchersBinder = new MatchersBinder();
    MockingProgress mockingProgress = new ThreadSafeMockingProgress();
    private final MockSettingsImpl mockSettings;

    public MockHandler(MockSettingsImpl mockSettings) {
        this.mockSettings = mockSettings;
        this.mockingProgress = new ThreadSafeMockingProgress();
        this.matchersBinder = new MatchersBinder();
        this.invocationContainerImpl = new InvocationContainerImpl(this.mockingProgress);
    }

    MockHandler() {
        this(new MockSettingsImpl());
    }

    public MockHandler(MockHandlerInterface<T> oldMockHandler) {
        this(oldMockHandler.getMockSettings());
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainerImpl.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
            this.invocationContainerImpl.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = this.mockingProgress.pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
        this.mockingProgress.validateState();
        if (verificationMode != null) {
            if (((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
                VerificationDataImpl data = new VerificationDataImpl(this.invocationContainerImpl, invocationMatcher);
                verificationMode.verify(data);
                return null;
            }
            this.mockingProgress.verificationStarted(verificationMode);
        }
        this.invocationContainerImpl.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbing = new OngoingStubbingImpl(this.invocationContainerImpl);
        this.mockingProgress.reportOngoingStubbing(ongoingStubbing);
        StubbedInvocationMatcher stubbedInvocation = this.invocationContainerImpl.findAnswerFor(invocation);
        if (stubbedInvocation != null) {
            stubbedInvocation.captureArgumentsFrom(invocation);
            return stubbedInvocation.answer(invocation);
        }
        Object ret = this.mockSettings.getDefaultAnswer().answer(invocation);
        this.invocationContainerImpl.resetInvocationForPotentialStubbing(invocationMatcher);
        return ret;
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T mock) {
        return new VoidMethodStubbableImpl<T>(mock, this.invocationContainerImpl);
    }

    @Override
    public MockSettingsImpl getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public void setAnswersForStubbing(List<Answer> answers) {
        this.invocationContainerImpl.setAnswersForStubbing(answers);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainerImpl;
    }
}

